/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package featuresprojection;

import datamining.normalization.NormalizationComp;
import datamining.normalization.NormalizationFactory;
import distance.DistanceMatrix;
import distance.dissimilarity.AbstractDissimilarity;
import distance.dissimilarity.DissimilarityFactory;
import featuresprojection.technique.ProjectionFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import matrix.AbstractMatrix;
import matrix.MatrixFactory;
import projection.technique.Projection;

/**
 *
 * @author renato
 */
public class FeaturesProjection {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws IOException {
        
        List<String> params = Arrays.asList(args);
        
        String projName = getProjName(params);     
        String matrixName = getMatrixName(params);
        
                 
        AbstractMatrix matrix= null;
        DistanceMatrix dmat = null;
        if (matrixName.endsWith(".data")) {
            matrix = MatrixFactory.getInstance(matrixName);
            
            if (params.indexOf("-normalize") != -1) {
                NormalizationComp normalizationComp = new NormalizationComp();
                normalizationComp.input(matrix);
                normalizationComp.setNormalizationType(NormalizationFactory.NormalizationType.NORMALIZE_COLUMNS);
                normalizationComp.execute();
                matrix = normalizationComp.output();
            }   
        } else {
            dmat = new DistanceMatrix(matrixName);
        }
        
        
        AbstractDissimilarity ad = getDissimilarity(params);
        
        AbstractMatrix projected = null;        
        Projection proj = ProjectionFactory.getTechnique(projName, params);
        
        if (matrix != null)
            projected = proj.project(matrix, ad);
        else
            projected = proj.project(dmat);
        
        String projectedName;
        if (matrixName.endsWith(".data")) {
            int extensionIndex = matrixName.lastIndexOf(".data");
            projectedName = matrixName.substring(0, extensionIndex) + ".2d";
           //  = matrixName.replaceAll(".data", ".2d");
        }
        else {
            //projectedName = matrixName.replaceAll(".dmat", ".2d");
            
            int extensionIndex = matrixName.lastIndexOf(".dmat");
            projectedName = matrixName.substring(0, extensionIndex) + ".2d";            
        }
        
        projected.save(projectedName);
                
    }
    
    private static String getProjName(List<String> params) {
               
        int techniqueIndex = params.indexOf("-technique");
        if (techniqueIndex != -1)
            return params.get(techniqueIndex+1);
        else {
            System.err.println("You must provite a projection technique name: -technique \"name\"");
            System.exit(-1);
        }       
        return null;
    }
    
    private static String getMatrixName(List<String> params) {
        int matrixIndex = params.indexOf("-f");
        if (matrixIndex != -1)
            return params.get(matrixIndex+1);
        else {
            System.err.println("You must provite a matrix file: -f \"matrix_file\"");
            System.exit(-1);
        }
        
        return null;
    }
    
    private static AbstractDissimilarity getDissimilarity(List<String> params) {
        
        AbstractDissimilarity ad;
        
        int dissIndex = params.indexOf("-dissimilarity");
        if (dissIndex != -1) {
            String dissName = params.get(dissIndex+1);
            if (dissName.equals("euclidean"))
                ad = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
            else
                ad = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.COSINE_BASED);
        }
        else {
            ad = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        }
        
        return ad;       
    }
}
