/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package featuresprojection.technique;

import datamining.sampling.Sampling;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lamp.technique.LAMPProjection;
import lsp.technique.LSPProjection2D;
import matrix.AbstractMatrix;
import matrix.MatrixFactory;
import projection.technique.Projection;
import projection.technique.idmap.IDMAPProjection;
import projection.technique.mds.ClassicalMDSProjection;
import projection.technique.pca.PCAProjection;
import projection.technique.sammon.SammonMappingProjection;

/**
 *
 * @author renato
 */
public class ProjectionFactory {
    
    public static Projection getTechnique(String name, List<String> params) {
        
        if (name.toLowerCase().equals("idmap"))
            return getIDMAP(params);
        else if (name.toLowerCase().equals("lamp"))
            return getLAMP(params);
        else if (name.toLowerCase().equals("lsp"))
            return getLSP(params);
        else if (name.toLowerCase().equals("pca"))
            return getPCA(params);
        else if (name.toLowerCase().equals("mds"))
            return getMDS(params);
        else if (name.toLowerCase().equals("sammon"))
            return getSammonMapping(params);
        else
            return null;
    }
    
    private static Projection getSammonMapping(List<String> params) {
        SammonMappingProjection sammon = new SammonMappingProjection();
        sammon.setMagicFactor(0.3f);
        
        int nrIterationsIndex = params.indexOf("-iterations");
        if (nrIterationsIndex == -1)
            sammon.setNumberIterations(50);
        else
            sammon.setNumberIterations(Integer.valueOf(params.get(nrIterationsIndex+1)));
        
        return sammon;
    }
    
    private static Projection getIDMAP(List<String> params) {
        IDMAPProjection idmap = new IDMAPProjection();
        
        int fractionDeltaIndex = params.indexOf("-fractiondelta");
        if (fractionDeltaIndex == -1)
            idmap.setFractionDelta(8.0f);
        else
            idmap.setFractionDelta(Float.valueOf(params.get(fractionDeltaIndex+1)));
        
        int nrIterationsIndex = params.indexOf("-iterations");
        if (nrIterationsIndex == -1)
            idmap.setNumberIterations(50);
        else
            idmap.setNumberIterations(Integer.valueOf(params.get(nrIterationsIndex+1)));
        
        idmap.setInitialization(IDMAPProjection.InitializationType.FASTMAP);
        
        return idmap;
    }
    
    private static Projection getLSP(List<String> params) {
        LSPProjection2D lsp = new LSPProjection2D();
        
        int sampleProjectionIndex = params.indexOf("-sampleprojection");
        if (sampleProjectionIndex != -1) {
            try {
                AbstractMatrix sampleProjection = MatrixFactory.getInstance(params.get(sampleProjectionIndex+1));
                lsp.setSampleProjection(sampleProjection);
                
                AbstractMatrix matrix;
                AbstractMatrix sampleMatrix = null;
                ArrayList<String> sampleLabels = new ArrayList<String>();
                int matrixIndex = params.indexOf("-f");
                if (matrixIndex != -1) {
                    matrix = MatrixFactory.getInstance(params.get(matrixIndex+1));
                    
                    ArrayList<Integer> matrixIds = matrix.getIds();
                    sampleMatrix = MatrixFactory.getInstance(matrix.getClass());
                    int line;
                    String label;
                    for (Integer sampleId: sampleProjection.getIds()) {
                        line = matrixIds.indexOf(sampleId);
                        if (line == -1) {
                            System.err.println("Error! Sample id " + sampleId + " not found on points matrix!");
                            continue;
                        }
                        sampleMatrix.addRow(matrix.getRow(line));
                        label = matrix.getLabel(line);
                        if (label != null)
                            sampleLabels.add(label);
                    }
                    sampleMatrix.setLabels(sampleLabels);
                    sampleMatrix.setAttributes(matrix.getAttributes());
                }              
                lsp.setSampleMatrix(sampleMatrix);
                
                
            } catch (IOException ex) {
                Logger.getLogger(ProjectionFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        int sampleSizeIndex = params.indexOf("-samplesize");
        if (sampleSizeIndex == -1)
            lsp.setSampleSize(-1);
        else
            lsp.setSampleSize(Integer.valueOf(params.get(sampleSizeIndex+1)));
        
        int nrNeighborsIndex = params.indexOf("-neighbors");
        if (nrNeighborsIndex == -1)
            lsp.setNumberNeighbors(10);
        else
            lsp.setNumberNeighbors(Integer.valueOf(params.get(nrNeighborsIndex+1)));
        
        lsp.setSampleType(Sampling.SampleType.CLUSTERING_MEDOID);
        
        return lsp;
    }
    
    private static Projection getLAMP(List<String> params) {
        LAMPProjection lamp = new LAMPProjection();
            
        int fractionDeltaIndex = params.indexOf("-fractiondelta");
        if (fractionDeltaIndex == -1)
            lamp.setFractionDelta(8.0f);
        else
            lamp.setFractionDelta(Float.valueOf(params.get(fractionDeltaIndex+1)));
        
        int nrIterationsIndex = params.indexOf("-iterations");
        if (nrIterationsIndex == -1)
            lamp.setNumberIterations(100);
        else
            lamp.setNumberIterations(Integer.valueOf(params.get(nrIterationsIndex+1)));

        int sampleSizeIndex = params.indexOf("-samplesize");
        if (sampleSizeIndex == -1)
            lamp.setSampleSize(0);
        else
            lamp.setSampleSize(Integer.valueOf(params.get(sampleSizeIndex+1)));
             
        lamp.setSampleType(Sampling.SampleType.CLUSTERING_MEDOID);
        
        int sampleProjectionIndex = params.indexOf("-sampleprojection");
        if (sampleProjectionIndex != -1) {
            try {
                AbstractMatrix sampleProjection = MatrixFactory.getInstance(params.get(sampleProjectionIndex+1));
                lamp.setSampleProjection(sampleProjection);
                
                AbstractMatrix matrix;
                AbstractMatrix sampleMatrix = null;
                ArrayList<String> sampleLabels = new ArrayList<String>();
                int matrixIndex = params.indexOf("-f");
                if (matrixIndex != -1) {
                    matrix = MatrixFactory.getInstance(params.get(matrixIndex+1));
                    
                    ArrayList<Integer> matrixIds = matrix.getIds();
                    sampleMatrix = MatrixFactory.getInstance(matrix.getClass());
                    int line;
                    String label;
                    for (Integer sampleId: sampleProjection.getIds()) {
                        line = matrixIds.indexOf(sampleId);
                        if (line == -1) {
                            System.err.println("Error! Sample id " + sampleId + " not found on points matrix!");
                            continue;
                        }
                        sampleMatrix.addRow(matrix.getRow(line));
                        label = matrix.getLabel(line);
                        if (label != null)
                            sampleLabels.add(label);
                    }
                    sampleMatrix.setLabels(sampleLabels);
                    sampleMatrix.setAttributes(matrix.getAttributes());
                }              
                lamp.setSampleMatrix(sampleMatrix);
                
                
            } catch (IOException ex) {
                Logger.getLogger(ProjectionFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        
        
        return lamp;
    }    
    
    private static Projection getPCA(List<String> params) {
        PCAProjection pcaproj = new PCAProjection();
        
        return pcaproj;        
    }    
        
    private static Projection getMDS(List<String> params) {
        ClassicalMDSProjection mdsProj = new ClassicalMDSProjection();
        
        return mdsProj;        
    }    
    
}
