import os

cimport numpy as np
import numpy as np
np.import_array()

from includes.iftImage cimport iftImage
from includes.iftImage cimport iftReadImageP5
from includes.iftImage cimport iftReadImageP6
from includes.iftImage cimport iftDestroyImage


cdef class IftImage(object):
    """Wrapper for iftImage"""    
    
    cdef iftImage *image  
    cdef public object shape
    
    def __init__(self, filepath = None):
        """Load a pgm or ppm image given filepath"""
        if not os.path.isfile(filepath):
            raise Exception('File not found.')
        
        if filepath.endswith('pgm'):
            self.image = iftReadImageP5(filepath)
        elif filepath.endswith('ppm'):
            self.image = iftReadImageP6(filepath)
        else:
            raise Exception('Invalid filetype')
     
        self.shape = (int(self.image.xsize), int(self.image.ysize), int(self.image.zsize))

    def __array__(self):
        """Transform this object into a numpy array"""
        if self.image.zsize > 1:
            raise Exception('3D image conversion to array not supported')
        
        cdef np.npy_intp shape[2]
        shape[0] = <np.npy_intp> self.image.ysize
        shape[1] = <np.npy_intp> self.image.xsize
        array = np.PyArray_SimpleNewFromData(2, shape, np.NPY_INT, self.image.val)
        return array

    def __dealloc__(self):
        """Automatically destroy the iftImage when this object is deallocated"""
        iftDestroyImage(&self.image)
