from iftFHeap cimport iftFHeap
from iftDataSet cimport iftDataSet

cdef extern from "iftClassification.h":
    ctypedef struct iftCplNode:
        int   pred     # predecessor node
        int   sample   # corresponding training sample in Z
        
    ctypedef struct iftCplGraph:
        iftCplNode *node          # node
        float      *pathval       #path value for each node
        int        *ordered_nodes # list of nodes ordered by path value 
        int         nnodes        # number of nodes
        iftFHeap   *Q             #priority queue
        iftDataSet *Z             #Each graph node is a training sample in Z
        
    iftCplGraph *iftCreateCplGraph(iftDataSet *Z)
    int iftClassify(iftCplGraph *graph, iftDataSet *Z)    
    
    void iftDestroyCplGraph(iftCplGraph **graph)
    void iftSupTrain(iftCplGraph *graph)