from iftFHeap cimport iftFHeap
from iftDataSet cimport iftDataSet
from iftAdjSet cimport iftAdjSet
from iftSet cimport iftSet

cdef extern from "iftClustering.h":
    ctypedef struct iftKnnNode:
        float maxarcw
        int   root 
        int   sample
        iftAdjSet *adj
        iftSet    *adjplat

    ctypedef struct iftKnnGraph:
        iftKnnNode *node
        float      *pathval
        int        *ordered_nodes
        int         nnodes
        float      *maxarcw
        int         kmax
        int         k
        iftFHeap   *Q
        iftDataSet *Z
        
    ctypedef float (*iftKnnGraphCutFun)(iftKnnGraph *graph)
    float iftKnnGraphCutFun3(iftKnnGraph *graph)

    iftKnnGraph *iftUnsupLearn(iftDataSet *Z, float kmax_perc, iftKnnGraphCutFun iftGraphCutFun, int niterations)
    int iftCluster(iftKnnGraph *graph, iftDataSet *Z)
    iftSet *iftGetKnnRootSamples(iftKnnGraph *graph)
    iftSet *iftGetKnnBoundarySamples(iftKnnGraph *graph)

    void iftDestroyKnnGraph(iftKnnGraph **graph)
    