import numpy as np
cimport numpy as np
np.import_array()

from iftMatrix cimport iftMatrix

cdef extern from "iftDataSet.h":
    cdef int TRAIN
    cdef int TEST
    
    ctypedef float (*iftArcWeightFun)(float *f1, float *f2, float *alpha, int n)
    
    ctypedef struct iftSample:
        float *feat
        int truelabel
        int label
        int id
        float weight
        unsigned char status
        
    ctypedef struct iftFeatSpaceParam:
        float *mean
        float *stdev
        int nfeats
        char *w
        int ncomps
        iftMatrix *R
        iftMatrix *W
    
    ctypedef struct iftDataSet:
        iftSample *sample
        int nfeats
        int nsamples
        int nlabels
        int nclasses
        int ntrainsamples
        iftArcWeightFun iftArcWeight
        float *alpha
        void *ref_data
        iftFeatSpaceParam fsp
        
    iftDataSet *iftCreateDataSet(int nsamples, int nfeats)
    void iftDestroyDataSet(iftDataSet **Z)
    iftDataSet *iftReadOPFDataSet(char *filename)
    void iftSetStatus(iftDataSet *Z, unsigned char status)
    iftDataSet *iftCopyDataSet(iftDataSet *Z)