from iftSet cimport iftSet
from iftDataSet cimport iftDataSet
from iftClassification cimport iftCplGraph

cdef extern from "iftMST.h":
    cdef int INCREASING
    cdef int DECREASING    
    
    ctypedef struct iftMSTNode:
        int   sample
        iftSet  *adj
        int maxarcadj
        char color
    
    ctypedef struct iftMST:
        iftMSTNode *node    
        int         nnodes  
        float       maxarcw
        float       minarcw
        iftDataSet *Z
        
    iftMST *iftCreateMSTFromSet(iftDataSet *Z, iftSet* samples)
    void iftDestroyMST(iftMST **mstree)
    void iftSortNodesByWeightMST(iftMST *mstree, int order) 
    iftSet *iftGetMSTBoundarySamples(iftCplGraph *graph, iftMST *mst, int nsamples)
    void iftSortNodesByWeightMST(iftMST *mstree, int order)