cdef extern from "iftSet.h":
    ctypedef struct iftSet:
        int elem
        iftSet *next
    
    cdef void iftDestroySet(iftSet **S)
    cdef void iftInsertSet(iftSet **S, int elem)

cdef inline iftSet_to_set(iftSet *ift_set):
    s = set()
    
    while ift_set:
        s.add(int(ift_set.elem))
        ift_set = ift_set.next
        
    return s
    
cdef inline iftSet_to_list(iftSet *ift_set):
    s = []
    
    while ift_set:
        s.append(int(ift_set.elem))
        ift_set = ift_set.next
        
    return s
    
cdef inline iftSet* list_to_iftSet(l):
    cdef iftSet *s = NULL
    
    for element in reversed(l):
        iftInsertSet(&s, int(element))
    
    return s