#ifndef IFT_IGRAPH_H_
#define IFT_IGRAPH_H_

#ifdef __cplusplus
extern "C" {
#endif

  /* TODO LIST: iftRegionIGraph (graph of superpixels from label
     image), iftSurfaceIGraph (graph of 2D/3D object surface), and all
     IFTs */ 

#include "iftCommon.h"
#include "iftImage.h"
#include "iftMImage.h"
#include "iftAdjacency.h"
#include "iftSet.h"
#include "iftFHeap.h"

#define   COMPLETE 0 /* graph where all nodes are adjacent to each other */  
#define   EXPLICIT 1 /* graph with adjacency list of the nodes */
#define   IMPLICIT 2 /* graph with translation-invariant adjacency relation */

typedef struct ift_inode {
  int     voxel; /* voxel (or supervoxel representative) */
  iftSet *adj;   /* index list to adjacent nodes (explicit graphs only) */
} iftINode;

typedef struct ift_igraph {
  iftINode   *node;    /* list of graph nodes */
  int         nnodes;  /* number of graph nodes */
  int         nfeats;  /* number of image features */
  iftImage   *index;   /* node index */
  float     **feat;    /* image features */
  int        *label, *marker, *root, *pred; /* forest annotation */
  float      *pvalue; /* forest annotation */
  iftAdjRel  *A;       /* adjacency relation (implicit graphs only) */
  char        type;    /* COMPLETE, IMPLICIT, EXPLICIT */
} iftIGraph;

  /* graph with nodes indicated by mask values greater than 0. */

  iftIGraph *iftCompleteIGraph(iftMImage *img, iftImage *mask); 
 
  /* graph with nodes indicated by mask values greater than 0. The
   arcs are defined by the adjacency relation A */

  iftIGraph *iftImplicitIGraph(iftMImage *img, iftImage *mask, iftAdjRel *A);

  /* graph with nodes indicated by mask values greater than 0. The
   arcs are defined by the adjacency relation A and stored with the
   nodes. */

  iftIGraph *iftExplicitIGraph(iftMImage *img, iftImage *mask, iftAdjRel *A);

  /* graph with nodes defined by mask and arcs defined by the k
     closest neighbors within adjacency A */
 
  iftIGraph *iftSpatialKnnIGraph(iftMImage *img, iftImage *mask, iftAdjRel *A, int K);

  /* graph with nodes indicated by mask and arcs defined by the k
     closest neighbors */
 
  iftIGraph *iftKnnIGraph(iftMImage *img, iftImage *mask, int K);

  /* Destroy image graph from memory */

  void       iftDestroyIGraph(iftIGraph **igraph);
  
  /* Estimate the PDF of the graph nodes */
  
  void iftIGraphPDF(iftIGraph *igraph);
  
  /* Get path value image */

  iftImage *iftIGraphPathValue(iftIGraph *igraph);
  
  /* Get label image */
  
  iftImage *iftIGraphLabel(iftIGraph *igraph);
  
  /* Compute clusters among the graph nodes and, for explicit graphs,
     propagate labels to the remaining voxels when
     label_propagation=1 */

  void iftIGraphClusters(iftIGraph *igraph, char label_propagation);

  /* Compute superpixels by using the IFT-SLIC algorithm */
  
  void iftIGraphIFTSLIC(iftIGraph *igraph, iftImage *seeds, float alpha, float beta, int niters);



#ifdef __cplusplus
}
#endif

#endif

