/**
 * @file iftUtil.h
 * @brief Structs and function prototypes for several Utilities, such that file management, strings, etc.
 * 
 * An example of file management is found in demo/Miscelaneuous/iftFiles.c
 * 
 * @author Samuel Martins (sbmmartins)
 */

#ifndef _IFT_UTIL_H_
#define _IFT_UTIL_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "iftCommon.h"
#include <sys/stat.h>


#define FILE_TYPE 0
#define DIR_TYPE 1
#define COLOR_BLUE "\x1B[34m"
#define COLOR_RESET "\033[0m"


typedef struct _ift_file {
    char pathname[512];
    char type; /* FYLE_TYPE or DIR_TYPE */
    char exists; /* it shows if the file/dir is stored on disk */
    int nchilds; /* Number of files from the directory */
    struct _ift_file **childs; /* vector of iftFiles with the childs */
} iftFile;


iftFile *iftCreateFile(char *pathname);
iftFile *iftCreateDir(char *dir_pathname, int list_subdirs);
void iftDestroyFile(iftFile **file);
void iftDestroyDir(iftFile **dir);

iftFile *iftLoadFilesFromDirectory(char *dir_pathname, char *extension);

void iftPrintFileInfo(iftFile *f);
void iftPrintDirAsTree(iftFile *dir);

int iftFileExists(iftFile *f);
int iftFileExists2(char *pathname);
int iftDirectoryExists(iftFile *f);
int iftDirectoryExists2(char *pathname);

int iftIsFileEmpty(FILE *fp);

iftFile *iftGetParentDir(char *pathname);
char *iftGetParentDir2(char *pathname);

void iftMakeDir(iftFile *dir);
void iftMakeDir2(char *pathname);
char *iftMakeTempFile(void);

int iftEndswith (char *string, char *suffix);
char *iftSmartSplitString(char *phrase, char *delimiter, int position);





#ifdef __cplusplus
}
#endif

#endif