from distutils.core import setup
from distutils.extension import Extension
from Cython.Build import cythonize

import os

#This environment variable should point to your libift source folder
try:
    libift = os.environ['NEWIFT_DIR']
except:
    libift= os.path.abspath('./libift_dist')

libift_include = os.path.join(libift,'include')
libift_lib = os.path.join(libift,'lib')

libsvm_include = os.path.join(libift, 'libsvm')
libsvm_lib = os.path.join(libift, 'libsvm')

libraries = [ 'ift', 'svm', 'lapack', 'blas', 'm' ]
include_dirs = [libift_include, libsvm_include, 'includes']
library_dirs = [libift_lib, libsvm_lib]
extra_compile_args = ["-O3", "-fopenmp", "-pthread", "-std=gnu99", "-pedantic"]
extra_link_args    = ["-lgomp", "-fopenmp", "-lstdc++"] # -lstdc++ is required to the libSVM

ext_modules=[
            Extension("image",
                    sources=["image.pyx"],
                    include_dirs = include_dirs,
                    libraries = libraries,
                    library_dirs = library_dirs,
                    extra_compile_args = extra_compile_args,
                    extra_link_args = extra_link_args
                    ),
            Extension("opf",
                    sources=["opf.pyx"],
                    include_dirs = include_dirs,
                    libraries = libraries,
                    library_dirs = library_dirs,
                    extra_compile_args = extra_compile_args,
                    extra_link_args = extra_link_args
                    ),
            Extension("active_learning",
                    sources=["active_learning.pyx"],
                    include_dirs = include_dirs,
                    libraries = libraries,
                    library_dirs = library_dirs,
                    extra_compile_args = extra_compile_args,
                    extra_link_args = extra_link_args
                    )
            ]

setup(
  ext_modules = cythonize(ext_modules)
)# -*- coding: utf-8 -*-

print('Finished wrapping {0}.'.format(libift))