import projection
import feature_scoring

import pyqtgraph as pg


class FeaturedSettings:

    def __init__(self):
        p = pg.parametertree.Parameter.create(name='Settings', type='group',
                                              children=model_default_params)

        self.parameter_state = p.saveState()
        self.parameter_values = p.getValues()

    def parameter(self, param):
        if param == 'normalization':
            return self.parameter_values['Data'][1]['Normalization'][0]
        elif param == 'distance':
            return self.parameter_values['Data'][1]['Dissimilarity function'][0]
        elif param == 'technique':
            return self.parameter_values['Observation projection'][1]['Technique'][0]
        elif param == 'technique_options':
            technique = self.parameter_values['Observation projection']\
                                             [1]['Technique'][0]
            technique_opts_tree = self.parameter_values['Observation projection']\
                [1]['Technique options'][1][technique + ' options'][1]

            return {u: v[0] for u, v in technique_opts_tree.items()}
        elif param == 'neighbors':
            return int(self.parameter_values['Observation projection']
                       [1]['Point Dragging'][1]
                       ['Number of neighbors'][0])
        elif param == 'preserve':
            return float(self.parameter_values['Observation projection']
                         [1]['Point Dragging'][1]
                         ['Feature preservation ratio'][0])
        elif param == 'feature_scoring':
            return str(self.parameter_values['Observation projection']
                       [1]['Point Dragging'][1]
                       ['Feature scoring'][0])
        elif param == 'classification':
            return str(self.parameter_values['Observation projection']
                       [1]['Classification'][1]
                       ['Technique'][0])
        elif param == 'classification_opts':
            technique = str(self.parameter_values['Observation projection']
                       [1]['Classification'][1]
                       ['Technique'][0])
            technique_opts_tree = self.parameter_values['Observation projection']\
                       [1]['Classification'][1]['Technique options'][1][technique + ' options'][1]
            return {u: v[0] for u, v in technique_opts_tree.items()}
        elif param == 'classification_nfolds':
            return str(self.parameter_values['Observation projection']
                       [1]['Classification'][1]
                       ['Number of folds'][0])
        elif param == 'correlation':
            return str(self.parameter_values['Observation projection'][1]
                       ['Correlation with axis'][1]['Technique'][0])
        elif param == 'feature_dissimilarity':
            return str(self.parameter_values['Feature projection']
                       [1]['(Dis)Similarity'][0])
        elif param == 'feature_projection_technique':
            return str(self.parameter_values['Feature projection'][1]
                       ['Technique'][0])
        elif param == 'feature_projection_technique_opts':
            technique = str(self.parameter_values['Feature projection'][1]
                            ['Technique'][0])
            technique_opts_tree = self.parameter_values['Feature projection'][1]\
                ['Technique options'][1][technique + ' options'][1]
            return {u: v[0] for u, v in technique_opts_tree.items()}
        elif param == 'features_n_neighbors':
            return int(self.parameter_values['Feature projection']
                       [1]['Plot coloring'][1]
                       ['Number of neighbors'][0])
        elif param == 'feature_lensing_color':
            return str(self.parameter_values['Feature projection']
                       [1]['Lensing'][1]
                       ['Color by'][0])
        elif param == 'observation_lensing_color':
            return str(self.parameter_values['Observation projection']
                       [1]['Lensing'][1]
                       ['Color by'][0])
        elif param == 'active_learning_suggestions_per_step':
            return int(self.parameter_values['Observation projection']
                       [1]['Active Learning'][1]
                       ['Suggestions per step'][0])
        elif param == 'active_learning_kmax_percentage':
            return float(self.parameter_values['Observation projection']
                         [1]['Active Learning'][1]
                         ['K-max percentage'][0])
        elif param == 'active_learning_clustering_iterations':
            return int(self.parameter_values['Observation projection']
                       [1]['Active Learning'][1]
                       ['Number of clustering iterations'][0])

    def set_parameter_state(self, state, values):
        self.parameter_state = state
        self.parameter_values = values

    def parameter_tree(self):
        p = pg.parametertree.Parameter.create(name='Settings', type='group',
                                              children=model_default_params)

        p.restoreState(self.parameter_state)

        return p

norm_opts = {'name': 'Normalization', 'type': 'list', 'values':
             ['Scaling', 'Standardization', 'None'], 'default': 'Scaling'}

dist_opts = {'name': 'Dissimilarity function', 'type': 'list', 'values':
             ['Euclidean', 'Cosine'], 'default': 'Euclidean'}

data_opts = {'name': 'Data', 'type': 'group',
             'children': [norm_opts, dist_opts]}

tech_names = projection.available_observation_techniques.keys()
tech_opts = {'name': 'Technique options', 'type': 'group', 'children':
             projection.available_observation_techniques.values()}

feat_corr_opts = ['Pearson\'s r', 'Spearman\'s r']
feat_opts = {'name': 'Correlation with axis',
             'type': 'group', 'children':
             [{'name': 'Technique',
               'type': 'list', 'values': feat_corr_opts, 'value': 'Pearson\'s r'}]}

classifiers = {'K-Nearest neighbors' : {'name': 'K-Nearest neighbors options', 
                                        'type': 'group', 'children': [{'name': 'Number of neighbors',
                                                                       'type': 'int', 'value': '5'}]}, 
               'Logistic Regression' : {'name': 'Logistic Regression options', 'type': 'group', 'children': []},
               
               'RBF Support vector machine' : {'name': 'RBF Support vector machine options', 
                                               'type': 'group', 'children': 
                                                   [{'name': 'Gamma','type': 'float', 'value': '0'}, 
                                                    {'name' : 'C', 'type' : 'float', 'value' : '1'}]}, 
               
               'Linear Support vector machine' : {'name': 'Linear Support vector machine options', 
                                                  'type': 'group', 
                                                  'children': [{'name' : 'C', 'type' : 'float', 'value' : '1'}]},
               
               'Random Forest Classifier' : {'name': 'Random Forest Classifier options', 
                                             'type': 'group', 'children': 
                                                 [{'name': 'Number of estimators','type': 'int', 'value': '10'}, 
                                                  {'name' : 'Maximum depth', 'type' : 'int', 'value' : '0'}]},
 
               'Optimum Path Forest' : {'name': 'Optimum Path Forest options', 'type': 'group', 'children': []}}

classif_opts = {'name': 'Classification', 'type': 'group', 'children':
                [{'name': 'Technique', 'type': 'list',
                  'values': classifiers.keys(), 'value': 'K-Nearest neighbors'},
                  {'name': 'Number of folds', 'type' : 'int', 'value' : '10'},
                    {'name': 'Technique options', 'type': 'group', 'children': 
                        classifiers.values()} ]}

feat_score_opts = feature_scoring.available_methods.keys()

mov_opts = {'name': 'Point Dragging',
            'type': 'group', 'children':
            [{'name': 'Number of neighbors',
              'type': 'int', 'value': '6'},
             {'name': 'Feature preservation ratio',
              'type': 'float', 'value': '0.66', 'step': 0.1},
             {'name': 'Feature scoring',
              'type': 'list',
              'values': feat_score_opts, 'value': 'randomized_trees'}]
            }

obs_plot_color_by = ["Class", "Classification (k-fold)", "Classification error (k-fold)",
                     'Classification (AL)', 'Classification error (AL)',
                     "Feature", "Projection Error", 'Relation Support', 
                     'Prediction (knn)', 'Prediction (rfc)', 'Prediction (svm)', 'Prediction (ffnn)']

obs_plot_lensing = {'name': 'Lensing', 'type': 'group',
                    'children': [{'name': 'Color by', 'type': 'list',
                                  'values': obs_plot_color_by,
                                  'value': 'Classification'}]}

active_learning_opts = {'name': 'Active Learning', 'type': 'group',
                        'children': [
                                {'name': 'Suggestions per step', 'type': 'int',
                                 'value': '10'},
                            {'name': 'K-max percentage', 'type': 'float',
                                    'value': '0.1', 'step': '0.1'},
                            {'name': 'Number of clustering iterations',
                                    'type': 'int', 'value': '10'}
                        ]
                        }

obs_proj_opts = {'name': 'Observation projection', 'type': 'group',
                 'children': [{'name': 'Technique', 'type': 'list',
                               'values': tech_names, 'value': 't-SNE'},
                              tech_opts, feat_opts, classif_opts, mov_opts, obs_plot_lensing,
                              active_learning_opts]}

feature_distances = ['Pearson\'s r', 'Spearman\'s r',
                     'Transposed data matrix distance',
                     'Distance correlation', 'Mutual information']

dmat_tech_names = projection.available_distance_matrix_techniques.keys()
dmat_tech_opts = {'name': 'Technique options', 'type': 'group', 'children':
                  projection.available_distance_matrix_techniques.values()}

feat_plot_coloring = {'name': 'Plot coloring', 'type': 'group',
                      'children': [{'name': 'Number of neighbors',
                                    'type': 'int', 'value': '6'}, ]}


feat_plot_color_by = ['None', 'Score', 'Neighborhood Relation']
feat_plot_lensing = {'name': 'Lensing', 'type': 'group',
                     'children': [{'name': 'Color by', 'type': 'list',
                                   'values': feat_plot_color_by,
                                   'value': 'Neighborhood Relation'}]}

feat_proj_opts = {'name': 'Feature projection',
                  'type': 'group', 'children':
                  [{'name': '(Dis)Similarity', 'type': 'list',
                      'value': 'Pearson\'s r',
                    'values': feature_distances},
                   {'name': 'Technique', 'type': 'list',
                      'values': dmat_tech_names, 'value': 'MDS'},
                   dmat_tech_opts, feat_plot_coloring, feat_plot_lensing]
                  }


model_default_params = [data_opts, obs_proj_opts, feat_proj_opts]
