def load(f):
    """Load f specifying a feature hierarchy and return as a dict."""
    tree = {}
    for l in f.readlines():
        feats = l.strip().split(';')
        tree[feats[0]] = set(feats[1:])
    
    return tree

def save(tree, f):
    for k,v in tree.items():
        f.write(';'.join([k] + sorted(v)) + '\n')