#!/usr/bin/python2.7
'''
Created on Jan 20, 2015

@author: paulorauber
'''
from sklearn import datasets
from model.parsing import point_matrix

import os
from skimage import transform
from skimage import io

def write_synthetic():
    f = open('features.data','w')

    n_samples=1000    
    
    X, y = datasets.make_blobs(n_samples=n_samples, random_state=8)
#    X, y = datasets.make_circles(n_samples=n_samples, factor=.5, noise=.05)
#    X, y = datasets.make_moons(n_samples=n_samples, noise=.05)
#    X, y = np.random.rand(n_samples, 2), np.random.randint(0, 3, n_samples)
#    
#    X, y = datasets.make_classification(n_samples=n_samples)
    
    point_matrix.save(f, X, y, [ 's{0:0>4d}.png'.format(i) for i in range(len(y))], ['f{0}'.format(i) for i in range(X.shape[1]) ])
    
    f.close()

def write_iris():
    f = open('features.data','w')
    
    dataset = datasets.load_iris()
    X = dataset.data
    y = dataset.target
    
    point_matrix.save(f, X, y, [ 's{0:0>3d}'.format(i) for i in range(len(y))], ['sepall', 'sepalw','petall','petalw'])
    
    f.close()

def write_digits():
    f = open('features.data','w')
    
    dataset = datasets.load_digits()
    X = dataset.data
    y = dataset.target
    
    point_matrix.save(f, X, y, [ 's{0:0>4d}.png'.format(i) for i in range(len(y))], ['f{0}'.format(i) for i in range(X.shape[1]) ])
    
    f.close()
    
    output_images_dir = 'orig'
    if not os.path.exists(output_images_dir):
        os.makedirs(output_images_dir)
        
    for i in range(len(y)):
        img = X[i].reshape((8,8))
        img = transform.resize(img/16., (100,100), order = 0)
        io.imsave(os.path.join(output_images_dir, 's{0:0>4d}.png'.format(i)), img)

def main():
#     write_iris()
#     write_digits()
    write_synthetic()

if __name__ == '__main__':
    main()