from PyQt4 import QtCore, QtGui
import pyqtgraph as pg
from math import sqrt

class FeaturedViewBox(pg.ViewBox): # @UndefinedVariable
    sigPointsSelected = QtCore.pyqtSignal(object, object)
    
    sigPointReleased = QtCore.pyqtSignal(object, object)
    sigPointDragged = QtCore.pyqtSignal(object, object)
    
    sigPointHovered = QtCore.pyqtSignal(object)

    def __init__(self, boxPen=pg.mkPen((0, 0, 0), width=1), 
                 boxBrush=pg.mkBrush(255, 255, 255, 100), *args, **kwds):
        pg.ViewBox.__init__(self, *args, **kwds) # @UndefinedVariable
        self.rbScaleBox.setPen(boxPen)
        self.rbScaleBox.setBrush(boxBrush)
        
        self.dragged_point = None
        self.scatter = None
        
        self.item_names = None
        
        self.tooltip = pg.TextItem(text='',anchor = (1,1), # @UndefinedVariable
            border = pg.mkPen('#000000', width = 1), 
            fill = pg.mkBrush(255,255,255,200))
        self.tooltip.hide()
        
        self.circle = pg.QtGui.QGraphicsEllipseItem(0, 0, 1,1)
        self.circle.setBrush(pg.mkBrush(0,0,0,10))
        self.circle.setPen(pg.mkPen(0,0,0,20))
        self.circle.hide()
        
        self.circle_ratio = 0.10
        
    def addItem(self, item, ignoreBounds = False):
        pg.ViewBox.addItem(self, item, ignoreBounds)
        
        if isinstance(item, pg.ScatterPlotItem):
            self.scatter = item
            self.autoRange()
            
            if self.tooltip.scene():
                self.removeItem(self.tooltip)
            self.addItem(self.tooltip)
            self.addItem(self.circle)
            
    def mouseDragEvent(self, ev, axis=None):
        if ev.button() & (QtCore.Qt.RightButton | QtCore.Qt.MidButton):
            pg.ViewBox.mouseDragEvent(self, ev, axis) # @UndefinedVariable

        ev.accept()
        
        if ev.button() & QtCore.Qt.LeftButton:
            if ev.isStart():
                points = self.scatter.pointsAt(self.mapToView(ev.buttonDownPos()))
                if points:
                    self.dragged_point = points[0]
                else:
                    self.dragged_point = None
                    
            elif ev.isFinish():
                if self.dragged_point:
                    posview = self.mapToView(ev.pos())
                    self.sigPointReleased.emit(self.dragged_point.data(), 
                                               (posview.x(), posview.y()))
                else:
                    start = self.mapToView(ev.buttonDownPos())
                    end = self.mapToView(ev.pos())
        
                    xmin = min(start.x(), end.x())
                    xmax = max(start.x(), end.x())
                    ymin = min(start.y(), end.y())
                    ymax = max(start.y(), end.y())
                
                    rect_selection = set([])
                    for p in self.scatter.points():
                        pos = p.pos()
                        if xmin <= pos[0] <= xmax and ymin <= pos[1] <= ymax:
                            rect_selection.add(p.data())
    
                    rect_modifiers = QtGui.QApplication.keyboardModifiers()
                    self.rbScaleBox.hide()
                    
                    self.sigPointsSelected.emit(rect_modifiers, rect_selection)
                    
                    
                self.dragged_point = None
                
            else:
                if self.dragged_point:
                    posview = self.mapToView(ev.pos())
                    self.sigPointDragged.emit(self.dragged_point.data(), 
                                              (posview.x(), posview.y()))
                else:
                    self.updateScaleBox(ev.buttonDownPos(), ev.pos())
                 
    def set_item_names(self, item_names):   
        self.item_names = item_names
        
    def show_tooltip(self, show):
        if show:
            self.tooltip.show()
        else:
            self.tooltip.hide()
            
    def show_circle(self, show):
        if show:
            self.circle.show()
        else:
            self.circle.hide()
            
    def _reposition_circle(self, posview):
        self.circle_radius = self.viewPixelSize()[0]*\
            sqrt(self.rect().width()**2 + self.rect().height()**2)*self.circle_ratio
            
        posview_offset = posview - QtCore.QPointF(self.circle_radius, 
                                                  self.circle_radius)
                                                  
        self.circle.setRect(posview_offset.x(), posview_offset.y(),
                            self.circle_radius*2.0, self.circle_radius*2.0)
            
    def _handle_hovering(self, posview):
        points = self.scatter.pointsAt(posview)
        if points:
            i = points[0].data()
            self.tooltip.setText(self.item_names[i], color = pg.mkColor(0,0,0))
            self.tooltip.setPos(posview)
            
            self._reposition_circle(posview)
            
            self.sigPointHovered.emit(i)            
        else:
            self.sigPointHovered.emit(None)        
            
    def mouseMoveEvent(self, pos):
        if not self.scatter:
            return
        
        posview = self.mapToView(pos)
        self._handle_hovering(posview)
    
