#include <GL/glut.h>														//GLUT library
#include <stdio.h>

float fov	 = 60;																															//Perspective projection parameters
float aspect = 1;
float z_near = 0.1;
float z_far  = 30;

float eye_x = 10, eye_y = 10, eye_z = 10;																			//Modelview (camera extrinsic) parameters
float c_x   = 0,  c_y   = 0,  c_z   = 0;
float up_x  = 0,  up_y  = 0,  up_z  = 1;


void viewing(int W, int H)																										//Window resize function, sets up viewing parameters (GLUT callback function)
{
	glMatrixMode(GL_MODELVIEW);																									//1. Set the modelview matrix (including the camera position and view direction)
	glLoadIdentity ();
	gluLookAt(eye_x,eye_y,eye_z,c_x,c_y,c_z,up_x,up_y,up_z);

	glMatrixMode (GL_PROJECTION);																								//2. Set the projection matrix
	glLoadIdentity ();
	gluPerspective(fov,float(W)/H,z_near,z_far);

	glViewport(0,0,W,H);																												//3. Set the viewport to the entire size of the rendering window
}


void writePGM(const char* fname, int wd, int ht, unsigned char* data)					//Saves a block of wd*ht pixels (stored as unsigned bytes) as a PGM image file
{
	FILE* fp = fopen(fname,"wb");
	if (!fp) return;

	fprintf(fp, "P5 %d %d 255\n", wd, ht);																			//Write header of the PGM file
	for(int row=ht-1;row>=0;row--)																							//Write all ht pixel rows, but starting from the top of the window to the bottom
	{																																						//Recall, glReadPixels reads pixels in the opposite order (bottom-most pixel row is read first)
		 unsigned char* ptr = data + row*wd;
		 fwrite(ptr,sizeof(unsigned char),wd,fp);
	}

	fclose(fp);
}


void saveScreen()																															//Grab the image in the current window and save it to a PGM file
{
	int wd = glutGet(GLUT_WINDOW_WIDTH), ht = glutGet(GLUT_WINDOW_HEIGHT);			//Get sizes of the current window
	int rlen;
	glGetIntegerv(GL_PACK_ROW_LENGTH,&rlen);																		//Remember the current GL bytes-per-pixel row setting since we're going to change it
	glPixelStorei(GL_PACK_ROW_LENGTH,wd);																				//Set the bytes-per-pixel row parameters so that we read every pixel after each other next
	glPixelStorei(GL_PACK_ALIGNMENT,1);

	unsigned char* buffer = new unsigned char[wd*ht];														//Allocate memory to read the entire window
	glReadPixels(0,0,wd,ht,GL_RED,GL_UNSIGNED_BYTE,buffer);											//Read the red component of the pixels (we could read other components as well)
	glPixelStorei(GL_PACK_ROW_LENGTH,rlen);																			//Restore the bytes-per-pixel row parameters to whatever it was before we changed it
	writePGM("screencapture.pgm",wd,ht,buffer);																	//Write the data we read as a PGM image file
	delete[] buffer;
}




void draw()																																		//Render some test shape on the screen
{
	glClearColor(1,1,1,1);																											//Clear the frame and depth buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glColor3f(0,0,0);																													  //We render everything black and on a white background
	glDisable(GL_LIGHTING);																											//Hence, we can easily read the image and save it as a PGM file
  glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glutSolidCone(2,4,10,10);																										//Draw some dummy shape so we have something to read next

	glutSwapBuffers();																												  //Rendering ready, ask GLUT to show the back buffer
}

void keyboard(unsigned char key,int,int)																			//Simple function to save the image currently in the window upon pressing 's'
{
	switch(key)
	{
		case 's': saveScreen(); break;
	}
}


int main(int argc,char* argv[])																								//Main program
{
   glutInit(&argc, argv);																											//1. Initialize the GLUT toolkit
   glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);																//2. Ask GLUT to create next windows with a RGB framebuffer and a Z-buffer too
   glutInitWindowSize(500,500);																								//3. Tell GLUT how large are the windows we want to create next
   glutCreateWindow("Reading OpenGL window");																	//4. Create our window

   glutDisplayFunc(draw);																											//5. Add a drawing callback to the window
   glutReshapeFunc(viewing);																									//6. Add a resize callback to the window
	 glutKeyboardFunc(keyboard);																								//7. Add a keyboard callback to the window
   glutMainLoop();																														//8. Start the event loop that displays the graph and handles window-resize events

   return 0;
}
