#ifndef VOLUME_H
#define VOLUME_H

#include <vector>
#include "Image.h"

using namespace std;

template< class T >
class Volume {

  vector< Image< T > > slices;

 public:
  typedef struct {
    float coord[3];
  } point3;

  typedef vector< point3 > POINTS;
  typedef typename Volume<T>::point3 POINT3;

  //private:
  void bresenham_linie_3D(int x1, int y1, int z1, int x2, int y2, int z2, vector<point3> &points);

 public:

  Volume() {};
  Volume(int width, int height, int depth) : slices(depth) {
    for(register int i=0;i<depth;i++) 
      slices[i] = Image<T>(width, height);   
  }
  Volume(const Volume<T> &vol) {
    slices = vol.slices;
  }
  void makeVolume(int width, int height, int depth) {
    if(depth!=(int)slices.size()) {
      slices.erase(slices.begin(), slices.end());
      for(register int i=0;i<depth;i++) 
	slices.push_back(Image<T>(width, height));
    }    
  }
  static void readPoints(char *fname, vector<Volume<T>::point3> &points) {
    FILE *pfile=fopen(fname, "r");
    
    if(!pfile) return;

    while(!feof(pfile)) {
      point3 p;
      //fscanf(pfile, "p %f %f %f\n", &p.coord[0], &p.coord[1], &p.coord[2]);
    fscanf(pfile, "%f %f %f\n", &p.coord[0], &p.coord[1], &p.coord[2]);
    points.push_back(p);
    }
    fclose(pfile);
  }

  inline Image<T>& operator[](int z) {
    return slices[z];
  }
  
  inline T& operator()(int x, int y, int z) {
    return slices[z][y][x];
  }

  void toVector(vector<T> &vec);

  int getDepth() {
    return slices.size();
  }
  int getWidth() {
    return slices[0].getWidth();
  }
  int getHeight() {
    return slices[0].getHeight();
  }
  void clearVolume(T val) {
    for(register int i=0;i<(int)slices.size();++i) 
      slices[i].clearImage(val);
  }
  void clearVolume()
  {
    for(register int i=0;i<(int)slices.size();++i) 
      slices[i].clearImage();
  }
  
  static inline bool range(int x, int y, int z, 
			   int width, int height, int depth) {
    return (x>0 && y>0 && z>0 && z<depth && x<width && y<height);
  }
  void showSlices();
  void getMinMax(T &min, T &max);
  void scale(T value);
  void downsample(int down=2);
  void erode(int r);
  void dilate(int r);
  void grad_order6(Volume<float> &gx, Volume<float> &gy, Volume<float> &gz);

  void getSphere(int cx, int cy, int cz, int r, float val);

  void readStanfordVolume(char *rootfname, bool endian=true);
  void readVolume8(char *rootfname);
  void readOneFile8(char *fname, int dx, int dy, int dz);
  void readOneFile16(char *fname, int dx, int dy, int dz);

  //POINTS readPoints(char *fname, int mindim, int pad);
  POINTS readPoints_nuage_cnt(char *fname, int mindim, int pad);
  POINTS readPoints(char *fname, int mindim, int pad, float &dx, float &dy, float &dz);
  POINTS readRawPoints(char *fname, int mindim, int pad, float &dx, float &dy, float &dz);

  void writePointsCrust(char *fname, vector<point3> &points);
  void UniformSample(vector<point3> &points, float percent);

  void readBinaryField(char *fname, int pad, int &np, int *&points, float *&normals);

  void readVTKField(char *fname, int pad=0);
  void readAVSField(char *fname, int pad=0);
  void exportAVSField(char *fname);
};


#endif





