#include <stdio.h>
#include <omp.h>
#include <vector>
#include <math.h>

int main()
{
  int size = 100000000;

  std::vector<float> res(size);

  float sum1 = 0.0f, sum2 = 0.0f;

#pragma omp parallel for reduction(+: sum1)  reduction(+: sum2)  
  for(int i=0;i<res.size();i++) {

    //printf("thread: %d: %d\n", omp_get_thread_num(), i);

    float a = 25.0f;
    float b = sqrt(a) + exp(-2.0f);
    float c = a + b * a;
  
    res[i] = c;
    sum1 += 1.0f;
    sum2 += 0.5f;
  }

  printf("sum: %f %f\n", sum1, sum2);
}
