#include <stdio.h>
#include <stdlib.h>
#include <omp.h>
#include <math.h>


double estimate_pi(double radius, int nsteps){

   int i;
   double h=2*radius/nsteps;
   double sum=0;
   for (i=1;i<nsteps;i++){
      sum+=sqrt(pow(radius,2)-pow(-radius+i*h,2));
      //sum+=.5*sum;
   }
   sum*=h;
   sum=2*sum/(radius*radius);
   //printf("radius:%f --> %f\n",radius,sum);
   return sum;


}

int main(int argc, char* argv[]){


   double ser_est,par_est;
   long int radii_range;
   if (argc>1) radii_range=atoi(argv[1]);
   else radii_range=500;   

   int nthreads;
   if (argc>2) nthreads=atoi(argv[2]);
   else nthreads=omp_get_num_procs();

   printf("Estimating Pi by averaging %ld estimates.\n",radii_range);
   printf("OpenMP says there are %d processors available.\n",omp_get_num_procs());

   int r;
   double start, stop, serial_time, par_time;



   par_est=0;
   double tmp=0;
   ser_est=0;
   start=omp_get_wtime();
   for (r=1;r<=radii_range;r++){
      tmp=estimate_pi(r,1e6);
      ser_est+=tmp;
   }
   stop=omp_get_wtime();
   serial_time=stop-start;
   ser_est=ser_est/radii_range;

   omp_set_num_threads(nthreads);
   start=omp_get_wtime();
   #pragma omp parallel for private(r,tmp) reduction(+:par_est)
   for (r=1;r<=radii_range;r++){
      tmp=estimate_pi(r,1e6);
      par_est+=tmp;
   }
   stop=omp_get_wtime();
   par_time=stop-start;
   par_est=par_est/radii_range;

   printf("Serial Estimate: %f\nParallel Estimate:%f\n\n",ser_est,par_est);
   printf("Serial Time: %f\nParallel Time:%f\nNumber of Threads: %d\nSpeedup: %f\nEfficiency: %f\n",serial_time,par_time,nthreads,serial_time/par_time, serial_time/par_time/nthreads);


}

