#pragma once

#include "Volume.h"

/* sdt_x becomes squared euclidian distance transform of v.
   sdt_x must already have been initialized to the same dimensions as v.
*/
void edt_3d(Volume<int> &sdt_x, Volume<byte> &v, int thr);

//ft becomes the feature-transform 
void ft_3d(Volume<int> &ft, Volume<byte> &v, int thr);

//approximate/weighted edt (e.g. <3,4,5> weighted dt)
void set_weight_345(int *weights);
void set_weight_city_block(int *weights);
void set_weight_chessboard(int *weights);
void wedt_3d(Volume<int> &dt, Volume<byte> &v, int thr, int *weights);

