/*
 * This program takes a SFF data set as input, 
 * and converts this to AVS field format 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "volume.h"

Volume *datain;
char input_file[MAXSTR];
char output_file[MAXSTR];
char basename_filename[MAXSTR];
char *basename_file;


int main (int argc, char **argv) {
  if (argc != 2) {
    printf("Usage: fld2sff <fname>\n");
    printf("\t<fname>       : name of fld file \n");
    printf("\n\n");
    exit(1);
  }

  sprintf(input_file,"%s",argv[1]);
  basename_file=basename_no_ext(input_file,"fld");
  sprintf(basename_filename,"%s",basename_file);
  sprintf(output_file,"%s.%s",basename_filename,"sff");


  /* Create datastructures */
  datain=Volume_ReadAVS(input_file); 
  Volume_WriteSFF(datain, output_file);

  /* Cleanup */	
  Volume_Delete(datain);

  return 0;
}
