/*
*   $Source: /net/users/roe/onderzoek/morphology/skeletons/code/democode/RCS/makemip.c,v $
*   $Revision: 1.2 $
*   $Date: 2009/06/16 14:22:55 $
*   $Author: roe $
* 
* ------------------------------------------------------------*/

/*
SYNOPSIS 

  This program computes the Maximum Intensity Projection of a 3D dataset

AUTHORS
  J. B. T. M. Roerdink

INPUT:	3D data set SFF file format 

OUTPUT: 2D image in pgm format

USAGE:  makemip [INPUTFILE] 

 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "volume.h"
#include <sys/resource.h>

#define CROPFACTOR 1	/* Factor for cropping final images */
#define PHI 0			/* Value for phi */
#define THETA 0 		/* Value for theta */
#define ALPHA 0 		/* Value for alpha */

ByteVolume *indata;
char input_file[MAXSTR];
char *basefilename;
char basename[MAXSTR];
double phi=PHI, theta=THETA, alpha=ALPHA;
int cropfactor = CROPFACTOR;


/*************** MAIN PROGRAM *****************/


int main (int argc, char **argv) {
  int i;
  int infile=-1;
  int xdim, ydim, zdim;
  BYTE min, max;

  /* Parse command line params */
  for (i=1;i<argc;i++) {
    if (strcmp(argv[i], "--help")==0) {
      printf("\nUsage: %s INFILE \n", argv[0]);
      printf("INFILE is the SFF file to use as input.\n");
        return 0;
   } else infile=i;
  }

  if (infile==-1) {
    printf("Missing input file_name. Use '%s --help' for full help.\n", argv[0]);
    return 0;
  }

  sprintf(input_file,"%s",argv[infile]);
  basefilename=basename_no_ext(input_file,"sff");
  sprintf(basename,"%s",basefilename);
 
  /* Create datastructures */
  fflush(stdout);
  indata=ByteVolume_ReadSFF(input_file);
  ByteVolume_MinMax(indata, &min, &max);
  xdim = indata->xdim ;
  ydim = indata->ydim ;
  zdim = indata->zdim ;
  if ( MAX(MAX(xdim,ydim),zdim)>1024 ) {
	printf("Maximum input dimension = 1024!\n");
	exit(0);
  }	

  /* Construct the Maximum Intensity Projection */

  	 makemip (basename, indata, phi, theta, alpha, cropfactor);

  /* Cleanup */
  	 ByteVolume_Delete(indata);

return 0;
}
