/*
 * This program takes a SFF data set as input, 
 * and converts this to AVS field format 
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "volume.h"

Volume *datain;
char input_file[MAXSTR];
char output_file[MAXSTR];
char basename_filename[MAXSTR];
char *basename_file;


int main (int argc, char **argv) {
  if (argc != 2) {
    printf("Usage: sff2fld <fname>\n");
    printf("\t<fname>       : name of sff file \n");
    printf("\n\n");
    exit(1);
  }

  sprintf(input_file,"%s",argv[1]);
  basename_file=basename_no_ext(input_file,"sff");
  sprintf(basename_filename,"%s",basename_file);
  sprintf(output_file,"%s.%s",basename_filename,"fld");

  /* Create datastructures */
  datain=Volume_ReadSFF(input_file); 

  Volume_WriteAVS(datain, output_file);

  /* Cleanup */	
  Volume_Delete(datain);

  return 0;
}
