#ifndef ABSTRACTACTION_H
#define ABSTRACTACTION_H

#include "stdafx.h"
#include <memory>
using std::shared_ptr;
#include <string>
using std::string;
#include <vector>
using std::vector;

class TAction
{
public:
	TAction()
		: m_Id(0)
	{};
	virtual ~TAction() {};

	virtual string getName() = 0;
	virtual string getScreenName() { return getName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable() = 0;
	virtual void perform();
	unsigned int m_Id;

protected:
	virtual void perform_main() = 0;
	virtual void perform_init() {};
};

class TActionMenu
{
public:
	TActionMenu(string p_Name) 
		: m_Name(p_Name), m_Id(0) 
	{};
	virtual ~TActionMenu();
	vector< class TAction* > m_Actions;
	string m_Name;
	unsigned int m_Id;
};


#endif

