#ifndef ABSTRACTFIELD_H
#define ABSTRACTFIELD_H

#include "stdafx.h"
#include <memory>
using std::shared_ptr;
#include <string>
using std::string;
#include <vector>
using std::vector;
#include <utility>
using std::pair;

#include "types.h"
#include "coord.h"
#include "indexmapper.h"

class TField
{
public:
	TField() {};
	virtual ~TField() {};

	
	// Accessors	
	virtual const string getTypeName() { return "abstract"; }
	virtual TType::TYPE getType() const { return TType::TYPE_NONE; }
	virtual TType::TYPE getSubType() const { return TType::TYPE_NONE; }
	virtual TType::TYPE adapts() const { return TType::TYPE_NONE; }
	virtual TField * create(const TField * p_AdaptedField) const { throw string("TField3::create() not implemented"); }
	virtual const string getAdaptorName() const { return "abstract adaptor"; }

	virtual void accept(class TFieldVisitor * v) = 0;

	virtual int getMaxX() const = 0;
	virtual int getMaxY() const = 0;
	virtual int getMaxZ() const = 0;
	virtual shared_ptr<class TMeasure> getDefaultMeasure() { throw string("getDefaultMeasure(): not implemented"); }

	
	virtual bool usingIndexField() const { return false; } 
	virtual shared_ptr<class TIndexMapper> getIndexField() const;
	virtual shared_ptr<class TIndexMapper> getIndexToField() const; 

	virtual void begin() { };
	virtual void end() { };
	virtual void DrawGui(class wxWindow *) { };
	virtual unsigned int getMaxIndex() const { throw string("getMaxIndex() not implemented"); }


	// Methods

	// Read/write
	virtual void writeToStream(std::ofstream * s) const { throw string("TField(): writeToStream not implemented"); }
	virtual void writeValueToStream(unsigned int x, std::ofstream * s) const { throw string("TField(): writeValueToStream not implemented"); }
	virtual void readValueFromStream(unsigned int x, std::ifstream * s) { throw string("TField(): writeValueToStream not implemented"); }

	virtual class TLayer * getLayer() const = 0;
	virtual void setLayer(class TLayer * p_Layer) = 0; 
protected:
};


template<class T>
class TTypedFieldInterface : public TField
{
public:
	virtual void clear() { throw string("clear() not implemented"); }
	virtual bool isVolatile() const { return false; } // Returns whether values from this field are volatile, i.e. they should be copied before reading another value

	virtual T & wvaluep(const TCoord3 & p) { throw string("wvaluep() not implemented"); }
	virtual const T vvaluep(const TCoord3 & p) const = 0;
	
	virtual T & wvaluex(unsigned int idx) { throw string("wvaluex() not implemented"); }
	virtual const T vvaluex(unsigned int idx) const { throw string("vvaluex() not implemented"); }
	
};


class TFieldVisitor
{
public:
	virtual void visitFloatField(TTypedFieldInterface<float> * p_Field) = 0;
	virtual void visitUintegerField(TTypedFieldInterface<unsigned int> * p_Field) = 0;
	virtual void visitUnsignedCharField(TTypedFieldInterface<unsigned char> * p_Field) = 0;
	virtual void visitIntegerField(TTypedFieldInterface<int> * p_Field) = 0;
	virtual void visitIndexedOriginsField(TTypedFieldInterface<class TIndexedOrigins*> *  p_Field) = 0;
	virtual void visitIndexedOriginsMultimapField(TTypedFieldInterface<class TIndexedOrigins_Multimap*> * p_Field) = 0;
	virtual void visitShortestPathSetField(TTypedFieldInterface<class TShortestPathSet*> *  p_Field) = 0;
	virtual void visitComponentSetField(TTypedFieldInterface<class TComponentSet*> *  p_Field) = 0;
	virtual void visitNodeField(TTypedFieldInterface<vector<class TNode*>*> *  p_Field) = 0;

	
	virtual void visitVector3Field(TTypedFieldInterface<TVector3> * p_Field) = 0;
	virtual void visitCoord3SetField(TTypedFieldInterface<vector<TCoord3>*> * p_Field) = 0;
	virtual void visitCoord3WithFloatSetField(TTypedFieldInterface<vector<pair<TCoord3,float> >*> * p_Field) = 0;
};


#endif
