#ifndef ABSTRACTFILTER_H
#define ABSTRACTFILTER_H

#include "stdafx.h"
#include <memory>
using std::shared_ptr;
#include <string>
using std::string;

#include "coord.h"

class TAbstractFilter
{
public:
	virtual const bool test(const TCoord3 & p) const = 0; 
	virtual const bool test(float v) const = 0;
	virtual const bool testx(const unsigned int & x) const = 0;
};

class TFilter : public TAbstractFilter
{
public:
	friend class TFloatFilterPanel;

	// Types
	enum FILTERTYPE { FILTERTYPE_NONE, FILTERTYPE_ALWAYSTRUE, FILTERTYPE_INT, FILTERTYPE_FLOAT };

	// Constructors
	TFilter(shared_ptr<class TMeasure> * const p_Measure) 
		: m_Measure(p_Measure)
		, m_Name("noname") 
	{};

	// Accessors
	virtual string getName() const { return m_Name; }
	void setName(string n) { m_Name = n; }
	virtual FILTERTYPE getFilterType() const = 0;

	// Methods
	virtual const bool test(const TCoord3 & p) const = 0; 
	virtual const bool test(float v) const = 0;
	virtual const bool testx(const unsigned int & x) const = 0;
	virtual void DrawGui(class wxWindow * p_Window) = 0;
	virtual void setAlwaysTrue(bool b) = 0;

protected:
	string m_Name;
	shared_ptr<class TMeasure> * const m_Measure;
};


#endif
