#ifndef ABSTRACTMEASURE_H
#define ABSTRACTMEASURE_H


#include "stdafx.h"
#include "abstractfield.h"

class TMeasure
{
public:
	TMeasure(TField * p_Field) 
		: m_AbstractField(p_Field) 
		, m_IsInitialized(false)
	{
		// want to call init, but virtual methods cannot be called from constructors
	}
	void init();

	enum MEASURETYPE 
	{ 
		MEASURETYPE_NONE, MEASURETYPE_INT_IDENTITY, MEASURETYPE_UINT_IDENTITY, MEASURETYPE_FLOAT_IDENTITY, MEASURETYPE_FLOAT_NORMALIZED, MEASURETYPE_UCHAR_IDENTITY, MEASURETYPE_ORIGSET_ORIGINCOUNT, MEASURETYPE_ORIGSET_MINIMUMDISTANCE, MEASURETYPE_VECTOR2_LENGTH, MEASURETYPE_VECTOR3_LENGTH, MEASURETYPE_COORD2SET_COUNT, MEASURETYPE_INDEXEDORIGINS_COUNT, MEASURETYPE_INDEXEDORIGINSSORTED_COUNT, MEASURETYPE_COORD3SETSORTED_COUNT, MEASURETYPE_COORD3WITHFLOATSET_COUNT, MEASURETYPE_COORD3WITHFLOATSET_MINIMUM, MEASURETYPE_COORD3WITHFLOATSET_MAXIMUM, MEASURETYPE_GEODESICSET_COUNT, MEASURETYPE_GEODESICSET_MAXLENGTH, MEASURETYPE_DELTAOMEGAFLOATMAP_SIZE, MEASURETYPE_GEODESICSET_VOXELCOUNT, MEASURETYPE_VECTORSET_LENGTH, MEASURETYPE_COORD3SET_COUNT, MEASURETYPE_FLOAT_SQRT, MEASURETYPE_INDEXEDORIGINS_MINDISTANCE, MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MIN, MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MAX, MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MINDISTANCE, MEASURETYPE_INDEXEDORIGINS_MULTIMAP_MAXDISTANCE, MEASURETYPE_INDEXEDORIGINS_MULTIMAP_ORIGINCOUNT, MEASURETYPE_SHORTESTPATHSET_PATHCOUNT 
		, MEASURETYPE_NODE_LARGESTDISSIMILARITYOFGEOFP
		, MEASURETYPE_NODE_LARGESTDISSIMILARITYOFTP
		, MEASURETYPE_NODE_CONTAINSNONNEIGHBORS
		, MEASURETYPE_NODE_COUNT
		, MEASURETYPE_SHORTESTPATHSET_MAXCIRCULARITY
		, MEASURETYPE_COMPONENTSET_COUNT
		, MEASURETYPE_COMPONENTSET_MAXAREA
	};
	virtual float toFloat(const TCoord3 & p_Coord) const = 0;
	virtual float vvaluex(const unsigned int x) const = 0;
	virtual string getName() const = 0;
	virtual MEASURETYPE getMeasureType() const = 0;
	virtual TType::TYPE getSourceType() const = 0; // Specifies the source field type
	virtual TMeasure * create(TField * p_Field) const = 0;
	float getMinValue();
	float getMaxValue();

	TField * m_AbstractField;
	float m_MinValue, m_MaxValue; // contains min and max measures for the purpose of normalized colormap

private:
	bool m_IsInitialized;
};


template <class T>
class TTypedMeasure : public TMeasure
{
public:
	TTypedMeasure(TTypedFieldInterface<T> * p_TypedField) 
		: TMeasure(p_TypedField)
		, m_Field(p_TypedField)
	{
	}
	virtual TType::TYPE getSourceType() const { return TType::TYPE_NONE; }
	
protected:
	TTypedFieldInterface<T> * m_Field;
};


#endif
