#ifndef ACTION_H
#define ACTION_H

#include "stdafx.h"

#include <vector>
using std::vector;
#include <string>
using std::string;
#include <utility>
using std::pair;

#include "types.h"
#include "coord.h"
#include "abstractfield.h"
#include "abstractaction.h"




class TAction_EftSymmetrical : public TAction
{
public:
	virtual string getName() { return "Symmetrical EFT"; }
	virtual string getHelpString() { return "Make extended feature transform that is symmetrical, i.e. combines the FT's of all neighboring voxels"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_ExtendCollapseToLoops : public TAction
{
public:
	virtual string getName() { return "Extend collapse to loops"; }
	virtual string getHelpString() { return "Extend collapse"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};




class TAction_Reconstruction: public TAction
{
public:
	virtual string getName() { return "Reconstruction"; }
	virtual string getHelpString() { return "Reconstruct object from skeleton using the skeleton measure filter (slow)"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};




class TAction_TFT: public TAction
{
public:
	virtual string getName() { return "TFT"; }
	virtual string getHelpString() { return "Tolerance-based feature transform"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_ReverseTft : public TAction
{
public:
	static string getStaticName() { return "Reverse TFT"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_DiscardDisconnectedComponents : public TAction
{
public:
	static string getStaticName() { return "Discard disconnected components"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_ComputeSimplifiedEft : public TAction
{
public:
	TAction_ComputeSimplifiedEft()
	{
	}

	static string getStaticName() { return "Recompute simplified eft"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return "Recomputes the simplified extended feature-transform using the supplied tau."; }
	virtual bool isAvailable();
	static void process(TShortestPathSet * sps, float p_LowerValue);
//	TTypedFieldInterface<TShortestPathSet*> * m_SPSF;
//	TFloatFilter * m_Filter;
protected:
	virtual void perform_main();
};


class TAction_ReverseEft : public TAction
{
public:
	static string getStaticName() { return "Reverse Eft"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_ReverseEftAngle : public TAction
{
public:
	static string getStaticName() { return "Reverse Eft angle"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_ReverseEftAngle2 : public TAction
{
public:
	static string getStaticName() { return "Reverse Eft angle 2"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_DistanceToFeatureCollection : public TAction
{
public:
	static string getStaticName() { return "Distance to feature collection"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	void computeDistanceField(bool p_FgBg);
	void computeDistanceFieldSelectedLayer();
};




class TAction_Thin : public TAction
{
public:
	virtual string getName() { return "Thin"; }
	virtual string getHelpString() { return "Do a thinning process"; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

#endif
