#include "stdafx.h"

#include "boundarysegmentation.h"
#include "boundarysegmentation_old.h"

#include "globals.h"
#include "layer.h"
#include "skeletonizer.h"
#include "colormap.h"
#include "deltaomega.h"
#include "action.h"
#include "logwriter.h"
#include "filter.h"

#include "sskelsegmentation.h"

using namespace std;




void TAction_SkeletonizeForBoundarySegmentation::perform_main()
{
	if( m_Filename != "" )
	{
		bool UseCSkel = false;
		g_Parameters.m_ComputeCskel = UseCSkel;
		g_Parameters.m_ComputeImportanceForCskel = UseCSkel;

		g_Parameters.m_OnlyCskelIterative = false;
		g_Parameters.m_OnlyKeepShortestPathsOnCskel = false;
//		g_Parameters.m_MiniumEftDistance = 2;
		g_Parameters.m_Equalize = false;
		g_Parameters.m_ComputeBackgroundSskel = true;
//		g_Parameters.m_InvertBorder = 10;

		g_Parameters.m_KeepShortestPaths = false;
		g_Parameters.m_CacheGeodesics = true;

		TSkeletonizer * skel = new TSkeletonizer( m_Filename );
		skel->perform();
		g_Mediator.getSkeletonizer().reset( skel );

		g_Mediator.updateUI();
	}
}

bool TAction_SkeletonizeForBoundarySegmentation::isAvailable()
{
	return true;
}


void TAction_SkeletonizeForBoundarySegmentation::perform_init()
{
	m_Filename = "";
	wxFileDialog FileDialog(0, "Choose field file to open", "models", "", "*.dat;*.vtk;*.bmp;*.pgm;*.vol;*.vtk.gz", wxFD_OPEN);
	if( FileDialog.ShowModal() == wxID_OK)
	{
		m_Filename = FileDialog.GetPath().c_str();
	}	
}






// ------------------------------------------------------------------------------------------

bool TAction_InverseEftComplete::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; // g_Mediator.getCurrentLayerSet()->exists( TAction_SegmentSurfaceSkeleton::getStaticName() );
}


void TAction_InverseEftComplete::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

//	TTypedFieldInterface<unsigned int>* SskelSegments = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField(TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, TAction_SegmentSurfaceSkeleton::getStaticName() ) );
	const TShortestPathSetField * SPSF = skel->m_ForegroundSpSetField.get();
//	vector<TAction_SegmentSurfaceSkeleton::TSskelSegment> & Segments = TAction_SegmentSurfaceSkeleton::Segments;

	TTypedFieldInterface<float>* Skel = skel->m_ForegroundSurfaceSkeletonField;
	*g_Log << "TAction_InverseEftComplete:: using layer and filter \"" << Skel->getLayer()->m_Name << "\"\n";
	const TFloatFilter * Filter = static_cast<TFloatFilter*>( Skel->getLayer()->m_Filter.get() );
	
	const TTypedFieldInterface<TIndexedOrigins*> * EftField = skel->m_EftField;

	unsigned int x,y,z;
	// Make boundary segmentation from S-skel segmentation
	TTypedFieldInterface<TIndexedOrigins*>* Output = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->m_ForegroundSskelIndexField, getName() ) );
	Output->clear();
	for(x=0; x<SPSF->getMaxIndex(); x++)
	{
		const TCoord3 p = SPSF->getIndexField()->vidx2coord(x);
		if(!Filter->test(p)) continue;
		const TShortestPathSet * sps = SPSF->vvaluex(x);
		if(sps == 0) continue;
		for(y=0; y<sps->m_Paths.size(); y++)
		{
			TShortestPath * sp = sps->m_Paths[y].get();
			if(!Filter->test(sp->m_Length)) continue;

			// Method: only feature points
			const unsigned int Option = 0;
			if(Option == 0)
			{
				{
					const unsigned int zidx = sp->m_Begin;
					if(!Output->vvaluex(zidx)) Output->wvaluex(zidx) = new TIndexedOrigins_Vector(4);
					Output->vvaluex( zidx )->castVector()->push_back(x);
				}

				{
					const unsigned int zidx = sp->m_End;
					if(!Output->vvaluex(zidx)) Output->wvaluex(zidx) = new TIndexedOrigins_Vector(4);
					Output->vvaluex( zidx )->castVector()->push_back(x);
				}

			}
			else if(Option == 1)
			{
				{
					const unsigned int zidx = sp->m_Begin;
					if(!Output->vvaluex(zidx)) Output->wvaluex(zidx) = new TIndexedOrigins_Vector(1);
					if(Output->vvaluex(zidx)->castVector()->size() == 0) Output->vvaluex(zidx)->castVector()->push_back(x);
					const TCoord3 zcoord = skel->Omega->m_BoundaryIndexField->vidx2coord( zidx );
					const TCoord3 curcoord = skel->m_ForegroundSskelIndexField->vidx2coord( Output->vvaluex(zidx)->castVector()->at(0) );
					if( 
						sps->m_SourceVoxel.distance2( zcoord ) 
						<
						curcoord.distance2( zcoord ) 
						)
					{
						Output->vvaluex( zidx )->castVector()->clear();
						Output->vvaluex( zidx )->castVector()->push_back(x);
					}
				}

				{
					const unsigned int zidx = sp->m_End;
					if(!Output->vvaluex(zidx)) Output->wvaluex(zidx) = new TIndexedOrigins_Vector(1);
					if(Output->vvaluex(zidx)->castVector()->size() == 0) Output->vvaluex(zidx)->castVector()->push_back(x);
					const TCoord3 zcoord = skel->Omega->m_BoundaryIndexField->vidx2coord( zidx );
					const TCoord3 curcoord = skel->m_ForegroundSskelIndexField->vidx2coord( Output->vvaluex(zidx)->castVector()->at(0) );
					if( 
						sps->m_SourceVoxel.distance2( zcoord ) 
						<
						curcoord.distance2( zcoord ) 
						)
					{
						Output->vvaluex( zidx )->castVector()->clear();
						Output->vvaluex( zidx )->castVector()->push_back(x);
					}
				}
				
			}
			else if(Option == 2)
			{
				// Methode: alle punten op shortest path
				if(!sp->m_Path) throw string("!sp->m_Path");
				for(z=0; z<sp->m_Path->size(); z++)
				{
					const unsigned int zidx = (*sp->m_Path)[z];
					const TCoord3 zcoord = skel->Omega->m_BoundaryIndexField->vidx2coord( zidx );
					
					if(!Output->vvaluex(zidx)) Output->wvaluex(zidx) = new TIndexedOrigins_Vector();
					if(Output->vvaluex(zidx)->castVector()->size() == 0) Output->vvaluex(zidx)->castVector()->push_back(x);
					
					
					const TCoord3 curcoord = skel->m_ForegroundSskelIndexField->vidx2coord( Output->vvaluex(zidx)->castVector()->at(0) );
					if( sps->m_SourceVoxel.distance2( zcoord ) 
						<
						curcoord.distance2( zcoord ) 
						)
					{
						Output->vvaluex( zidx )->castVector()->clear();
						Output->vvaluex( zidx )->castVector()->push_back(x);
					}
				}
			}
		}
		
	}

	// Make copy
	{
		TTypedFieldInterface<TIndexedOrigins*>* Output2 = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( Output->getIndexField(), Output->getIndexToField(), "Inverse Eft unfilled" ) );
		Output2->clear();
		for(x=0; x<Output->getMaxIndex(); x++) 
			if(Output->vvaluex(x))
				Output2->wvaluex(x) = new TIndexedOrigins_Vector( *(Output->vvaluex(x)->castVector()) );
		Output2->getLayer()->onFieldChanged();
	}
	
	// Make Inverse Eft complete; assign a value to each boundary voxel
	skel->Omega->m_DeltaOmega->fillZerosByPropagation( Output );

	Output->getLayer()->m_RenderLines = true;
	Output->getLayer()->onFieldChanged();
}

// ------------------------------------------------------------------------------------------

bool TAction_ComputeNormalsClamped::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; // g_Mediator.getCurrentLayerSet()->exists( TAction_SegmentSurfaceSkeleton::getStaticName() );
}


void TAction_ComputeNormalsClamped::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!g_Mediator.getCurrentLayerSet()->exists( TAction_InverseEftComplete::getStaticName() ))
	{
		TAction_InverseEftComplete Action;
		Action.perform();
	}

	const TTypedFieldInterface<TIndexedOrigins*>* ReverseEft = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_InverseEftComplete::getStaticName() ) );
	if(!ReverseEft) throw string("!ReverseEft");
	
	TTypedFieldInterface<TVector3>* Output = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_VECTOR3, skel->Omega->m_BoundaryIndexField, getName() ) );
	Output->clear();
	Output->getLayer()->m_AllVoxels->setCheckedForRendering(false);

	TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_ForegroundSpSetField.get();

	// For each voxel in ReverseEft
	// ... get voxel p on S-skel
	// ... look at feature vectors of p 
	// .... choose feature vector that is closest to inverse feature vector
	unsigned int x,y;
	for(x=0; x<ReverseEft->getMaxIndex(); x++)
	{
		if(!ReverseEft->vvaluex(x)) continue;
		if(ReverseEft->vvaluex(x)->castVector()->size() == 0) continue;
		const TCoord3 boundcoord = ReverseEft->getIndexField()->vidx2coord(x);
		
	
		float maxdot = -1000.0f;
		TVector3 maxvec(0,0,0);
		for(unsigned int z=0; z<ReverseEft->vvaluex(x)->castVector()->size(); z++)
		{
			const unsigned int sidx = ReverseEft->vvaluex(x)->castVector()->at(z);
			const TCoord3 p = ReverseEft->getIndexToField()->vidx2coord(sidx);
			
			TCoord3 np;
			for(np.x=p.x-1; np.x<=p.x+1; np.x++) // neighbors
			for(np.y=p.y-1; np.y<=p.y+1; np.y++)
			for(np.z=p.z-1; np.z<=p.z+1; np.z++)
			{
				if(! SPSF->getIndexField()->vinside(np)) continue;
				const TShortestPathSet * sps = SPSF->vvaluep(np);

				const TCoord3 skelcoord = np;
				TVector3 realvec = skelcoord.toVector();
				realvec.subtract( boundcoord.toVector() );
				realvec.normalize();

				for(y=0; y<sps->m_Eft->size(); y++)
				{
					TVector3 clampedvec = skelcoord.toVector();
					clampedvec.subtract( skel->m_BoundaryIndexField->vidx2coord( (*sps->m_Eft)[y] ).toVector() );
					clampedvec.normalize();
					
					const float d = realvec.dot(clampedvec);
					if(d > maxdot) 
					{
						maxvec = clampedvec;
						maxdot = d;
					}
				}
			}
		}
		Output->wvaluex(x) = maxvec;
	}
	
	Output->getLayer()->onFieldChanged();
}	


// ------------------------------------------------------------------------------------------


bool TAction_BoundaryNormalFromInverseEft::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 
}


void TAction_BoundaryNormalFromInverseEft::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!g_Mediator.getCurrentLayerSet()->exists( TAction_InverseEftComplete::getStaticName() ))
	{
		TAction_InverseEftComplete Action;
		Action.perform();
	}

	const TTypedFieldInterface<TIndexedOrigins*>* ReverseEft = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_InverseEftComplete::getStaticName() ) );
	if(!ReverseEft) throw string("!ReverseEft");

	TTypedFieldInterface<TVector3>* Output = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_VECTOR3, skel->Omega->m_BoundaryIndexField, getName() ) );
	Output->clear();
	Output->getLayer()->m_AllVoxels->setCheckedForRendering(false);

	for(unsigned int x=0; x<ReverseEft->getMaxIndex(); x++)
	{
		const TCoord3 from = ReverseEft->getIndexField()->vidx2coord(x);

		TVector3 v(0,0,0);
		const TIndexedOrigins_Vector * io = ReverseEft->vvaluex(x)->castConstVector();
		for(unsigned int y=0; y<io->size(); y++)
		{
			unsigned int idx = (*io)[y];
			TVector3 to = ReverseEft->getIndexToField()->vidx2coord(idx).toVector();
			v.add( to );
		}
		v.scale(1.0f / (float)io->size() );
		v.subtract(from.toVector());
		v.normalize();

		Output->wvaluex(x) = v;
	}

	Output->getLayer()->m_RenderLines = true;
	Output->getLayer()->onFieldChanged();
}


// ------------------------------------------------------------------------------------------


bool TAction_BoundaryNormalUsingForwardEftAndShortestPaths::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 
}


void TAction_BoundaryNormalUsingForwardEftAndShortestPaths::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

	TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_ForegroundSpSetField.get();
	const TFilter * Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();

	TTypedFieldInterface<TVector3>* Output = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_VECTOR3, skel->Omega->m_BoundaryIndexField, getName() ) );
	Output->clear();
	Output->getLayer()->m_AllVoxels->setCheckedForRendering(false);

	TTypedFieldInterface<TIndexedOrigins_Vector*>* Origins = static_cast<TTypedFieldInterface<TIndexedOrigins_Vector*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->m_ForegroundSskelIndexField, "Origins" ) );
	Origins->clear();

	typedef multimap<float, pair<TCoord3,shared_ptr<TShortestPath> >, greater<float> > TSortedPaths;
	TSortedPaths S;
	S.clear();
	unsigned int x,y;
	for(x=0; x<SPSF->getMaxIndex(); x++)
	{
		TShortestPathSet * s = SPSF->vvaluex(x);
		TShortestPathSet::TPaths & Paths = s->m_Paths;
//			if(!Filter || !Filter->test(s->m_SourceVoxel)) continue;
		if(!Filter->test(s->getMaxLength())) continue;

		//if(s->m_Paths.size() != 1) continue;
		for(y=0; y<Paths.size(); y++)
		{
			shared_ptr<TShortestPath> sp = Paths[y];
			if(!Filter->test(sp->m_Length)) continue;

			S.insert( 
				TSortedPaths::value_type(
					sp->m_Length, pair<TCoord3,shared_ptr<TShortestPath> >( s->m_SourceVoxel, sp) 
					) 
				);
		}
	}

	TSortedPaths::iterator it;
	for(it = S.begin(); it != S.end(); it++)
	{	
		TCoord3 SourceVoxel = it->second.first;
		shared_ptr<TShortestPath> sp = it->second.second;

		shared_ptr<TIndexedOrigins_Vector> v = skel->Omega->m_DeltaOmega->getShortestPath( sp->m_Begin, sp->m_End )->m_Path;
		TVector3 vp1 = SourceVoxel.toVector();
		vp1.subtract( skel->Omega->m_BoundaryIndexField->vidx2coord( sp->m_Begin ).toVector() );
		vp1.normalize();

		TVector3 vp2 = SourceVoxel.toVector();
		vp2.subtract( skel->Omega->m_BoundaryIndexField->vidx2coord( sp->m_End ).toVector() );
		vp2.normalize();

		float currentpos = 0.0f;
		for(unsigned int z=0; z<v->size(); z++)
		{
			const float idx = (*v)[z];

			TVector3 vp = SourceVoxel.toVector();
			vp.subtract( skel->Omega->m_BoundaryIndexField->vidx2coord(idx).toVector() );
			vp.normalize();


			float dot1 = vp.dot(vp1);
			float dot2 = vp.dot(vp2);
			if(dot1 > 0.8f || dot2 > 0.8f)
			{
				Output->wvaluex( idx ) = dot1 > dot2 ? vp1 : vp2;
			}

			if( !Origins->vvaluex( idx ) ) Origins->wvaluex( idx ) = new TIndexedOrigins_Vector();
			Origins->vvaluex( idx )->clear();
			Origins->vvaluex(idx)->push_back( skel->m_ForegroundSskelIndexField->vcoord2idx(SourceVoxel) );

			/*
			if(idx > 0)
			{
				const TCoord3 p = skel->Omega->m_BoundaryIndexField->vidx2coord(idx-1);
				const TCoord3 np = skel->Omega->m_BoundaryIndexField->vidx2coord(idx);
				char weight = 3;
				if( np.x == p.x ) weight--;
				if( np.y == p.y ) weight--;
				if( np.z == p.z ) weight--;
				if(weight == 0) continue;
				currentpos += skel->Omega->m_DeltaOmega->WEIGHTS[weight];
			}
			*/

		}
	}

	// Make copy
	{
		TTypedFieldInterface<TVector3>* Output2 = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_VECTOR3, skel->Omega->m_BoundaryIndexField, "Normals unfilled" ) );
		for(x=0; x<Output->getMaxIndex(); x++) Output2->wvaluex(x) = Output->vvaluex(x);
		Output2->getLayer()->m_AllVoxels->setCheckedForRendering(false);
		Output2->getLayer()->onFieldChanged();
		Output2->getLayer()->m_Filter->m_UpperValue = 1.1f;

	}

	skel->Omega->m_DeltaOmega->fillZerosByPropagation(Output);
	Output->getLayer()->m_RenderLines = true;
	Output->getLayer()->onFieldChanged();
	Output->getLayer()->m_Filter->m_UpperValue = 1.1f;

	Origins->getLayer()->onFieldChanged();
}




// ------------------------------------------------------------------------------------------


bool TAction_FillUsingClusters::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	//return g_Mediator.getCurrentLayerSet()->exists( "Clusters" );
	return g_Mediator.getCurrentLayer().get() != 0 && g_Mediator.getCurrentLayer()->m_Field->getType() == TType::TYPE_UINT;
}


void TAction_FillUsingClusters::perform_main()
{
	unsigned int x;
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	// Get cluster field
//	const TTypedFieldInterface<unsigned int>* Clusters = static_cast<TTypedFieldInterface<unsigned int>* >( g_Mediator.getCurrentLayerSet()->getField( "Clusters" ) );
	TTypedFieldInterface<unsigned int>* Clusters = static_cast<TTypedFieldInterface<unsigned int>* >( g_Mediator.getCurrentLayer()->m_Field.get() );
	if(Clusters->getType() != TType::TYPE_UINT) throw string("!TYPE_UINT");



	// Create new 
	TTypedFieldInterface<unsigned int>* FilledClusters = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() ) );
	FilledClusters->clear();
	for(x=0; x<Clusters->getMaxIndex(); x++) FilledClusters->wvaluex(x) = Clusters->vvaluex(x);


	long FillOption = 0;
	{
		wxString Choices[] = { "0. geo. dist", "1. sim. normal", "2. sim. normal, then geo", "3. extended cluster domains" };
		wxString Result = ::wxGetSingleChoice("Choose operation", "Choose operation", 4, Choices );
		if(Result == "") return;
		Result.Left(1).ToLong(&FillOption);
	}

	{
		long Cleanup = 0;
		wxString Choices[] = { "0. no", "1. yes" };
		wxString Result = ::wxGetSingleChoice("Clean-up?", "Clean-up?", 2, Choices );
		if(Result == "") return;
		Result.Left(1).ToLong(&Cleanup);
		if(Cleanup)
		{
			// Get or compute boundary normals
			if(! g_Mediator.getCurrentLayerSet()->exists( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() ) ) 
			{
				TAction_BoundaryNormalUsingForwardEftAndShortestPaths Action;
				Action.perform();
			}
			const TTypedFieldInterface<TVector3>* BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() )  );
			if(!BoundaryNormals) throw string("BoundaryNormals not available");

			TAction_NotUsingSskelSegmentation3::cleanUp(Clusters, BoundaryNormals, true);
		}
	}

	
	if(FillOption == 0)
	{
		skel->Omega->m_DeltaOmega->fillZerosByPropagation( FilledClusters );
	}
	// Intelligent floodfill
	else if(FillOption == 1 || FillOption == 2)
	{
		// Get or compute boundary normals
		if(! g_Mediator.getCurrentLayerSet()->exists( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() ) ) 
		{
			TAction_BoundaryNormalUsingForwardEftAndShortestPaths Action;
			Action.perform();
		}
		const TTypedFieldInterface<TVector3>* BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() )  );
		if(!BoundaryNormals) throw string("BoundaryNormals not available");


		if(FillOption == 1 || FillOption == 2)
		{
			static double Threshold = 0.92;
			/*
			{
				{
					wxString s = "";
					do
					{
						s = ::wxGetTextFromUser("Threshold", "Threshold", wxString::Format("%f",Threshold).c_str() );
						if(s == "") return;
					} 
					while( !s.ToDouble(&Threshold) );
				}
			}
			*/



	//		TTypedFieldInterface<TIndexedOrigins*>* DebugOrigins = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, getName() + " debug io") );
			TTypedFieldInterface<TIndexedOrigins*>* DebugOrigins = 0;
	//		DebugOrigins->clear();
			skel->Omega->m_DeltaOmega->fillZerosByPropagationUsingNormals( FilledClusters, BoundaryNormals, DebugOrigins, Threshold );
	//		DebugOrigins->getLayer()->onFieldChanged();

			if(FillOption == 2)
			{
				skel->Omega->m_DeltaOmega->fillZerosByPropagation( FilledClusters );
			}

		}
	}
	
	/*	
	else if(FillOption == 3)
	{
		// Compute feature transform for each segment
		*g_Log << "Compute feature transform for each segment\n";
		vector<TTypedFieldInterface<float>*> Dts;
		Dts.push_back(0);
		vector<TTypedFieldInterface<TIndexedOrigins*>*> Fts;
		unsigned int MaxClusterId = 0;
		for(unsigned int idx=0; idx<FilledClusters->getMaxIndex(); idx++)
		{
			if(FilledClusters->vvaluex(idx) > MaxClusterId) MaxClusterId = FilledClusters->vvaluex(idx);
		}
		Fts.push_back(0);
		{
			for(x=1; x<=MaxClusterId; x++)
			{
				string name = wxString::Format("Cluster %i", x).c_str();
				TTypedFieldInterface<float>* Dt = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, name + " dt") );
				Dt->clear();
				Dts.push_back(Dt);
				TTypedFieldInterface<TIndexedOrigins*>* Ft = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, name + " ft") );
				Ft->clear();
				Fts.push_back(Ft);

				skel->Omega->m_DeltaOmega->computeDtAndFt(FilledClusters, x, Dt, Ft);

				Dt->getLayer()->onFieldChanged();
				Ft->getLayer()->onFieldChanged();
			}
		}
	}

	const TTypedFieldInterface<TVector3>* BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() ) );
	*g_Log << "Fill unfilled\n";

	// Fill unfilled voxels using tangentplanes
	if(true)
	{
		for(unsigned int idx=0; idx<FilledClusters->getMaxIndex(); idx++)
		{
			if(FilledClusters->vvaluex(idx) == 0)
			{
				// Find first closest three clusters
				typedef multimap<float, unsigned int> TClosestClusters;
				TClosestClusters ClosestClusters;
				for(unsigned int y=1; y<Dts.size(); y++)
				{
					ClosestClusters.insert( TClosestClusters::value_type( Dts[y]->vvaluex(idx), y ) );
				}

				float mindist = (numeric_limits<float>::max)();
				unsigned int mincid = 0;
				TClosestClusters::iterator it;
				unsigned int count = 0;
				for(it = ClosestClusters.begin(); it != ClosestClusters.end() && count < 3; it++, count++)
				{
					const unsigned int cid = it->second;
					if(!Fts[cid]->vvaluex(idx)) continue;
					if(Fts[cid]->vvaluex(idx)->castVector()->size() ==0) continue;
					const unsigned int nidx = Fts[cid]->vvaluex(idx)->castVector()->at(0);
					if( BoundaryNormals->vvaluex(nidx).dot( BoundaryNormals->vvaluex(idx) )
						< 0.5f 
						) continue;

					TPlane TangentPlane( skel->m_BoundaryIndexField->vidx2coord(nidx).toPoint(), BoundaryNormals->vvaluex(nidx) );
					const float d = fabs( 
						TangentPlane.distance2point( skel->m_BoundaryIndexField->vidx2coord(idx).toPoint() )
						);

					if(d < mindist) 
					{
						mindist = d;
						mincid = cid;
					}
				}
				FilledClusters->wvaluex(idx) = mincid;
			}
		}
		}
		else
		{
			// Fill unfilled voxels using normal similarity
			{
				for(unsigned int idx=0; idx<FilledClusters->getMaxIndex(); idx++)
				{
					if(FilledClusters->vvaluex(idx) == 0)
					{
						// Find first closest three clusters
						typedef multimap<float, unsigned int> TClosestClusters;
						TClosestClusters ClosestClusters;
						for(unsigned int y=1; y<Dts.size(); y++)
						{
							ClosestClusters.insert( TClosestClusters::value_type( Dts[y]->vvaluex(idx), y ) );
						}

						float mindist = -1.0f;;
						unsigned int mincid = 0;
						TClosestClusters::iterator it;
						unsigned int count = 0;
						for(it = ClosestClusters.begin(); it != ClosestClusters.end() && count < 3; it++, count++)
						{
							const unsigned int cid = it->second;
							const unsigned int nidx = Fts[cid]->vvaluex(idx)->castVector()->at(0);
							const float d = BoundaryNormals->vvaluex(nidx).dot( BoundaryNormals->vvaluex(idx) );

							if(d > mindist) 
							{
								mindist = d;
								mincid = cid;
							}
						}
						FilledClusters->wvaluex(idx) = mincid;
					}
				}
			}		
			}
	}
	*/
	else throw string("Invalid option");

	// Todo: make this an option		
	//skel->Omega->m_DeltaOmega->makeMinColoring(FilledClusters);
	FilledClusters->getLayer()->onFieldChanged();
}




// ------------------------------------------------------------------------------------------


bool TAction_NotUsingSskelSegmentation2::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}


void TAction_NotUsingSskelSegmentation2::determineVoxelNeighborhood(unsigned int p_Voxel, float p_Threshold)
{
	// This should be called only once for each voxel

	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	m_PrecisionTimer.start();

	unsigned int x,y;

	vector<unsigned int> Neighbors;
	vector<float> Distances;
	// Determine all voxels within certain distance
	skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(p_Voxel, Seeds, p_Threshold, 
		&Neighbors, 
		&Distances
		);
	
	if(!BoundaryNormals) throw string("!BoundaryNormals");

	vector< pair<TVector3, unsigned int> > Neighborhood;
	Neighborhood.clear();
	TCluster::TNeighbors::iterator it;
	const TCoord3 scoord = skel->m_BoundaryIndexField->vidx2coord(p_Voxel);
	TPlane TangentPlane( scoord.toPoint(), BoundaryNormals->vvaluex(p_Voxel) );
	
	for(x=0; x<Neighbors.size(); x++)
	{
		const unsigned int nidx = Neighbors[x];
		const TCoord3 ncoord = skel->m_BoundaryIndexField->vidx2coord(nidx);
		TVector3 nv = ncoord.toVector();
		//nv.subtract( scoord.toPoint() );
		//nv.normalize();
		
		TangentPlane.project( nv );
		nv.subtract( scoord.toPoint() );
		if(nv.length() > 0.1f)
		{
			nv.normalize();
		
			// nv is projected, now look at angle with existing neighbors
			bool add = true;
			for(y=0; y<Neighborhood.size(); y++)
			{
				float dot = Neighborhood[y].first.dot( nv );
				if(dot > 0.999f) dot = 0.999f;
				if(dot < -0.999f) dot = -0.999f;
				const float degrees = ( acos(dot) / PI ) * 180.0f;
				if( degrees < 25.0f )
				{
					add = false;
					break;
				}
			}

			Neighborhood.push_back( pair<TVector3,unsigned int>( nv, nidx ) );

			if(add)
			{
				{
					unsigned int voxel = p_Voxel;
					unsigned int inserthis = Neighbors[x];
					TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(voxel)->castVector();
					unsigned int z;
					for(z=0; z<v->size(); z++) if((*v)[z] == inserthis) break;
					if( z==v->size() ) v->push_back( inserthis );
				}

				// Make symmetrical
				{
					unsigned int voxel = Neighbors[x];
					unsigned int inserthis = p_Voxel; 
					TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(voxel)->castVector();
					unsigned int z;
					for(z=0; z<v->size(); z++) if((*v)[z] == inserthis) break;
					if( z==v->size() ) v->push_back( inserthis );
				}
			}
		}			
	}

	m_TimeForNeighborhoods += m_PrecisionTimer.stop();
	m_CountInvocationsNeighborhoods++;
}


void TAction_NotUsingSskelSegmentation2::computeClusterDistanceAndInsert(TCluster * Cluster)
{
	m_PrecisionTimer.start();
	if(Cluster->m_Id == 0) throw string("computeClusterDistanceAndInsert(): cluster id == 0");

	set<TCluster*> Neighbors;
	{
		set<unsigned int>::iterator it;
		for(it = Cluster->m_BoundaryVoxels.begin(); it != Cluster->m_BoundaryVoxels.end(); it++)
		{
			TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(*it)->castVector();
			for(unsigned int x=0; x<v->size(); x++)
			{
				TCluster * c = Id2Cluster[ Seeds->vvaluex((*v)[x]) ];
				assert(c != 0);
				if(c != Cluster) Neighbors.insert( c );
			}
		}
	}

	if( Cluster->m_ClusterEntries.size() != 0 ) throw string("Cluster->m_ClusterEntries.size() != 0");
	for(set<TCluster*>::iterator  jt=Neighbors.begin();jt!=Neighbors.end();jt++)
	{
		TCluster * ToCluster = *jt;
		if(ToCluster->m_Id != Cluster->m_Id)
		{
			if(!m_UseSkeletonConstraint || canBeMerged(Cluster,ToCluster) )
			{
				// Normal distance
				const float dist = 1.0f - Cluster->m_Normal.dot( ToCluster->m_Normal );

				TClusterQueue::iterator it = Queue.insert( TClusterQueue::value_type(dist, pair<TCluster*,TCluster*>(Cluster,ToCluster) ) );
				Cluster->m_ClusterEntries.push_back(it);
			}
		}
	}

	m_TimeForLinkages += m_PrecisionTimer.stop();
	m_CountInvocationsLinkages++;
}

void TAction_NotUsingSskelSegmentation2::determineNormal(TCluster * Cluster)
{
	set< TCluster* >::iterator it;
	set<unsigned int>::iterator jt;

	TVector3 v(0,0,0);
	float value = (numeric_limits<float>::max)();
	for(jt = Cluster->m_Voxels.begin(); jt != Cluster->m_Voxels.end(); jt++)
	{
		if( m_SeedsAngle->vvaluex(*jt) < value ) value = m_SeedsAngle->vvaluex(*jt);
		v.add( BoundaryNormals->vvaluex(*jt) );
	}
	v.normalize();
	Cluster->m_Normal = v;
	Cluster->m_Value = value;
}


bool TAction_NotUsingSskelSegmentation2::canBeMerged(TCluster * f, TCluster * t)
{
	set<unsigned int>::iterator jt, kt;

	jt = f->m_Voxels.begin();
	kt = t->m_Forbidden.begin();
	while(jt != f->m_Voxels.end() && kt != t->m_Forbidden.end())
	{
		if(*jt < *kt) jt++;
		else if(*jt > *kt) kt++;
		else if(*jt == *kt) 
		{ 
			return false;
		}
	}

	jt = f->m_Forbidden.begin();
	kt = t->m_Voxels.begin();
	while(jt != f->m_Forbidden.end() && kt != t->m_Voxels.end())
	{
		if(*jt < *kt) jt++;
		else if(*jt > *kt) kt++;
		else if(*jt == *kt) 
		{ 
			return false;
		}
	}
// */

	return true;
}




void TAction_NotUsingSskelSegmentation2::perform_main()
{
	unsigned int x,y;

	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	Clusters.clear();
	set< TCluster* >::iterator it;
	
	m_UseSkeletonConstraint = true;
	m_TimeForNeighborhoods = 0;
	m_TimeForLinkages = 0;
	m_TimeForMerge = 0;
	m_TimeForFindMergingPair = 0;
	m_CountInvocationsNeighborhoods = 0;
	m_CountInvocationsLinkages = 0;
	m_CountInvocationsMerge = 0;

	// Get boundarynormals
	if(!g_Mediator.getCurrentLayerSet()->exists( TAction_ComputeNormalsClamped::getStaticName() ))
	{
		TAction_ComputeNormalsClamped Action;
		Action.perform();
	}
	BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() )  );
	if(!BoundaryNormals) throw string("BoundaryNormals not available");

	Seeds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Seeds") );
	Seeds->clear();

	m_SeedsRho = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Seeds rho ") );
	m_SeedsRho->clear();

	m_SeedsAngle = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Seeds angle ") );
	m_SeedsAngle->clear();
	
	Id2Cluster.clear();
	Id2Cluster.push_back(0);

	Queue.clear();

	m_PrecisionTimer.start();
	// Process foreground skeleton
	{
		*g_Log << "Create clusters from foreground skeleton\n";

		TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;

		// Simplify the skeleton
		{
			TAction_PruneSpSetForBoundarySegmentation SimplifiedEft;
			SimplifiedEft.m_FgBg = true;
			SimplifiedEft.m_ShortName = "spset pruned fg";
			const bool JustAdded = ! g_Mediator.getCurrentLayerSet()->exists( SimplifiedEft.m_ShortName ); 
			SimplifiedEft.perform();
			SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( SimplifiedEft.m_ShortName ) );
			if(! SPSF) throw string("!SPSF");
			if(JustAdded) skel->addShortestPathSetAdaptorField(static_cast<TShortestPathSetField*>(SPSF), SimplifiedEft.m_ShortName);
		}

		TTypedFieldInterface<TIndexedOrigins_Vector*>* BoundaryForbidden= static_cast<TTypedFieldInterface<TIndexedOrigins_Vector*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, "Fg Forbidden") );
		BoundaryForbidden->clear();

		const TFilter * FilterRho = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		
		TFilter * Filter2 = 0;
		/*
		// Get secondary filter
		{
			long LayerId = 0;
			wxString s = "";
			do
			{
				s = wxGetTextFromUser("Enter Layer ID", "Secondary filter of foreground S-skel", wxString::Format("%i",LayerId).c_str() );
				if(s == "") return;
			} 
			while( !s.ToLong(&LayerId) );

			if( LayerId != 0 && g_Mediator.getCurrentLayerSet()->getLayerById(LayerId) )
			{
				Filter2 = g_Mediator.getCurrentLayerSet()->getLayerById( LayerId )->m_Filter.get();
			}
		}
		*/


		/*
		// Also add unfiltered seed points, but do not forbid anything
		if(false)
		{
			TTypedFieldInterface<TShortestPathSet*> * SPSF =  skel->m_ForegroundSpSetField.get();
			for(x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				TShortestPathSet::TPaths & Paths = s->m_Paths;
				for(y=0; y<s->m_Eft->size(); y++)
				{
					unsigned int idx1 = (*s->m_Eft)[y];

					TCluster * Cluster1 = Id2Cluster[ Seeds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						Clusters.insert(Cluster1);
						Seeds->wvaluex(idx1) = Cluster1->m_Id;
					}
				}
			}
		}
		*/

		for(x=0; x<SPSF->getMaxIndex(); x++)
		{
			TShortestPathSet * s = SPSF->vvaluex(x);
			TShortestPathSet::TPaths & Paths = s->m_Paths;
			if(FilterRho && !FilterRho->test(s->m_SourceVoxel)) continue;
			if(Filter2 && !Filter2->test(s->m_SourceVoxel)) continue;
			
			for(y=0; y<Paths.size(); y++)
			{
				shared_ptr<TShortestPath> sp = Paths[y];
				const float rho = sp->m_Length;
				if(rho > m_SeedsRho->vvaluex(Paths[y]->m_Begin)) m_SeedsRho->wvaluex(Paths[y]->m_Begin) = rho;
				if(rho > m_SeedsRho->vvaluex(Paths[y]->m_End)) m_SeedsRho->wvaluex(Paths[y]->m_End) = rho;

				{
					TVector3 v1 = g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_Begin).toVector();
					TVector3 v2 = g_Mediator.getSkeletonizer().get()->m_BackgroundBoundaryIndexField->vidx2coord(sp->m_End).toVector();

					v1.subtract(s->m_SourceVoxel.toVector());
					v1.normalize();
					v2.subtract(s->m_SourceVoxel.toVector());
					v2.normalize();
					const float dot = 1.0f - v1.dot(v2);
					if(m_SeedsAngle->vvaluex(sp->m_Begin) == 0 || dot < m_SeedsAngle->vvaluex(sp->m_Begin)) m_SeedsAngle->wvaluex(sp->m_Begin) = dot;
					if(m_SeedsAngle->vvaluex(sp->m_End) == 0 || dot < m_SeedsAngle->vvaluex(sp->m_End)) m_SeedsAngle->wvaluex(sp->m_End) = dot;
				}
			}

			if(false)
			{
				// New approach, all feature points should end up in different segments
				for(y=0; y<s->m_Eft->size(); y++)
				{
					unsigned int idx1 = (*s->m_Eft)[y];

					TCluster * Cluster1 = Id2Cluster[ Seeds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						Clusters.insert(Cluster1);
						Seeds->wvaluex(idx1) = Cluster1->m_Id;
					}
				}
				for(y=0; y<s->m_Eft->size(); y++)
				{
					unsigned int idx1 = (*s->m_Eft)[y];
					for(unsigned int z=0; z<s->m_Eft->size(); z++)
					{
						unsigned int idx2 = (*s->m_Eft)[z];
						if(idx1==idx2) continue;
						Id2Cluster[ Seeds->vvaluex(idx1) ]->m_Forbidden.insert( idx2 );
					}
				}
			}
			else
			{
				// Old approach: take only longest path
				if(s->m_Paths.size() != 1) continue;
				for(y=0; y<Paths.size(); y++)
				{
					if(!FilterRho->test( Paths[y]->m_Length ) ) continue;

					unsigned int idx1 = Paths[y]->m_Begin;
					unsigned int idx2 = Paths[y]->m_End;
					
					TCluster * Cluster1 = Id2Cluster[ Seeds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						Clusters.insert(Cluster1);
						Seeds->wvaluex(idx1) = Cluster1->m_Id;
					}
					Cluster1->m_Forbidden.insert( idx2 );
					if( !BoundaryForbidden->vvaluex(idx1) ) BoundaryForbidden->wvaluex(idx1) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx1)->push_back( idx2 );
					
					
					TCluster * Cluster2 = Id2Cluster[ Seeds->vvaluex(idx2) ];
					if(Cluster2 == 0)
					{
						Cluster2 = new TCluster(Id2Cluster.size(),idx2);
						Id2Cluster.push_back(Cluster2);
						Clusters.insert(Cluster2);
						Seeds->wvaluex(idx2) = Cluster2->m_Id;
					}
					Cluster2->m_Forbidden.insert( idx1 );
					if( !BoundaryForbidden->vvaluex(idx2) ) BoundaryForbidden->wvaluex(idx2) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx2)->push_back( idx1 );
				}
			}
		}	
		Seeds->getLayer()->onFieldChanged();
		if(m_SeedsRho) m_SeedsRho->getLayer()->onFieldChanged();
		if(m_SeedsAngle) m_SeedsAngle->getLayer()->onFieldChanged();
		BoundaryForbidden->getLayer()->onFieldChanged();
	}



	// Now process background skeleton
	if( skel->m_BackgroundSpSetField )
	{
		long UseBG = 0;
		{
			wxString Choices[] = { "0. no", "1. yes forbid", "2. yes remove seeds" };
			wxString Result = ::wxGetSingleChoice("Use background skeleton", "Use background skeleton", 3, Choices );
			if(Result == "") return;
			Result.Left(1).ToLong(&UseBG);
		}
		if(UseBG == 1)
		{
			*g_Log << "Set forbidden from background skeleton\n";
			TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;
		
			TTypedFieldInterface<TIndexedOrigins_Vector*>* BoundaryForbidden= static_cast<TTypedFieldInterface<TIndexedOrigins_Vector*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, "Bg Forbidden") );
			BoundaryForbidden->clear();
			
			// Simplify the skeleton
			{
				TAction_PruneSpSetForBoundarySegmentation SimplifiedEft;
				SimplifiedEft.m_FgBg = false;
				SimplifiedEft.m_ShortName = "spset pruned bg";
				const bool JustAdded = ! g_Mediator.getCurrentLayerSet()->exists( SimplifiedEft.m_ShortName ); 
				SimplifiedEft.perform();
				SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( SimplifiedEft.m_ShortName ) );
				if(! SPSF) throw string("!SPSF");
				if(JustAdded) skel->addShortestPathSetAdaptorField(static_cast<TShortestPathSetField*>(SPSF), SimplifiedEft.m_ShortName);
			}

			TFloatFilter * FilterRho = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();;
			TFilter * Filter2 = 0;
			
			/*
			// Get secondary filter
			{
				long LayerId = 0;
				wxString s = "";
				do
				{
					s = wxGetTextFromUser("Enter Layer ID", "Secondary filter of background skeleton", wxString::Format("%i",LayerId).c_str() );
					if(s == "") return;
				} 
				while( !s.ToLong(&LayerId) );

				if( LayerId != 0 && g_Mediator.getCurrentLayerSet()->getLayerById(LayerId) )
				{
					Filter2 = g_Mediator.getCurrentLayerSet()->getLayerById( LayerId )->m_Filter.get();
				}
			}
			*/


			for(x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				if(!s) continue;
				TShortestPathSet::TPaths & Paths = s->m_Paths;
				if(FilterRho	&& !FilterRho->test(s->m_SourceVoxel)) continue;
				if(Filter2		&& !Filter2->test(s->m_SourceVoxel)) continue;


				// New approach, all feature points should end up in different segments
				/*
				for(y=0; y<s->m_Eft->size(); y++)
				{
					unsigned int idx1 = (*s->m_Eft)[y];

					TCluster * Cluster1 = Id2Cluster[ Seeds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						Clusters.insert(Cluster1);
						Seeds->wvaluex(idx1) = Cluster1->m_Id;
					}
				}
				for(y=0; y<s->m_Eft->size(); y++)
				{
					unsigned int idx1 = (*s->m_Eft)[y];
					for(unsigned int z=0; z<s->m_Eft->size(); z++)
					{
						unsigned int idx2 = (*s->m_Eft)[z];
						if(idx1==idx2) continue;
						Id2Cluster[ Seeds->vvaluex(idx1) ]->m_Forbidden.insert( idx2 );
					}
				}
				// */

				{
					// Insert new clusters if not exist yet
					// Old approach: take only longest path
					if(s->m_Paths.size() != 1) continue;
					for(y=0; y<Paths.size(); y++)
					{
						if(!FilterRho->test( Paths[y]->m_Length ) ) continue;

						unsigned int idx1 = Paths[y]->m_Begin;
						unsigned int idx2 = Paths[y]->m_End;
						if(idx1 > skel->m_BoundaryIndexField->getMaxIndex()) continue;
						if(idx2 > skel->m_BoundaryIndexField->getMaxIndex()) continue;
		
						// Check whether feature vectors are similar to normals
						if(true)
						{
							TVector3 a = skel->m_BoundaryIndexField->vidx2coord( idx1 ).toVector();
							a.subtract(s->m_SourceVoxel.toVector());
							a.normalize();
							
							TVector3 b = skel->m_BoundaryIndexField->vidx2coord( idx2 ).toVector();
							b.subtract(s->m_SourceVoxel.toVector());
							b.normalize();
							const float dota = BoundaryNormals->vvaluex(idx1).dot( a );
							const float dotb = BoundaryNormals->vvaluex(idx2).dot( b );
							if(dota < 0.95f || dotb < 0.95f) continue;
						}



						TCluster * Cluster1 = Id2Cluster[ Seeds->vvaluex(idx1) ];
						if(Cluster1 == 0)
						{
							Cluster1 = new TCluster(Id2Cluster.size(), idx1);
							Id2Cluster.push_back(Cluster1);
							Clusters.insert(Cluster1);
							Seeds->wvaluex(idx1) = Cluster1->m_Id;
						}
						
						Cluster1->m_Forbidden.insert( idx2 );
						if( !BoundaryForbidden->vvaluex(idx1) ) BoundaryForbidden->wvaluex(idx1) = new TIndexedOrigins_Vector(4);
						BoundaryForbidden->wvaluex(idx1)->push_back( idx2 );
						
						
						TCluster * Cluster2 = Id2Cluster[ Seeds->vvaluex(idx2) ];
						if(Cluster2 == 0)
						{
							Cluster2 = new TCluster(Id2Cluster.size(),idx2);
							Id2Cluster.push_back(Cluster2);
							Clusters.insert(Cluster2);
							Seeds->wvaluex(idx2) = Cluster2->m_Id;
						}
						Cluster2->m_Forbidden.insert( idx1 );
						if( !BoundaryForbidden->vvaluex(idx2) ) BoundaryForbidden->wvaluex(idx2) = new TIndexedOrigins_Vector(4);
						BoundaryForbidden->wvaluex(idx2)->push_back( idx1 );

					}
				}
			}		

			BoundaryForbidden->getLayer()->onFieldChanged();
		}
		else if(UseBG == 2)
		{
			TTypedFieldInterface<float>* BgDistanceField = 0;
			if(skel->m_BackgroundSpSetField)
			{
				*g_Log << "Process background\n";

				TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;
				// Simplify the skeleton
				{
					TAction_PruneSpSetForBoundarySegmentation SimplifiedEft;
					SimplifiedEft.m_FgBg = false;
					SimplifiedEft.m_ShortName = "spset pruned bg";
					const bool JustAdded = ! g_Mediator.getCurrentLayerSet()->exists( SimplifiedEft.m_ShortName ); 
					SimplifiedEft.perform();
					SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( SimplifiedEft.m_ShortName ) );
					if(! SPSF) throw string("!SPSF");
					//if(JustAdded) skel->addShortestPathSetAdaptorField(SPSF, SimplifiedEft.m_ShortName);
				}

				BgDistanceField = TAction_DistanceToField::computeField(SPSF, skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get(), "(bg)");

				TFloatFilter * Filter = BgDistanceField->getLayer()->m_Filter.get();
				Filter->m_LowerValue = 4.0f;
				//Filter->m_UpperValue = 10.0f;

				TTypedFieldInterface<float>* EdgeDistance;
				TTypedFieldInterface<float>* Edges= static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Edges (bg)" ) );
				Edges->clear();
				for(x=0; x<BgDistanceField->getMaxIndex(); x++)
				{	
					if(BgDistanceField && BgDistanceField->getLayer()->m_Filter->testx(x))
					{
						if(BgDistanceField->vvaluex(x) > Edges->vvaluex(x)) 
							Edges->wvaluex(x) = BgDistanceField->vvaluex(x);
					}
				}
				Edges->getLayer()->onFieldChanged();

				{
					EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "EdgeDistance" ) );
					EdgeDistance->clear();
					skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeeds(Edges, EdgeDistance, false);
					EdgeDistance->getLayer()->onFieldChanged();
					EdgeDistance->getLayer()->m_Filter->m_LowerValue = 5.0f;
				}


				for(unsigned int x=0; x<BgDistanceField->getMaxIndex(); x++)
				{
					if( !EdgeDistance->getLayer()->m_Filter->testx(x) )
					{
						Clusters.erase( Id2Cluster[Seeds->wvaluex(x)] );
						Seeds->wvaluex(x) = 0;
					}
				}
				Seeds->getLayer()->onFieldChanged();
			}
		}
	}



	*g_Log << "time: " << m_PrecisionTimer.stop() << "\n";

//	TTypedFieldInterface<unsigned int>* InitialSeeds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Initial Seeds") );
//	for(x=0; x<Seeds->getMaxIndex(); x++) InitialSeeds->wvaluex(x) = Seeds->vvaluex(x);
//	InitialSeeds->getLayer()->onFieldChanged();

	*g_Log << "Compute neighborhoods\n";
	m_VoxelNeighborhoods = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, "Neighborhoods" ) );
	m_VoxelNeighborhoods->clear();

	for(x=0; x<Seeds->getMaxIndex(); x++)
	{
		m_VoxelNeighborhoods->wvaluex(x) = new TIndexedOrigins_Vector(4);
	}

	{
		const float Threshold = max( skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue - 2.0f, 4.0f );

		*g_Log << "Computing neighborhoods with max distance " << Threshold << "\n";
		for(x=0; x<Seeds->getMaxIndex(); x++)
		{
			if(Seeds->vvaluex(x) != 0)
			{
				determineVoxelNeighborhood( x, Threshold );
			}
		}
	}

	// Compute distance 2 seeds field
	{
		TTypedFieldInterface<float>* Output = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to seeds " ) );
		Output->clear();
		skel->Omega->m_DeltaOmega->computeDistancesToNonZeros(Seeds, Output, 0);
		Output->getLayer()->onFieldChanged();

		Output->getLayer()->m_Filter->m_LowerValue = 10.0f;
	}


	*g_Log << "Determine normal and insert into queue\n";

	for(it=Clusters.begin(); it != Clusters.end(); it++)
	{
		TCluster * Cluster = *it;
		determineNormal(Cluster);
		computeClusterDistanceAndInsert(Cluster);
	}
	m_VoxelNeighborhoods->getLayer()->onFieldChanged();


	*g_Log << "Doing bottom-up clustering, #clusters: " << (unsigned int)Clusters.size() << "\n";

	unsigned int MergeCount = 0;
	unsigned int RecomputeDistanceCount = Clusters.size();
	while(true)
	{
		m_PrecisionTimer.start();

		TCluster * Cluster1 = 0;
		TCluster * Cluster2 = 0;
		if(true)
		{
			if(Queue.empty()) break;

			Cluster1 = Queue.begin()->second.first;
			Cluster2 = Queue.begin()->second.second;

			/*
			// Probeer max angle te vinden
			TClusterQueue::iterator itbegin = Queue.begin();
			TClusterQueue::iterator itend = Queue.lower_bound( Queue.begin()->first + 0.05f );
			float maxangle = 0.0f;
			TClusterQueue::iterator found = itbegin;
			for(TClusterQueue::iterator it = itbegin; it != itend; it++)
			{
				const float maxd = it->second.first->m_Value + it->second.second->m_Value;
				if( maxd > maxangle ) 
				{	
					maxangle = maxd;
					found = it;
				}
			}
			Cluster1 = found->second.first;
			Cluster2 = found->second.second;
			*/

			/*
			// Test: neem eerste paar to be merged clusters en merge kleinste clusters eerste
			unsigned int count = 0;
			for(TClusterQueue::iterator it = Queue.begin(); it != Queue.end() && count < 10; it++, count++)
			{
				const unsigned int CombinedVoxels = it->second.first->m_Voxels.size() + it->second.second->m_Voxels.size();
				if(CombinedVoxels < 20) 
				{
					Cluster1 = it->second.first;
					Cluster2 = it->second.second;
					break;
				} 
			}
			*/



//			const float dist = Queue.begin()->first;
			
			// Check whether normal differs not too much 
			// if( dist > 0.5f ) { *g_Log << "dist too large. Breaking.\n"; break; }

			//Queue.erase(Queue.begin());
			if(Cluster1->m_Id == 0 || Cluster2->m_Id == 0) 
			{
				throw string("Cluster1->m_Id == 0 || Cluster2->m_Id == 0");
				continue;
			}
		}		

		m_TimeForFindMergingPair += m_PrecisionTimer.stop();

		// Merge two closest clusters

		if(Cluster2->m_Voxels.size() < Cluster1->m_Voxels.size()) swap(Cluster1,Cluster2);
		mergeClusters(Cluster1,Cluster2);

			
		if(MergeCount++ % 100 == 0) { *g_Log << "."; g_Mediator.yield(); }

		// Debug: print intermediate seeds
		/*
		if(MergeCount % 1000 == 0)
		{
			TTypedFieldInterface<unsigned int>* Seeds2 = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, wxString::Format("Intermed seeds %i", MergeCount / 1000).c_str() ) );
			Seeds2->clear();
			for(x=0; x<Seeds->getMaxIndex(); x++) Seeds2->wvaluex(x) = Seeds->vvaluex(x);
			Seeds2->getLayer()->onFieldChanged();
		}
		*/
	}

	*g_Log << "\n";
	*g_Log << "m_TimeForFindMergingPair: " << m_TimeForFindMergingPair << "\n";
	*g_Log << "m_TimeForNeighborhoods: " << m_TimeForNeighborhoods << "\n";
	*g_Log << "m_CountInvocationsNeighborhoods: " << m_CountInvocationsNeighborhoods << "\n";
	*g_Log << "m_TimeForLinkages: " << m_TimeForLinkages << "\n";
	*g_Log << "m_CountInvocationsLinkages: " << m_CountInvocationsLinkages << "\n";
	*g_Log << "m_TimeForMerge: " << m_TimeForMerge << "\n";
	*g_Log << "m_CountInvocationsMerge: " << m_CountInvocationsMerge << "\n";
	*g_Log << "MergeCount: " << MergeCount << "\n";

	// Renumber final clusters
	{
		*g_Log << "--- Cluster sizes\n";
		TTypedFieldInterface<unsigned int>* Clustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters") );
		Clustering->clear();
		unsigned int c = 1;
		for(it=Clusters.begin(); it != Clusters.end(); it++) 
		{
			TCluster * Cluster = (*it);
			const unsigned int id = Cluster->m_Id;
			if( id == 0 ) continue;
				
			*g_Log << "Cluster " << id << " has " << (unsigned int)Cluster->m_Voxels.size() << " voxels.\n";
			for(set<unsigned int>::iterator jt=(*it)->m_Voxels.begin(); jt!=(*it)->m_Voxels.end(); jt++)
			{
				Clustering->wvaluex(*jt) = c;
			}
			c++;
		}
		Clustering->getLayer()->onFieldChanged();

		fillClustersUsingPaths();
	}
	
	// Debug: determine why remaining cannot be merged
	{
		*g_Log << "--- Neighborhoods\n";
		for(it=Clusters.begin(); it != Clusters.end(); it++) 
		{
			TCluster * Cluster = (*it);
			if(Cluster->m_Id == 0) continue;

			*g_Log << "Cluster " << Cluster->m_Id << ", Size: " << (unsigned int)Cluster->m_Voxels.size() << ",\t";
			
			typedef map<TCluster*, set<unsigned int> > TNeighbors;
			TNeighbors Neighbors;
			map<TCluster*, set<unsigned int> >::iterator it;
			{
				{
					set<unsigned int>::iterator it;
					for(it = Cluster->m_BoundaryVoxels.begin(); it != Cluster->m_BoundaryVoxels.end(); it++)
					{
						TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(*it)->castVector();
						for(unsigned int x=0; x<v->size(); x++)
						{
							TCluster * c = Id2Cluster[ Seeds->vvaluex((*v)[x]) ];
							if(c == Cluster) continue;
							assert(c != 0);
							if( Neighbors.find(c) == Neighbors.end() )
							{
								Neighbors.insert( pair<TCluster*,set<unsigned int> >(c, set<unsigned int>() ) );
							}
							Neighbors[c].insert( *it );
						}
					}
				}

			}

			typedef map<TCluster*, set<unsigned int> > TForbidden;
			TForbidden Forbidden;
			{
//				*g_Log << "Forbidden: ";
				{
					for(set<unsigned int>::iterator jt=Cluster->m_Forbidden.begin(); jt!=Cluster->m_Forbidden.end(); jt++)
					{
						TCluster * C = Id2Cluster[ Seeds->vvaluex(*jt) ];
						if(Forbidden.find(C) == Forbidden.end()) Forbidden.insert( TForbidden::value_type(C, set<unsigned int>() ) );
						Forbidden.find(C)->second.insert( *jt );
					}
				}

				/*
				{
					for(TForbidden::iterator jt=Forbidden.begin(); jt!=Forbidden.end(); jt++)
					{
						TCluster * C = (*jt).first;
						unsigned int VoxelCount = (*jt).second.size();
						*g_Log << C->m_Id << " (w/ " << VoxelCount << " vox), ";
						if(Cluster->m_Id == C->m_Id) *g_Log << "[!!!]";
						if(VoxelCount < 5) 
						{
							*g_Log << "(voxels: ";
							for(set<unsigned int>::iterator kt=(*jt).second.begin(); kt != (*jt).second.end(); kt++)
							{
								*g_Log << *kt << ",";								
							}
							*g_Log << ") ";
						}
						
						//if(VoxelCount < 5) { *g_Log << "voxels: 
					}
				}
				*/

				*g_Log << "\nNeighbors: ";
				TNeighbors::iterator it;
				for(it = Neighbors.begin(); it != Neighbors.end() ;it++)
				{
					unsigned int neighorbingvoxels = it->second.size();
					unsigned int forbiddenvoxels = Forbidden[ it->first ].size();
					*g_Log << "\t\tcluster " << it->first->m_Id << ", #boundaryvoxels: " << neighorbingvoxels << ", #forbidden: " << forbiddenvoxels << ", ";
					*g_Log << wxString::Format("with ratio %.2f", (float)forbiddenvoxels / (float)neighorbingvoxels).c_str() << "\n";
				}

				*g_Log << "\n";
			}

			/*
			*g_Log << "Neighbors: ";
			for(TCluster::TNeighborhood::iterator it=Cluster->m_Neighborhood.begin(); it != Cluster->m_Neighborhood.end(); it++)
			{
				TCluster * NC = it->second;
				*g_Log << NC->m_Id << ", ";
			}
			*g_Log << "\n";
			*/
		}
	}

	// Delete
	for(it=Clusters.begin(); it != Clusters.end(); it++) delete *it;
}

void TAction_NotUsingSskelSegmentation2::removeFromQueue(TCluster * Cluster)
{
	for(unsigned int x=0; x<Cluster->m_ClusterEntries.size(); x++)
	{
		Queue.erase( Cluster->m_ClusterEntries[x] );
	}
	Cluster->m_ClusterEntries.clear();
}

void TAction_NotUsingSskelSegmentation2::mergeClusters(TCluster * Cluster1, TCluster * Cluster2)
{
//	if(!canBeMerged(Cluster1,Cluster2) ) throw string("!canBeMerged(Cluster1,Cluster2) ");
	assert( canBeMerged(Cluster1,Cluster2) );
	m_PrecisionTimer.start();

	// Merge voxels of 2 to 1
	for(set<unsigned int>::iterator jt=Cluster2->m_Voxels.begin(); jt!=Cluster2->m_Voxels.end(); jt++)
	{
		const unsigned int idx = *jt;
		Cluster1->m_Voxels.insert(idx);
		Seeds->wvaluex(idx) = Cluster1->m_Id;
	}

	// Merge forbidden
	{
		for(set<unsigned int>::iterator kt=Cluster2->m_Forbidden.begin(); kt!=Cluster2->m_Forbidden.end(); kt++)
		{
			Cluster1->m_Forbidden.insert(*kt);
		}
	}

	// Determine boundary voxels
	{
		set<unsigned int> NewBoundaryVoxels;
		
		set<unsigned int>::iterator it;
		for(it = Cluster1->m_BoundaryVoxels.begin(); it != Cluster1->m_BoundaryVoxels.end(); it++)
		{
			TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(*it)->castVector();
			for(unsigned int x=0; x<v->size(); x++)
			{
				const unsigned int idx = (*v)[x];
				if(Seeds->vvaluex( idx ) != Cluster1->m_Id )
					NewBoundaryVoxels.insert( *it );
			}
		}
		for(it = Cluster2->m_BoundaryVoxels.begin(); it != Cluster2->m_BoundaryVoxels.end(); it++)
		{
			TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(*it)->castVector();
			for(unsigned int x=0; x<v->size(); x++)
			{
				const unsigned int idx = (*v)[x];
				if( Seeds->vvaluex( idx ) != Cluster1->m_Id )
					NewBoundaryVoxels.insert( *it );
			}
		}
		Cluster1->m_BoundaryVoxels = NewBoundaryVoxels;
	}

	// Determine dirty clusters 
	// Do this by looking at m_VoxelNeighbors of cluster 1, which contains voxels of cluster2
	set<TCluster*> DirtyClusters;
	DirtyClusters.insert( Cluster1 );
	DirtyClusters.insert( Cluster2 );
	{
		set<unsigned int>::iterator it;
		for(it = Cluster1->m_BoundaryVoxels.begin(); it != Cluster1->m_BoundaryVoxels.end(); it++)
		{
			TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(*it)->castVector();
			for(unsigned int x=0; x<v->size(); x++)
			{
				DirtyClusters.insert( Id2Cluster[ Seeds->vvaluex( (*v)[x]) ] );
			}
		}
	}

	set<TCluster*>::iterator it;
	for(it = DirtyClusters.begin(); it != DirtyClusters.end(); it++)
	{
		TCluster * c = *it;
		removeFromQueue(c);
	}

	// Clear cluster2
	Id2Cluster[Cluster2->m_Id] = 0;
	Cluster2->m_Id = 0;
	Cluster2->m_Voxels.swap( set<unsigned int>() );
	Cluster2->m_Forbidden.swap( set<unsigned int>() );
	Cluster2->m_BoundaryVoxels.swap( set<unsigned int>() );

	determineNormal(Cluster1);

	DirtyClusters.erase( Cluster2 );
	for(it = DirtyClusters.begin(); it != DirtyClusters.end(); it++)
	{
		computeClusterDistanceAndInsert(*it);
	}

	
/*

	// Merge neighbors
	{
		for(TCluster::TNeighbors::iterator kt=Cluster2->m_Neighbors.begin(); kt != Cluster2->m_Neighbors.end(); kt++)
		{
			unsigned int idx = (*kt).second;
			// Only merge neighboring voxels that are not in Cluster1
			if(Cluster1->m_Voxels.find(idx) == Cluster1->m_Voxels.end() )
			{
				Cluster1->m_Neighbors.insert( *kt );
			}
		}
	}
	Cluster2->m_Neighbors.clear();

	// Debug, test
	// Do check whether cluster1 neighborhood does not contain itself
	{
		vector<TCluster::TNeighbors::iterator> RemoveThese;

		for(TCluster::TNeighbors::iterator kt=Cluster1->m_Neighbors.begin(); kt != Cluster1->m_Neighbors.end(); kt++)
		{
			unsigned int idx = (*kt).second;
			if(Cluster1->m_Voxels.find(idx) != Cluster1->m_Voxels.end())
			{
				RemoveThese.push_back(kt);
				//throw string("Cluster neighborhood contains cluster itself");
			}
		}

		for(unsigned int x=0; x<RemoveThese.size(); x++)
		{
			Cluster1->m_Neighbors.erase(RemoveThese[x]);
		}

	}
	
	Id2Cluster[Cluster2->m_Id] = 0;
	determineNormal(Cluster1);
	computeClusterDistance(Cluster1);

	// Determine new neighborhoods
	//for(TCluster::TPotentialMergers::iterator it=Cluster2->m_PotentialMergers.begin(); it != Cluster2->m_PotentialMergers.end(); it++)
	//{
	//	TCluster * NC = it->second;
	//	if(NC->m_Id != 0) computeClusterDistance(NC);
	//}

	// Try only to update linkages of clusters that might have changed
	for(TCluster::TNeighbors::iterator it=Cluster2->m_Neighbors.begin(); it != Cluster2->m_Neighbors.end(); it++)
	{
		computeClusterDistance( Id2Cluster[ Seeds->vvaluex((*it).second ) ] );
	}
*/


	m_TimeForMerge += m_PrecisionTimer.stop();
	m_CountInvocationsMerge++;
}


void TAction_NotUsingSskelSegmentation2::fillClustersUsingPaths()
{
}



// -------------------------------------------------------------------

bool TAction_PruneSpSetForBoundarySegmentation::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 
}

TShortestPathSet * TAction_PruneSpSetForBoundarySegmentation::process(TShortestPathSet * sps)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();


	unsigned int y,a;
	// Detect equivalence sets
	typedef set< set<unsigned int> > TEqSet;
	TEqSet eqset;
	{
		for(y=0; y<sps->m_Eft->size(); y++) 
		{
			set<unsigned int> s;
			unsigned int idx = (*sps->m_Eft)[y];
			s.insert(idx);
			eqset.insert(s);
		}

		TEqSet::iterator it;
		TEqSet::iterator jt;
		for(y=0; y<sps->m_Paths.size(); y++) 
		{
			TShortestPath * sp = sps->m_Paths[y].get();
			if( 
				(FilterRho && !FilterRho->test(sp->m_Length) ) 
				)

			{
				unsigned int idx1 = sp->m_Begin;
				unsigned int idx2 = sp->m_End;		 	
				for(it = eqset.begin(); it != eqset.end(); it++) if(it->find(idx1) != it->end()) break;
				for(jt = eqset.begin(); jt != eqset.end(); jt++) if(jt->find(idx2) != jt->end()) break;

				// Now merge jt to it
				if(it != jt)
				{
					set<unsigned int>::iterator kt;
					for(kt=jt->begin(); kt != jt->end(); kt++) 
					{
						unsigned int idx = *kt;
						set<unsigned int> & s = const_cast<set<unsigned int> & >(*it);
						s.insert(idx);
					}
		
					eqset.erase(jt);
				}
			}
		}
	}

	// Now for each pair of items in eqset a path should remain
	TShortestPathSet::TPaths NewPaths;
	{
		TEqSet::iterator it;
		TEqSet::iterator jt;

		// For each two equivalence sets 
		for(it = eqset.begin(); it != eqset.end(); it++)
		for(jt = it; jt != eqset.end(); jt++)
		{
			if(it == jt) continue;
		
			unsigned int idx1 = *it->begin(); 
			unsigned int idx2 = *jt->begin();
			for(a=0; a<sps->m_Paths.size(); a++)
			{
				shared_ptr<TShortestPath> sp = sps->m_Paths[a];
				if( 
					(sp->m_Begin == idx1 && sp->m_End == idx2)
					||
					(sp->m_Begin == idx2 && sp->m_End == idx1)
					)
				{
					NewPaths.push_back( sp );
				}
			}
			
		}
	}


	{
		shared_ptr<TIndexedOrigins_Vector> NewEft( new TIndexedOrigins_Vector() );
		set<unsigned int> EftSet;
		for(a=0; a<NewPaths.size(); a++)
		{
			EftSet.insert( NewPaths[a]->m_Begin  );
			EftSet.insert( NewPaths[a]->m_End );
		}
		set<unsigned int>::iterator it;
		for(it = EftSet.begin(); it != EftSet.end(); it++)
		{
			NewEft->push_back( *it );
		}

		TShortestPathSet * newsps = new TShortestPathSet( sps->m_SourceVoxel, NewEft);
		newsps->m_PathSet.reset( new TIndexedOrigins_Vector() );
		newsps->m_Paths = NewPaths;
		newsps->updatePathSet();
		return newsps;
	}
}

void TAction_PruneSpSetForBoundarySegmentation::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

	string name = m_ShortName != "" ? m_ShortName : getName();
	TTypedFieldInterface<TShortestPathSet*>* Output = 0;
	if(m_FgBg)
	{
		FilterRho = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		//FilterEcc = g_Mediator.getCurrentLayerSet()->getLayer("spset fg eccentricity")->m_Filter.get();
		SPSF = skel->m_ForegroundSpSetField.get();
		Output = static_cast<TTypedFieldInterface<TShortestPathSet*>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_SHORTESTPATHSET, skel->m_ForegroundSskelIndexField, name ) );
	}
	else
	{
		FilterRho = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		//FilterEcc = g_Mediator.getCurrentLayerSet()->getLayer("spset bg eccentricity")->m_Filter.get();
		SPSF = skel->m_BackgroundSpSetField.get();
		Output = static_cast<TTypedFieldInterface<TShortestPathSet*>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_SHORTESTPATHSET, skel->m_BackgroundSskelIndexField, name ) );
	}
	Output->clear();

	for(unsigned int x=0; x<SPSF->getMaxIndex(); x++)
	{
		const TCoord3 p = SPSF->getIndexField()->vidx2coord(x);
		TShortestPathSet * sps = SPSF->vvaluex(x);
		if(sps == 0) continue;

		TShortestPathSet * newsps = process(sps);
		Output->wvaluep(p) = newsps;
	}		

	Output->getLayer()->m_Name = getStaticName(); // + wxString::Format(" %.2f",Filter->m_LowerValue).c_str();
	Output->getLayer()->onFieldChanged();
//	Output->getLayer()->m_Filter->m_LowerValue = 2.99f;
	g_Mediator.updateUI();

}

