#ifndef BOUNDARYSEGMENTATION_H
#define BOUNDARYSEGMENTATION_H

#include "abstractaction.h"
#include "shortestpath.h"
#include "utils.h"
#include "abstractfilter.h"

#include <map>
using std::multimap;




class TAction_SkeletonizeForBoundarySegmentation : public TAction
{
public:
	virtual string getName() { return "Skeletonize for boundary segmentation"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	virtual void perform_init();
	string m_Filename;
};




class TAction_InverseEftComplete : public TAction
{
public:
	static string getStaticName() { return "Inverse Eft complete using S-skel filter"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_ComputeNormalsClamped : public TAction
{
public:
	static string getStaticName() { return "BoundaryNormal"; }
	virtual string getName() { return getStaticName(); }
	virtual string getScreenName() { return "Normals Clamped"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};




class TAction_BoundaryNormalFromInverseEft : public TAction
{
public:
	static string getStaticName() { return "BoundaryNormal"; }
	virtual string getName() { return getStaticName(); }
	virtual string getScreenName() { return "Boundary normal using inverse Eft"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_BoundaryNormalUsingForwardEftAndShortestPaths : public TAction
{
public:
	static string getStaticName() { return "BoundaryNormal"; }
	virtual string getName() { return getStaticName(); }
	virtual string getScreenName() { return "Boundary normal using forward Eft"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_FillUsingClusters : public TAction
{
public:
	static string getStaticName() { return "B. Clusters Filled"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



typedef multimap<float, pair<class TCluster*,class TCluster*> > TClusterQueue;

class TCluster
{
public:
	TCluster(unsigned int p_Id, unsigned int p_Voxel)
	{
		m_Id = p_Id;
		m_Voxels.insert(p_Voxel);
		m_BoundaryVoxels.insert( p_Voxel);
	}
	TVector3 m_Normal;
	float m_Value;
	unsigned int m_Id;
	set<unsigned int> m_Voxels;
	set<unsigned int> m_BoundaryVoxels;

	typedef multimap<float, unsigned int> TNeighbors;
	TNeighbors m_Neighbors;
	set<unsigned int> m_Forbidden;
	
//	typedef multimap< float,TCluster* > TPotentialMergers;
//	TPotentialMergers m_PotentialMergers;

	vector< TClusterQueue::iterator > m_ClusterEntries;
};


class TAction_NotUsingSskelSegmentation2 : public TAction
{
public:
	virtual string getName() { return "A. Not using S-skel segm. 2 (using necessary condition)"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();


protected:
	virtual void perform_main();
	void determineNormal(TCluster * Cluster);
	bool canBeMerged(TCluster * f, TCluster * t);
	void mergeClusters(TCluster * Cluster1, TCluster * Cluster2);

	TTypedFieldInterface<unsigned int>*  Seeds;
	TTypedFieldInterface<float>*  m_SeedsRho;
	TTypedFieldInterface<float>*  m_SeedsAngle;
	TTypedFieldInterface<TIndexedOrigins*>*  m_VoxelNeighborhoods;
	void determineVoxelNeighborhood(unsigned int p_Voxel, float p_Threshold);
	
	void removeFromQueue(TCluster * Cluster);

	TTypedFieldInterface<set<TCluster*> >* m_VoxelObservers;
	TTypedFieldInterface<TVector3>* BoundaryNormals;
	set< TCluster* > Clusters;
	vector<TCluster*> Id2Cluster;
	TClusterQueue Queue;
	bool m_UseSkeletonConstraint;

	void determineNeighborhood(TCluster * Cluster);
	void computeClusterDistanceAndInsert(TCluster * Cluster);
	void fillClustersUsingPaths();

	TPrecisionTimer m_PrecisionTimer;
	float m_TimeForNeighborhoods;
	unsigned int m_CountInvocationsNeighborhoods;
	float m_TimeForLinkages;
	unsigned int m_CountInvocationsLinkages;
	float m_TimeForMerge;
	unsigned int m_CountInvocationsMerge;
	float m_TimeForFindMergingPair;
};

class TAction_PruneSpSetForBoundarySegmentation : public TAction
{
public:
	TAction_PruneSpSetForBoundarySegmentation()
		: m_FgBg(true)
	{
	};

	static string getStaticName() { return "Pruned sp set"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual string getScreenName() { return "Pruned ps set for boundary segm."; }
	virtual bool isAvailable();
	string m_ShortName;
	TShortestPathSet *  process(TShortestPathSet * sps);
	bool m_FgBg;
protected:
	virtual void perform_main();
	TFloatFilter * FilterRho;
//	TFloatFilter * FilterEcc;
	TTypedFieldInterface<TShortestPathSet*> * SPSF;
};



#endif


