#include "stdafx.h"

#include "boundarysegmentation.h"
#include "boundarysegmentation_old.h"

#include "globals.h"
#include "layer.h"
#include "skeletonizer.h"
#include "colormap.h"
#include "deltaomega.h"
#include "action.h"
#include "logwriter.h"
#include "filter.h"

#include "sskelsegmentation.h"

using namespace std;




// ------------------------------------------------------------------------------------------


bool TAction_ForwardBoundarySegmentationUsingNearestNonZero::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return false;
}


void TAction_ForwardBoundarySegmentationUsingNearestNonZero::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
/*
	TTypedFieldInterface<unsigned int>* Segments = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField(TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() ) );
	Segments->clear();

	const TShortestPathSetField * SPSF = skel->m_UseThisSpSetField.get();

	TTypedFieldInterface<float>* Skel = skel->m_ForegroundSurfaceSkeletonField;
	*g_Log << "Using layer and filter \"" << Skel->getLayer()->m_Name << "\"\n";
	const TFloatFilter * Filter = static_cast<TFloatFilter*>( Skel->getLayer()->m_Filter.get() );

	unsigned int x, y;
	typedef multimap<float, const TShortestPath*, greater<float> > TMap;
	TMap S;
	for(x=0; x<SPSF->getIndexField()->getMaxIndex(); x++)
	{
		const TShortestPathSet * sps = SPSF->m_Values[x];
		for(y=0; y<sps->m_Paths.size(); y++)
		{
			shared_ptr<TShortestPath> sp = sps->m_Paths[y];
			if(Filter->test(sp->m_Length))
			{
				S.insert( TMap::value_type(sp->m_Length, sp.get()) );
			}
		}
	}
	
	
	unsigned int CurrentSegment = 1;
	TMap::const_iterator it;

	for(it = S.begin(); it != S.end(); it++)
	{
		const TShortestPath * sp = it->second;
		
		unsigned int idx1 = sp->m_Begin;
		unsigned int idx2 = sp->m_End;
		float dist1, dist2;
		unsigned int near1 = skel->Omega->m_DeltaOmega->findNearestNonZero(idx1, Segments, dist1);
		unsigned int near2 = skel->Omega->m_DeltaOmega->findNearestNonZero(idx2, Segments, dist2);

		assert( ! (dist1 == (numeric_limits<float>::max)() && !near1 == TIndexedOrigins::INVALIDINDEX) );
		assert( ! (dist2 == (numeric_limits<float>::max)() && !near2 == TIndexedOrigins::INVALIDINDEX) );

		float rho = sp->m_Length / 2.0f;
		if(dist1 < rho )
		{	
			Segments->wvaluex(idx1) = Segments->vvaluex(near1);
		}
		else
		{
			Segments->wvaluex(idx1) = CurrentSegment++;
		}

		if(dist2 < rho )
		{	
			Segments->wvaluex(idx2) = Segments->vvaluex(near2);
		}
		else
		{
			Segments->wvaluex(idx2) = CurrentSegment++;
		}
	}

	Segments->getLayer()->onFieldChanged();
	*/
}

// ------------------------------------------------------------------------------------------


bool TAction_ForwardBoundarySegmentationUsingNearestNonZeroAndNeighborsFirst::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return false;
}


void TAction_ForwardBoundarySegmentationUsingNearestNonZeroAndNeighborsFirst::perform_main()
{
/*
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TTypedFieldInterface<unsigned int>* Segments = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField(TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() ) );
	Segments->clear();

	const TShortestPathSetField * SPSF = skel->m_UseThisSpSetField.get();

	shared_ptr<TSparseFloatField3> Skel = skel->m_ForegroundSurfaceSkeletonField;
	*g_Log << "Using layer and filter \"" << Skel->getLayer()->m_Name << "\"\n";
	const TFloatFilter * Filter = static_cast<TFloatFilter*>( Skel->getLayer()->m_Filter.get() );

	unsigned int x, y;
	typedef multimap<float, pair<TCoord3, TShortestPath*>, greater<float> > TMap;
	TMap S;
	for(x=0; x<SPSF->getIndexField()->getMaxIndex(); x++)
	{
		const TCoord3 p = SPSF->getIndexField()->vidx2coord(x);
		const TShortestPathSet * sps = SPSF->m_Values[x];
		for(y=0; y<sps->m_Paths.size(); y++)
		{
			shared_ptr<TShortestPath> sp = sps->m_Paths[y];
			sp->m_UserData = 1;
			if(Filter->test(sp->m_Length))
			{
				S.insert( TMap::value_type(sp->m_Length, pair<TCoord3, TShortestPath*>(p,sp.get()))  );
			}
		}
	}

	unsigned int CurrentSegment = 1;
	TMap::const_iterator it;

//	TMap T;
//	T.insert( *S.begin() );
	TCoord3 np;

	TCoord3 currentcoord = S.begin()->second.first;
	TShortestPath * currentsp = S.begin()->second.second;

	while(currentsp != 0)
	{
		TShortestPath * sp = currentsp;
		TCoord3 p = currentcoord;
		//if(sp->m_UserData == 0) continue;
		sp->m_UserData = 0;
	
		
		unsigned int idx1 = sp->m_Begin;
		unsigned int idx2 = sp->m_End;
		float dist1, dist2;
		unsigned int near1 = skel->Omega->m_DeltaOmega->findNearestNonZero(idx1, Segments, dist1);
		unsigned int near2 = skel->Omega->m_DeltaOmega->findNearestNonZero(idx2, Segments, dist2);

		assert( ! (dist1 == (numeric_limits<float>::max)() && !near1 == TIndexedOrigins::INVALIDINDEX) );
		assert( ! (dist2 == (numeric_limits<float>::max)() && !near2 == TIndexedOrigins::INVALIDINDEX) );

		float rho = sp->m_Length / 2.0f;
		if(dist1 < rho )
		{	
			Segments->wvaluex(idx1) = Segments->vvaluex(near1);
		}
		else
		{
			Segments->wvaluex(idx1) = CurrentSegment++;
		}

		if(dist2 < rho )
		{	
			Segments->wvaluex(idx2) = Segments->vvaluex(near2);
		}
		else
		{
			Segments->wvaluex(idx2) = CurrentSegment++;
		}
	
		// Go to neighbor with highest path length
		float maxlength = 0.0f;
		TCoord3 maxcoord;
		TShortestPath * maxsp = 0;
		for(np.x=p.x-1; np.x<=p.x+1; np.x++) // neighbors
		for(np.y=p.y-1; np.y<=p.y+1; np.y++)
		for(np.z=p.z-1; np.z<=p.z+1; np.z++)
		{
			if(np == p) continue;
			if(!SPSF->getIndexField()->vinside(np)) continue;

			const TShortestPathSet * sps = SPSF->vvaluep(np);
			if(sps == 0) continue;
			for(y=0; y<sps->m_Paths.size(); y++)
			{
				TShortestPath * sp = sps->m_Paths[y].get();
				//T.insert( TMap::value_type(sp->m_Length, pair<TCoord3, TShortestPath*>(np,sp))  );
				if(sp->m_UserData == 1 && sp->m_Length > maxlength) 
				{
					maxlength = sp->m_Length;
					maxcoord = np;
					maxsp = sp;
				}
			}
		}
		
		currentcoord = maxcoord;
		currentsp = maxsp;
	}

	Segments->getLayer()->onFieldChanged();
*/
}




// ------------------------------------------------------------------------------------------

bool TAction_CurvatureUsingReverseTftAndLocalSheets::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return 
		false
		&&
		g_Mediator.getCurrentLayer()->m_Field->getType() == TType::TYPE_INDEXEDORIGINS;
		// && g_Mediator.getCurrentLayerSet()->exists( TAction_ReverseTft::getStaticName() );
}

void TAction_CurvatureUsingReverseTftAndLocalSheets::perform_main()
{
/*
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
//	const TShortestPathSetField * SPSF = skel->m_UseThisSpSetField.get();
//	const TTypedFieldInterface<class TShortestPathSet *> * SPSF = skel->m_SpSetPrunedFilteredField;

	TTypedFieldInterface<TShortestPathSet*>* SPSF = static_cast<TTypedFieldInterface<TShortestPathSet*>*>( g_Mediator.getCurrentLayerSet()->getField(  TAction_ExtendStSegmToS0Segm::getStaticName() ) );
	if(SPSF == 0)
	SPSF = skel->m_SpSetPrunedField.get();


	shared_ptr<TSparseFloatField3> Skel = skel->m_ForegroundSurfaceSkeletonField;
	*g_Log << "Using layer and filter \"" << Skel->getLayer()->m_Name << "\"\n";
	const TFloatFilter * Filter = static_cast<TFloatFilter*>( Skel->getLayer()->m_Filter.get() );

	static long OnlyToThisSegment = 0;
	{
		wxString s = "";
		do
		{
			s = wxGetTextFromUser("Only to this segment", "Only to this segment", wxString::Format("%i",OnlyToThisSegment).c_str() );
			if(s == "") return;
		} 
		while( !s.ToLong(&OnlyToThisSegment) );
	}


	//TTypedFieldInterface<TIndexedOrigins*>* Tft = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_ReverseTft::getStaticName() )  );
	TTypedFieldInterface<TIndexedOrigins*>* Tft = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayer()->m_Field.get() );
	TTypedFieldInterface<float>* Output= static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField(TType::TYPE_FLOAT, Tft->getIndexField(), getName()) );
	Output->clear();

	unsigned int x,y,z;
	for(x=0; x<Tft->getIndexField()->getMaxIndex(); x++)
	{
		const TCoord3 px = Tft->getIndexField()->vidx2coord(x);
		float mindot = (numeric_limits<float>::max)();

		const TIndexedOrigins_Vector & tft = *Tft->vvaluep(px)->castConstVector();
		for(y=0; y<tft.size(); y++)
		{
			const TCoord3 py = Tft->getIndexToField()->vidx2coord(tft[y]);
			TVector3 v = px.toVector();
			v.subtract(py.toVector());
			v.normalize();

			const TShortestPathSet * sps = SPSF->vvaluep(py);
			if(!sps) continue;
			for(z=0; z<sps->m_Paths.size(); z++)
			{
				const TShortestPath * sp = sps->m_Paths[z].get();
				if(!Filter->test(sp->m_Length)) continue;
				if(OnlyToThisSegment != 0 && sp->m_UserData == 0) continue;
				if(OnlyToThisSegment != 0 && OnlyToThisSegment != sp->m_UserData) continue;

				const float dot = fabs( v.dot(sp->m_LocalSheet->getNormal() ) );
				if(dot < mindot) mindot = dot;
			}
		}
		Output->wvaluex(x) = mindot;
	}
	Output->getLayer()->onFieldChanged();
	Output->getLayer()->m_Filter->m_LowerValue = 0.0f;
*/
}



// ------------------------------------------------------------------------------------------


bool TAction_MapSskelSegmUsingFt::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();
	return segm != 0;
}

TTypedFieldInterface<unsigned int>* TAction_MapSskelSegmUsingFt::mapFt(TSskelSegmenter * p_Segm, string p_Name)
{
	TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, g_Mediator.getSkeletonizer()->m_BoundaryIndexField, p_Name ) );
	Output->clear();
	
	// Old: use nodefield
	TTypedFieldInterface<vector<TNode*>*>* NodeField = p_Segm->m_SskelGraph.m_NodeField;
	if(!NodeField) throw string("!NodeField");
	p_Segm->m_SskelGraph.unifyLocalSheetNormals();

	unsigned int x,y;
	for(x=0; x<NodeField->getMaxIndex(); x++)
	{
		vector<TNode*>* Nodes = NodeField->vvaluex(x);
		TCoord3 p = NodeField->getIndexField()->vidx2coord(x);
		if(Nodes == 0) continue;
		for(y=0; y<Nodes->size(); y++)
		{
			TNode * N = (*Nodes)[y];
			if(N->m_SegmentId == 0) continue;

			unsigned int segid1 = N->m_SegmentId * 2 + 0;
			unsigned int segid2 = N->m_SegmentId * 2 + 1;
			unsigned int fp1 = N->m_ShortestPath->m_Begin;
			unsigned int fp2 = N->m_ShortestPath->m_End;
			{
				TVector3 vfp1 = Output->getIndexField()->vidx2coord(fp1).toVector();
				vfp1.subtract(p.toVector());
				vfp1.normalize();
				if( N->m_ShortestPath->m_LocalSheet->getNormal().dot( vfp1  ) < 0.0f)
				{
					swap(fp1,fp2);
				}
			}
			
			if(Output->vvaluex(fp1) != 0 && Output->vvaluex(fp1) != segid1) Output->wvaluex(fp1) = (numeric_limits<unsigned int>::max)();
			if(Output->vvaluex(fp1) != (numeric_limits<unsigned int>::max)())
			{
				Output->wvaluex(fp1) = segid1;
			}
			
			if(Output->vvaluex(fp2) != 0 && Output->vvaluex(fp2) != segid2) Output->wvaluex(fp2) = (numeric_limits<unsigned int>::max)();
			if(Output->vvaluex(fp2) != (numeric_limits<unsigned int>::max)())
			{
				Output->wvaluex(fp2) = segid2;
			}
		}
	}

	// Remove numeric_limits<unsigned int>::max
	for(x=0; x<Output->getMaxIndex(); x++)
	{
		if(Output->vvaluex(x) == (numeric_limits<unsigned int>::max)())
			Output->wvaluex(x) = 0;
	}
	
	Output->getLayer()->onFieldChanged();
	return Output;
}

TTypedFieldInterface<unsigned int>* TAction_MapSskelSegmUsingFt::mapFt(TTypedFieldInterface<unsigned int>* p_Segm, const TTypedFieldInterface<TShortestPathSet*>* p_SPSF, string p_Name)
{
	TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, g_Mediator.getSkeletonizer()->m_BoundaryIndexField, p_Name ) );
	Output->clear();
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

	unsigned int x;

	const TIndexMapper * Boundary = skel->m_BoundaryIndexField.get();
	vector<bool> Visited(p_Segm->getMaxIndex(), false);
	for(x=0; x<p_Segm->getMaxIndex(); x++)
	{
		if(p_Segm->vvaluex(x) != 0 && !Visited[x])
		{
			typedef pair<TVector3,TVector3> TCoordPair;
			typedef pair<unsigned int, TCoordPair > TQueueItem;
			queue< TQueueItem > Q;

			const TIndexedOrigins_Vector & vec = *p_SPSF->vvaluex(x)->m_Eft.get();
			{
				const TCoord3 p = p_Segm->getIndexField()->vidx2coord(x);
				TVector3 vCoord1 = Boundary->vidx2coord(vec[0]).toVector();
				vCoord1.subtract(p.toVector());
				vCoord1.normalize();
				TVector3 vCoord2 = Boundary->vidx2coord(vec[1]).toVector();
				vCoord2.subtract(p.toVector());
				vCoord2.normalize();

				Q.push( 
					TQueueItem(
								x, 
								TCoordPair(vCoord1,vCoord2)
								) 
							);
			}

			while(!Q.empty())
			{
				const unsigned int idx = Q.front().first;
				TVector3 vOldCoord1 = Q.front().second.first;
				TVector3 vOldCoord2 = Q.front().second.second;
				Q.pop();
				Visited[idx] = true;
				const TCoord3 p = p_Segm->getIndexField()->vidx2coord(idx);
					
				const TShortestPathSet * sps = p_SPSF->vvaluex(idx);
				if(sps == 0) continue;
				if(sps->m_Eft.get() == 0) continue;
				const TIndexedOrigins_Vector & vec = *sps->m_Eft.get();
				if(vec.size() < 2) continue;
				else if(vec.size() == 2)
				{
					TCoord3 Coord1 = Boundary->vidx2coord(vec[0]);
					TVector3 vCoord1 = Coord1.toVector();
					vCoord1.subtract(p.toVector());
					vCoord1.normalize();
					TCoord3 Coord2 = Boundary->vidx2coord(vec[1]);
					TVector3 vCoord2 = Coord2.toVector();
					vCoord2.subtract(p.toVector());
					vCoord2.normalize();

					if( vCoord1.dot(vOldCoord1) + vCoord2.dot(vOldCoord2) < vCoord1.dot(vOldCoord2) + vCoord2.dot(vOldCoord1) )
					{
						swap(Coord1,Coord2);
						swap(vCoord1,vCoord2);
					}

					// Project FT
					Output->wvaluep( Coord1 ) = p_Segm->vvaluex(idx)*2+0;
					Output->wvaluep( Coord2 ) = p_Segm->vvaluex(idx)*2+1;
					vOldCoord1 = vCoord1;
					vOldCoord2 = vCoord2;				
				}

				// Insert neighbors into queue
				TCoord3 np;
				for(np.x=p.x-1; np.x<=p.x+1; np.x++) // neighbors
				for(np.y=p.y-1; np.y<=p.y+1; np.y++)
				for(np.z=p.z-1; np.z<=p.z+1; np.z++)
				{
					if(p_Segm->vvaluep(np) != 0)
					{
						const unsigned int npidx = p_Segm->getIndexField()->vcoord2idx(np);
						if(!Visited[npidx])
						{
							Q.push( TQueueItem(npidx, TCoordPair(vOldCoord1,vOldCoord2)) );
							Visited[npidx] = true;
						}
					}
				}
				
			}
		}
	}	

		
	Output->getLayer()->onFieldChanged();
	return Output;
}

void TAction_MapSskelSegmUsingFt::renumber(TTypedFieldInterface<unsigned int> * p_Field)
{	
	unsigned int x;
	
	// Get maximum id
	unsigned int maxid = 0;
	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		if(p_Field->vvaluex(x) > maxid) maxid = p_Field->vvaluex(x);
	}	

	vector<unsigned int> Renumber( maxid+1, 0 );
	unsigned int FreeId = 1;
	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		const unsigned int id = p_Field->vvaluex(x);
		if(id == 0) continue;
		if(Renumber[id] == 0)
		{
			Renumber[id] = FreeId++;
		}
	}

	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		p_Field->wvaluex(x) = Renumber[p_Field->vvaluex(x)];
	}

	p_Field->getLayer()->onFieldChanged();
}

void TAction_MapSskelSegmUsingFt::cleanup(TTypedFieldInterface<unsigned int> * p_Field)
{
	unsigned int x;

	// Get maximum id
	unsigned int maxid = 0;
	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		if(p_Field->vvaluex(x) > maxid) maxid = p_Field->vvaluex(x);
	}	

	vector<unsigned int> Count( maxid+1, 0);
	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		const unsigned int id = p_Field->vvaluex(x);
		if(id == 0) continue;
		Count[id]++;
	}

	for(x=0; x<p_Field->getMaxIndex(); x++)
	{
		const unsigned int id = p_Field->vvaluex(x);
		if(id == 0) continue;
		if(Count[id] < 20) /* THRESHOLD */
		{
			p_Field->wvaluex(x) = 0;
		}
	}

	renumber(p_Field);

	p_Field->getLayer()->onFieldChanged();
}

void TAction_MapSskelSegmUsingFt::perform_main()
{
	unsigned int x;
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

	TTypedFieldInterface<unsigned int> * SskelFg = static_cast<TTypedFieldInterface<unsigned int> *>( g_Mediator.getCurrentLayerSet()->getField("S-skel segmentation (fg)") );
	if(!SskelFg) throw string("!SskelFg");
	cleanup(SskelFg);

	TTypedFieldInterface<unsigned int> * SskelBg = static_cast<TTypedFieldInterface<unsigned int> *>( g_Mediator.getCurrentLayerSet()->getField("S-skel segmentation (bg)") );
	if(!SskelBg) throw string("!SskelBg");
	cleanup(SskelBg);

	TTypedFieldInterface<unsigned int> * MapFtFg = mapFt( SskelFg, skel->m_ForegroundSpSetField.get(), "Mapped FT (fg)");
	TTypedFieldInterface<unsigned int> * MapFtBg = mapFt( SskelBg, skel->m_BackgroundSpSetField.get(), "Mapped FT (bg)");

	*g_Log << "Filling fg\n";
	// Fill fg boundary-segments
	{
		g_Mediator.setCurrentLayer( MapFtFg->getLayer() );
		TAction_FillUsingClusters Fill;
		Fill.perform();
	}
	TTypedFieldInterface<unsigned int> * FilledFg = static_cast<TTypedFieldInterface<unsigned int> *>( g_Mediator.getCurrentLayerSet()->getField( TAction_FillUsingClusters::getStaticName() ) );


	TTypedFieldInterface<unsigned int>* OutputSeeds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "OutputSeeds" ) );

	


	// Detect borders between segments, this is necessary to correctly create forbidden list
	TTypedFieldInterface<unsigned int>* SegmentBorders = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "SegmentBorders" ) );
	{
		SegmentBorders->clear();
		for(x=0; x<FilledFg->getMaxIndex(); x++)
		{
			const TCoord3 p = FilledFg->getIndexField()->vidx2coord(x);
			TCoord3 np;
			for(np.x=p.x-1; np.x<=p.x+1; np.x++) // neighbors
			for(np.y=p.y-1; np.y<=p.y+1; np.y++)
			for(np.z=p.z-1; np.z<=p.z+1; np.z++)
			{
				if(np == p) continue;

				if(!FilledFg->getIndexField()->vinside(np)) continue;
				if(FilledFg->vvaluep(np) != FilledFg->vvaluep(p))
				{
					SegmentBorders->wvaluex(x) = 1;
				}
			}
		}
		SegmentBorders->getLayer()->onFieldChanged();
	}


	*g_Log << "Split fg segments according to bg segments\n";
	
	typedef map<unsigned int, set<unsigned int> > TSplitInto;
	TSplitInto SplitInto;

	
	unsigned int MaxFgId = 0;
	{
		for(x=0; x<MapFtFg->getMaxIndex(); x++)
		{
			if(MapFtFg->vvaluex(x) > MaxFgId) MaxFgId = MapFtFg->vvaluex(x);
		}
	}

	// Now split fg segments accoording to bg segments
	{
		unsigned int FreeId = MaxFgId + 1;
		if(FreeId % 2 == 1) FreeId++;

		// fg seg id -> (bg seg id -> { bg voxels })
		vector< map<unsigned int, set<unsigned int> > > BgSegm(MaxFgId+1);

		for(x=0; x<MapFtBg->getMaxIndex(); x++)
		{
			if( SegmentBorders->vvaluex(x) != 0 ) continue;

			const unsigned int fgsegid = FilledFg->vvaluex(x);
			const unsigned int bgsegid = MapFtBg->vvaluex(x);
			if(bgsegid == 0) continue;
			if( BgSegm[fgsegid].find( bgsegid ) == BgSegm[fgsegid].end() )
			{
				BgSegm[fgsegid].insert( pair<unsigned int, set<unsigned int> >(bgsegid, set<unsigned int>() ) );
			}
			BgSegm[fgsegid][bgsegid].insert( x );
		}

		for(x=1; x<BgSegm.size(); x++)
		{
			if(BgSegm[x].size() >= 2) 
			{
				// Create seeds
				*g_Log << "Splitting " << x << " into " << (unsigned int)BgSegm[x].size() << " segments \n";
				set<unsigned int> Seeds;
				map<unsigned int, set<unsigned int> >::iterator it;

				map<unsigned int, unsigned int> Renumber;
				for(it = BgSegm[x].begin(); it != BgSegm[x].end(); it++)
				{
					const unsigned int id = it->first;
					*g_Log << id << ", ";
					set<unsigned int>::iterator jt;
					for(jt = it->second.begin(); jt != it->second.end(); jt++)
					{
						Seeds.insert( *jt );
					}

					Renumber.insert( pair<unsigned int,unsigned int>( id, FreeId ) );
					SplitInto[x].insert( FreeId );
					FreeId++;
				}
				*g_Log << "\n";


				// Splitting segment x
				FilledFg->getLayer()->m_Filter->m_LowerValue = x - 0.01f;
				FilledFg->getLayer()->m_Filter->m_UpperValue = x + 0.01f;
				OutputSeeds->clear();
				skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomainFilter(&Seeds, FilledFg->getLayer()->m_Filter.get(), 0, 0, OutputSeeds);
				
				for(unsigned int y=0; y<FilledFg->getMaxIndex(); y++)
				{
					if(FilledFg->vvaluex(y) != x) continue;
					
					// Generate new free id
					const unsigned int id = MapFtBg->vvaluex( OutputSeeds->vvaluex(y) );
					FilledFg->wvaluex(y) = Renumber[id];
				}
			}
			else
			{
				SplitInto[x].insert(x);
			}
		}
	}
	OutputSeeds->getLayer()->onFieldChanged();

	// Output split into list
	TSplitInto::iterator it;
	for(it = SplitInto.begin(); it != SplitInto.end(); it++)
	{
		*g_Log << "Segment " << it->first << " is split into: ";
		set<unsigned int>::iterator jt;
		for(jt = it->second.begin(); jt != it->second.end(); jt++)
		{
			*g_Log << *jt << ",";
		}
		*g_Log << "\n";
	}


	// Generate forbidden list
	typedef map<unsigned int, set<unsigned int> > TForbidden;
	TForbidden Forbidden;
	// New
	{
		for(x=0; x<SskelFg->getMaxIndex(); x++)
		{
			if( SskelFg->vvaluex(x) == 0 ) continue;

			const TShortestPathSet * sps = skel->m_ForegroundSpSetField->vvaluex(x);
			if(sps == 0) continue;
			const TIndexedOrigins_Vector & vec = *sps->m_Eft.get();
			if(vec.size() != 2) continue;
			const unsigned int a = vec[0];
			const unsigned int b = vec[1];
			if(a == b) continue;
			if(SegmentBorders->vvaluex(a)) continue;
			if(SegmentBorders->vvaluex(b)) continue;
			Forbidden[ FilledFg->vvaluex(a) ].insert( FilledFg->vvaluex(b) );
			Forbidden[ FilledFg->vvaluex(b) ].insert( FilledFg->vvaluex(a) );
		}

		for(x=0; x<SskelBg->getMaxIndex(); x++)
		{
			if( SskelBg->vvaluex(x) == 0 ) continue;

			const TShortestPathSet * sps = skel->m_BackgroundSpSetField->vvaluex(x);
			if(sps == 0) continue;
			const TIndexedOrigins_Vector & vec = *sps->m_Eft.get();
			if(vec.size() != 2) continue;
			const unsigned int a = vec[0];
			const unsigned int b = vec[1];
			if(a == b) continue;
			if(a >= FilledFg->getMaxIndex()) continue;
			if(b >= FilledFg->getMaxIndex()) continue;
			if(SegmentBorders->vvaluex(a)) continue;
			if(SegmentBorders->vvaluex(b)) continue;
			Forbidden[ FilledFg->vvaluex(a) ].insert( FilledFg->vvaluex(b) );
			Forbidden[ FilledFg->vvaluex(b) ].insert( FilledFg->vvaluex(a) );
		}
	}

	/*
	{ // old
		for(x=2; x<=MaxFgId; x++)
		{
			// Set bg-forbidden segment, only applicable if fg segment is split 
			set<unsigned int>::iterator it,jt;
			for(it = SplitInto[x].begin(); it != SplitInto[x].end(); it++)
			for(jt = SplitInto[x].begin(); jt != SplitInto[x].end(); jt++)
			{
				const unsigned int a = *it;
				const unsigned int b = *jt;
				if(a == b) continue;
				if(a % 2 == 1) continue;
				
				Forbidden[a].insert(b);
				Forbidden[b].insert(a);
			}

			// Set fg-forbidden segment, taking the splits into account
			unsigned int y = x%2 == 0 ? x+1 : x-1;

			for(it = SplitInto[x].begin(); it != SplitInto[x].end(); it++)
			for(jt = SplitInto[y].begin(); jt != SplitInto[y].end(); jt++)
			{
				Forbidden[*it].insert( *jt );
			}
		}
	}
	*/

	{
		*g_Log << "\n";
		TForbidden::iterator it;
		for(it = Forbidden.begin(); it != Forbidden.end(); it++)
		{
			*g_Log << "Segment " << it->first << " cannot merge with ";
			set<unsigned int>::iterator jt;
			for(jt = it->second.begin(); jt != it->second.end(); jt++)
			{
				*g_Log << *jt << ",";
			}
			*g_Log << "\n";
		}
	}

	if(true)
	{
		TAction_MergeClusters Merge;
		Merge.m_Forbidden = &Forbidden;
		Merge.perform();
	
		TTypedFieldInterface<unsigned int>* Merged = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_MergeClusters::getStaticName() ) );
		if(!Merged) throw string("!Merged");
//	renumber(Merged);
	}


	FilledFg->getLayer()->onFieldChanged();

	/*
	TTypedFieldInterface<unsigned int> * MapFtFg = mapFt( g_Mediator.getSskelSegmenter().get(), "Mapped FT (fg)");
	if(g_Mediator.getBgSskelSegmenter().get()) mapFt( g_Mediator.getBgSskelSegmenter().get(), "Mapped FT (bg)");
	
	{
		g_Mediator.setCurrentLayer( MapFtFg->getLayer() );
		TAction_FillUsingClusters Fill;
		Fill.perform();
	}


	*/
}


// ------------------------------------------------------------------------------------------


bool TAction_MapSskelSegmUsingFtAndGeodesics::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();
	return segm != 0;
}


void TAction_MapSskelSegmUsingFtAndGeodesics::perform_main()
{
	unsigned int x,y,z;
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters" ) );
	Output->clear();


	segm->m_SskelGraph.unifyLocalSheetNormals();
	segm->m_SskelGraph.computeSegmentStats();

	for(x=1; x<segm->m_SskelGraph.m_Segments.size(); x++)
	{
		TNodeComponent & s = segm->m_SskelGraph.m_Segments[x];
		for(y=0; y<s.m_Nodes.size(); y++)
		{
			TNode * N = s.m_Nodes[y];
			for(z=0; z<N->m_Neighbors.size(); z++)
			{
				TNode * NN = &segm->m_SskelGraph.m_Nodes[N->m_Neighbors[z]];
				if(N->m_SegmentId == NN->m_SegmentId)
				{
					unsigned int segid1 = N->m_SegmentId * 2 + 0;
					unsigned int segid2 = N->m_SegmentId * 2 + 1;

					unsigned int p1 = N->m_ShortestPath->m_Begin;
					unsigned int p2 = N->m_ShortestPath->m_End;
					{
						TVector3 vfp1 = Output->getIndexField()->vidx2coord(p1).toVector();
						vfp1.subtract( N->m_Coord.toVector());
						vfp1.normalize();
						if( N->m_ShortestPath->m_LocalSheet->getNormal().dot( vfp1  ) < 0.0f)
						{
							swap(p1,p2);
						}
					}

					unsigned int np1 = NN->m_ShortestPath->m_Begin;
					unsigned int np2 = NN->m_ShortestPath->m_End;
					{
						TVector3 vfp1 = Output->getIndexField()->vidx2coord(np1).toVector();
						vfp1.subtract( NN->m_Coord.toVector());
						vfp1.normalize();
						if( NN->m_ShortestPath->m_LocalSheet->getNormal().dot( vfp1  ) < 0.0f)
						{
							swap(np1,np2);
						}
					}

					{
						shared_ptr<TIndexedOrigins_Vector> v = skel->Omega->m_DeltaOmega->getShortestPath(p1, np1)->m_Path;
						TIndexedOrigins_Vector::iterator it;
						for(it = v->begin(); it != v->end(); it++) Output->wvaluex(*it) = segid1;
					}
					{
						shared_ptr<TIndexedOrigins_Vector> v = skel->Omega->m_DeltaOmega->getShortestPath(p2, np2)->m_Path;
						TIndexedOrigins_Vector::iterator it;
						for(it = v->begin(); it != v->end(); it++) Output->wvaluex(*it) = segid2;
					}
				}
			}
		}
	}
	Output->getLayer()->onFieldChanged();

/*
	TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters" ) );
	Output->clear();
	for(x=0; x<NodeField->getMaxIndex(); x++)
	{
		vector<TNode*>* Nodes = NodeField->vvaluex(x);
		TCoord3 p = NodeField->getIndexField()->vidx2coord(x);
		if(Nodes == 0) continue;
		for(y=0; y<Nodes->size(); y++)
		{
			TNode * N = (*Nodes)[y];
			if(N->m_SegmentId == 0) continue;

			unsigned int segid1 = N->m_SegmentId * 2 + 0;
			unsigned int segid2 = N->m_SegmentId * 2 + 1;
			unsigned int fp1 = N->m_ShortestPath->m_Begin;
			unsigned int fp2 = N->m_ShortestPath->m_End;
			{
				TVector3 vfp1 = Output->getIndexField()->vidx2coord(fp1).toVector();
				vfp1.subtract(p.toVector());
				vfp1.normalize();
				if( N->m_ShortestPath->m_LocalSheet->getNormal().dot( vfp1  ) < 0.0f)
				{
					swap(fp1,fp2);
				}
			}
			
			if(Output->vvaluex(fp1) != 0 && Output->vvaluex(fp1) != segid1) Output->wvaluex(fp1) = (numeric_limits<unsigned int>::max)();
			if(Output->vvaluex(fp1) != (numeric_limits<unsigned int>::max)())
			{
				Output->wvaluex(fp1) = segid1;
			}
			
			if(Output->vvaluex(fp2) != 0 && Output->vvaluex(fp2) != segid2) Output->wvaluex(fp2) = (numeric_limits<unsigned int>::max)();
			if(Output->vvaluex(fp2) != (numeric_limits<unsigned int>::max)())
			{
				Output->wvaluex(fp2) = segid2;
			}
		}
	}

	// Remove numeric_limits<unsigned int>::max
	for(x=0; x<Output->getMaxIndex(); x++)
	{
		if(Output->vvaluex(x) == (numeric_limits<unsigned int>::max)())
			Output->wvaluex(x) = 0;
	}
*/
	
	Output->getLayer()->onFieldChanged();
}


// ------------------------------------------------------------------------------------------


bool TAction_DistanceToField::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return g_Mediator.getCurrentLayer().get() != 0 && g_Mediator.getCurrentLayer()->m_Field->getType() == TType::TYPE_SHORTESTPATHSET;
//	return true;
}

TTypedFieldInterface<float>* TAction_DistanceToField::computeField(TTypedFieldInterface<TShortestPathSet*> * SPSF, const TFloatFilter * Filter, string p_Name, TTypedFieldInterface<unsigned int>* p_ClosestPoint)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
//	TTypedFieldInterface<TShortestPathSet*> * SPSF = static_cast<TTypedFieldInterface<TShortestPathSet*>*>( g_Mediator.getCurrentLayer()->m_Field.get() );

//	const TFilter * Filter = SPSF->getLayer()->m_Filter.get();
	unsigned int x,y;
	TTypedFieldInterface<unsigned int>* Output1 = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Seeds " + p_Name) );
	Output1->clear();

	// Original
	for(x=0; x<SPSF->getMaxIndex(); x++)
	{
		TShortestPathSet * s = SPSF->vvaluex(x);
		if(!Filter->test(s->getMaxLength())) continue;

		if(s->m_Paths.size() != 1) continue;
		for(y=0; y<s->m_Paths.size(); y++)
		{
			if(!Filter->test(s->m_Paths[y]->m_Length)) continue;

			const unsigned int begin = s->m_Paths[y]->m_Begin;
			const unsigned int end = s->m_Paths[y]->m_End;
			if(begin < skel->m_BoundaryIndexField->getMaxIndex()) Output1->wvaluex(begin) = 1;
			if(end < skel->m_BoundaryIndexField->getMaxIndex()) Output1->wvaluex(end) = 1;
		}
	}	
	Output1->getLayer()->onFieldChanged();

	TTypedFieldInterface<float>* Output = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to seeds " + p_Name ) );
	Output->clear();
	skel->Omega->m_DeltaOmega->computeDistancesToNonZeros(Output1, Output, p_ClosestPoint);
	Output->getLayer()->onFieldChanged();
	return Output;
}

void TAction_DistanceToField::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

//	TTypedFieldInterface<unsigned int>* Input = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayer()->m_Field.get() );

	if(g_Mediator.getCurrentLayer()->m_Field->getType() != TType::TYPE_SHORTESTPATHSET) throw string("Current layer is not a sp set layer");

	static double ThresholdLow = 10.0f;
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("Low threshold", "Low threshold", wxString::Format("%f",ThresholdLow).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&ThresholdLow) );
		}
	}

	static double ThresholdHigh = 20.0f;
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("High threshold", "High threshold", wxString::Format("%f",ThresholdHigh).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&ThresholdHigh) );
		}
	}

	//string Name = m_UseNameForOutput == "" ? wxString::Format("Distance to seeds", ThresholdHigh ).c_str() : m_UseNameForOutput;
	string Name = m_UseNameForOutput == "" ? wxString::Format("Distance to seeds", ThresholdHigh ).ToStdString() : m_UseNameForOutput;
//	m_Output = computeField(ThresholdLow, ThresholdHigh, Name);	
}




// ------------------------------------------------------------------------------------------


bool TAction_NotUsingSskelSegmentation::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}

unsigned int TAction_NotUsingSskelSegmentation::cluster(TTypedFieldInterface<unsigned int>* p_Clusters, bool p_HandleConcavities, bool p_StoreClustering)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();


	if(!g_Mediator.getCurrentLayerSet()->exists( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() ))
	{
		TAction_BoundaryNormalUsingForwardEftAndShortestPaths Action;
		Action.perform();
	}

	TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_SpSetField.get();

	vector<unsigned int> NewIds( p_Clusters->getMaxIndex(), 0 );
	vector<bool> Visited( p_Clusters->getMaxIndex(), false );

	unsigned int x,y;
	// Cluster p_Clusters
	unsigned int ClusterCount = 0;
	{
		queue<unsigned int> S;
		for(x=0; x<p_Clusters->getMaxIndex(); x++)
		{
			if( p_Clusters->vvaluex(x) != 0 && NewIds[x] == 0 )
			{
				ClusterCount++;

				S.push(x);
				while(!S.empty())
				{
					unsigned int idx = S.front();
					S.pop();
					NewIds[idx] = ClusterCount;
					if(Visited[idx]) continue;
					Visited[idx] = true;
				

					vector<unsigned int> result;
					result.clear();
					skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(idx, p_Clusters, m_ThresholdCluster, &result);
					for(y=0; y<result.size(); y++)
					{
						const unsigned int nidx = result[y];
						if(!Visited[nidx] && p_Clusters->vvaluex(nidx) == p_Clusters->vvaluex(idx))
						{
							S.push(nidx);
							//NewIds[nidx] = ClusterCount;
							//Visited[nidx] = true;
						}
					}
				}
			}
		}
		p_Clusters->getLayer()->onFieldChanged();
	}

	// Assign new ids
	{
		for(x=0; x<NewIds.size(); x++) p_Clusters->wvaluex(x) = NewIds[x];
	}

	// Store first clustering
	if(p_StoreClustering)
	{
		TTypedFieldInterface<unsigned int>* FirstClustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() + " first clustering before concave split") );
		FirstClustering->clear();
		for(x=0; x<p_Clusters->getMaxIndex(); x++) FirstClustering->wvaluex(x) = p_Clusters->vvaluex(x);
		FirstClustering->getLayer()->onFieldChanged();
	}

	if(p_HandleConcavities)
	{
		// For all involute voxels that are in same segment, assign to them a new segment id
		ClusterCount++;

		for(x=0; x<SPSF->getMaxIndex(); x++)
		{
			TShortestPathSet * s = SPSF->vvaluex(x);
			TShortestPathSet::TPaths & Paths = s->m_Paths;

			if(s->m_Paths.size() != 1) continue;

			for(y=0; y<Paths.size(); y++)
			{
				if(Paths[y]->m_Length < m_Threshold) continue;

				unsigned int idx1 = Paths[y]->m_Begin;
				unsigned int idx2 = Paths[y]->m_End;

				if(p_Clusters->vvaluex(idx1) == p_Clusters->vvaluex(idx2))
				{	
					NewIds[idx1] = ClusterCount;
					NewIds[idx2] = ClusterCount;
				}
			}
		}

		// Assign new ids
		{
			for(x=0; x<NewIds.size(); x++) p_Clusters->wvaluex(x) = NewIds[x];
		}
	}

	p_Clusters->getLayer()->onFieldChanged();

	// Store first clustering
	if(p_StoreClustering)
	{
		TTypedFieldInterface<unsigned int>* FirstClustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() + " first clustering after concave split") );
		FirstClustering->clear();
		for(x=0; x<p_Clusters->getMaxIndex(); x++) FirstClustering->wvaluex(x) = p_Clusters->vvaluex(x);
		FirstClustering->getLayer()->onFieldChanged();
	}


	return ClusterCount;	
}


void TAction_NotUsingSskelSegmentation::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_SpSetField.get();

	{
		static double Threshold = 10.0f;
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("Threshold", "Threshold", wxString::Format("%f",Threshold).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&Threshold) );
			m_Threshold = Threshold;
		}
	}
	
	{
		static double ThresholdCluster = 6.0f;
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("ThresholdCluster", "ThresholdCluster", wxString::Format("%f",ThresholdCluster).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&ThresholdCluster) );
			m_ThresholdCluster = ThresholdCluster;
		}
	}
	
	{
		static double ThresholdNeighbors = 1.0000f;
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("ThresholdNeighbors", "ThresholdNeighbors", wxString::Format("%f",ThresholdNeighbors).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&ThresholdNeighbors) );
			m_ThresholdNeighbors = ThresholdNeighbors;
		}
	}

	bool HandleConcavities=false;
	/*
	{
		long Option = 0;
		{
			wxString Choices[] = { "0. no", "1. yes" };
			wxString Result = ::wxGetSingleChoice("Handle concavities", "Handle concavities", 2, Choices );
			if(Result == "") return;
			Result.Left(1).ToLong(&Option);
			HandleConcavities = Option == 1;
		}
	}
	*/

	const TFilter * Filter = g_Mediator.getCurrentLayer() ? g_Mediator.getCurrentLayer()->m_Filter.get() : 0;

	// Get boundary normals
	unsigned int x,y;
	TTypedFieldInterface<TIndexedOrigins*>* InverseFT = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->m_ForegroundSskelIndexField, getName() + " io") );
	InverseFT->getLayer()->m_RenderLines = true;
	InverseFT->getLayer()->m_AllVoxels->setCheckedForRendering(false); 
	InverseFT->clear();
	TTypedFieldInterface<unsigned int>* Clusters = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters") );
	Clusters->clear();
	{
		for(x=0; x<SPSF->getMaxIndex(); x++)
		{
			TShortestPathSet * s = SPSF->vvaluex(x);
			TShortestPathSet::TPaths & Paths = s->m_Paths;
			if(!Filter || !Filter->test(s->m_SourceVoxel)) continue;

			if(s->m_Paths.size() != 1) continue;

			/*
			// If not all paths longer than threshold: discard
			// Doesn't work in case of Bunny for example
			bool skip = false;
			for(y=0; y<Paths.size(); y++)
			{
				if(Paths[y]->m_Length < Threshold) skip = true;
			}
			if(skip) continue;
			*/

			for(y=0; y<Paths.size(); y++)
			{
				if(Paths[y]->m_Length < m_Threshold) continue;

				unsigned int idx1 = Paths[y]->m_Begin;
				unsigned int idx2 = Paths[y]->m_End;
				vector<unsigned int> idx1neighbors;
				vector<unsigned int> idx2neighbors;
				skel->Omega->m_DeltaOmega->getEquidistantNeighbors(idx1, s->m_SourceVoxel, m_ThresholdNeighbors, &idx1neighbors);
				skel->Omega->m_DeltaOmega->getEquidistantNeighbors(idx2, s->m_SourceVoxel, m_ThresholdNeighbors, &idx2neighbors);

				unsigned int z;
				for(z=0; z<idx1neighbors.size(); z++) Clusters->wvaluex(idx1neighbors[z]) = 1;
				for(z=0; z<idx2neighbors.size(); z++) Clusters->wvaluex(idx2neighbors[z]) = 1;
				
				
				if(! InverseFT->wvaluex(Paths[y]->m_Begin)) InverseFT->wvaluex(Paths[y]->m_Begin) = new TIndexedOrigins_Vector();
				InverseFT->wvaluex(Paths[y]->m_Begin)->castVector()->push_back(x);
				
				if(! InverseFT->wvaluex(Paths[y]->m_End)) InverseFT->wvaluex(Paths[y]->m_End) = new TIndexedOrigins_Vector();
				InverseFT->wvaluex(Paths[y]->m_End)->castVector()->push_back(x);
			}
		}	
		Clusters->getLayer()->onFieldChanged();
		InverseFT->getLayer()->onFieldChanged();
	}

	

	// Cluster 
	int ClusterCount = -1;
	{
		int OldClusterCount = 0;
		
		while(OldClusterCount != ClusterCount)
		{
			OldClusterCount = ClusterCount;
			ClusterCount = cluster(Clusters, HandleConcavities, OldClusterCount == -1);
			
			if(!HandleConcavities) break;
		} 
		Clusters->getLayer()->onFieldChanged();
	}


/*
	TTypedFieldInterface<unsigned int>* Clusters = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() + " clusters") );
	Clusters->clear();
	
	// Now cluster seeds point into segments
	vector<unsigned int> ClusterSize;
	{
		ClusterSize.push_back(0);
		queue<unsigned int> S;
		for(x=0; x<Seeds->getMaxIndex(); x++)
		{
			if( Seeds->vvaluex(x) != 0)
			{
				ClusterSize.push_back(0);

				S.push(x);
				while(!S.empty())
				{
					unsigned int idx = S.front();
					S.pop();
					Clusters->wvaluex(idx) = ClusterSize.size()-1;
					ClusterSize.back()++;

					vector<unsigned int> result;
					result.clear();
					skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(idx, Seeds, ThresholdCluster, &result);
					for(y=0; y<result.size(); y++)
					{
						unsigned int nidx = result[y];
	
						// Add neighbor to queue and remove from seeds 
						S.push(nidx);
						Seeds->wvaluex(nidx) = 0;
					}
					Seeds->wvaluex(idx) = 0;
				}
			}
		}
		Clusters->getLayer()->onFieldChanged();
	}
*/



	// Determine cluster sizes
	vector<unsigned int> ClusterSize(ClusterCount, 0);
	if(ClusterCount > 0)
	{
		for(x=0; x<Clusters->getMaxIndex(); x++)
		{
			ClusterSize[ Clusters->vvaluex(x) ]++;
		}

		// Discard small clusters
		if(true)
		{
			const int SmallClusterThreshold = 5;
			*g_Log << "Discarding small clusters, threshold = " << SmallClusterThreshold << "\n";
			for(x=0; x<Clusters->getMaxIndex(); x++)
			{
				if( ClusterSize[Clusters->vvaluex(x)] < SmallClusterThreshold )
				{
					Clusters->wvaluex(x) = 0;
				}
			}
			for(x=1; x<ClusterSize.size(); x++)
			{
				if( ClusterSize[x] < SmallClusterThreshold )
					ClusterSize[x] = 0;
			}
			Clusters->getLayer()->onFieldChanged();
		}
	}

}



// ------------------------------------------------------------------------------------------


bool TAction_MergeClusters::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return g_Mediator.getCurrentLayerSet()->exists( TAction_FillUsingClusters::getStaticName() );
}


void TAction_MergeClusters::computeClusterStats(const TTypedFieldInterface<unsigned int>* Clusters, const TTypedFieldInterface<TVector3>* BoundaryNormals)
{
	bool Output = false;

	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();
	const TDeltaOmega & DO = *skel->Omega->m_DeltaOmega.get();

	unsigned int x,y;
	unsigned int maxid = 0;
	for(x=0; x<Clusters->getMaxIndex(); x++)
	{
		if(Clusters->vvaluex(x) > maxid ) maxid = Clusters->vvaluex(x);
	}

	for(x=0; x<=maxid; x++)
	{
		m_Segments.push_back( shared_ptr<TTSegment>(new TTSegment(x)) );
	}


	typedef map<unsigned int, set<unsigned int> > TNeighbors;
	vector<TNeighbors> m_Neighboring;
	m_Neighboring.resize( m_Segments.size() );
	
	// Create segments and determine neighborhood relations
	for(y=0; y<m_Segments.size(); y++)
	{
		unsigned int cidx = y;
		for(x=0; x<Clusters->getMaxIndex(); x++)
		{	
			const unsigned int idx = x;
			if( Clusters->vvaluex(idx) == y )
			{
				m_Segments[y]->m_Voxels.push_back(idx);

				const TDeltaOmega::TAdjacencyStruct & padj = DO.m_AdjacencyList[idx];
				for(unsigned int n=0; n<padj.m_EdgeCount; n++)
				{
					const unsigned int nidx = padj.m_Edges[n].m_ToVertex;
					const unsigned int cnidx = Clusters->vvaluex(nidx);
					if(cnidx == Clusters->vvaluex(idx)) continue;

					if( m_Neighboring[cidx].find(cnidx) == m_Neighboring[cidx].end() ) m_Neighboring[cidx].insert( TNeighbors::value_type(cnidx,set<unsigned int>() ) );
					m_Neighboring[cidx][ cnidx ].insert( nidx );
				}
			}
		}
	}

	if(!m_Forbidden) throw string("!m_Forbidden");

	// Assign m_Segments.m_Neighboring
	TNeighbors::iterator it;
	for(y=0; y<m_Segments.size(); y++)
	{
		TTSegment & s = *m_Segments[y].get();
		for(it = m_Neighboring[s.m_Index].begin(); it != m_Neighboring[s.m_Index].end(); it++)
		{
			TTSegment & t = *m_Segments[ it->first ].get();

			if(s.m_Index == t.m_Index) continue;
			if( (*m_Forbidden)[s.m_Index].find(t.m_Index) != (*m_Forbidden)[s.m_Index].end() ) continue;
			if( (*m_Forbidden)[t.m_Index].find(s.m_Index) != (*m_Forbidden)[t.m_Index].end() ) continue;

			s.m_Neighbors.insert( TTSegment::TNeighbors::value_type(&t, (unsigned int)it->second.size() ) );
		}
	}

	// Print segment neighborhoods
	if(Output) 
	{
		for(y=0; y<m_Segments.size(); y++)
		{
			TTSegment & s = *m_Segments[y].get();
			*g_Log << "Segment " << s.m_Index << " has neighbors: ";
			TTSegment::TNeighbors::iterator it;
			for(it = s.m_Neighbors.begin(); it != s.m_Neighbors.end(); it++)
			{
				*g_Log << (*it).first->m_Index << "(" << (*it).second << "), ";
			}
			*g_Log << "\n";
		}
	}

	// Create cluster for each segment
	for(y=0; y<m_Segments.size(); y++)
	{
		m_Clusters.push_back( shared_ptr<TTCluster>( new TTCluster(m_Segments[y]->m_Index, m_Segments[y].get()) ) );
	}

	for(y=0; y<m_Clusters.size(); y++)
	{
		updateClusterNeighbors( m_Clusters[y].get() );
	}

	if(Output) printClusterInfo();

}


void TAction_MergeClusters::printClusterInfo()
{
	// Print cluster neighborhoods
	for(unsigned int y=0; y<m_Clusters.size(); y++)
	{
		TTCluster & s = *m_Clusters[y].get();
		*g_Log << "Cluster " << s.m_Index << " consists of segments: ";
		set<TTSegment*>::iterator jt;
		for(jt = s.m_Segments.begin(); jt != s.m_Segments.end(); jt++)
		{
			*g_Log << (*jt)->m_Index << ", ";
		}
		*g_Log << " and has neighbors: ";
		TTCluster::TNeighbors::iterator it;
		for(it = s.m_Neighbors.begin(); it != s.m_Neighbors.end(); it++)
		{
			*g_Log << (*it).first->m_Index << "(" << (*it).second << "), ";
		}
		*g_Log << "\n";
	}
}

bool TAction_MergeClusters::canBeMerged(TTCluster * c, TTCluster * d)
{
	set<unsigned int> sc,sd; 

	for(set<TTSegment*>::iterator it=c->m_Segments.begin(); it!=c->m_Segments.end(); it++) 
	for(set<TTSegment*>::iterator jt=d->m_Segments.begin(); jt!=d->m_Segments.end(); jt++) 
	{
		if( (*m_Forbidden)[(*it)->m_Index].find((*jt)->m_Index) != (*m_Forbidden)[(*it)->m_Index].end() ) return false;
		if( (*m_Forbidden)[(*jt)->m_Index].find((*it)->m_Index) != (*m_Forbidden)[(*jt)->m_Index].end() ) return false;
	}
	return true;

	/*
	{
		for(set<TTSegment*>::iterator it=c->m_Segments.begin(); it!=c->m_Segments.end(); it++) sc.insert( (*it)->m_Index );
		for(set<TTSegment*>::iterator jt=d->m_Segments.begin(); jt!=d->m_Segments.end(); jt++) sd.insert( (*jt)->m_Index );
	}

	set<unsigned int>::iterator it,jt;
	for(it=sc.begin(); it!=sc.end(); it++)
	{

		const unsigned int a = *it;
		unsigned int b = a % 2 == 0 ? a + 1 : a - 1;
		if( sd.find(b) != sd.end() )
		{
			return false;
		}
	}
	*/
	return true;
}

void TAction_MergeClusters::updateClusterNeighbors(TTCluster * c)
{
	c->m_Neighbors.clear();
	set<TTSegment*>::iterator it;
	for(it = c->m_Segments.begin(); it != c->m_Segments.end(); it++)
	{
		TTSegment * s = *it;
		TTSegment::TNeighbors::iterator jt;
		for(jt = s->m_Neighbors.begin(); jt != s->m_Neighbors.end(); jt++)
		{
			TTSegment * ns = (*jt).first;

			if(ns->m_Cluster == 0) throw string("ns->m_Cluster == 0");
			
			if(c->m_Neighbors.find(ns->m_Cluster) == c->m_Neighbors.end()) c->m_Neighbors.insert( TTCluster::TNeighbors::value_type(ns->m_Cluster,0) );
			c->m_Neighbors[ns->m_Cluster] += (*jt).second;
		}
	}
}


void TAction_MergeClusters::perform_main()
{
	unsigned int x;
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	// Get clusters	
	TTypedFieldInterface<unsigned int>* Clusters = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_FillUsingClusters::getStaticName() ) );
	if(!Clusters) throw string("!Clusters");


	// Get boundary normals
//	const TTypedFieldInterface<TVector3>* BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() ) );
//	if(!BoundaryNormals) throw string("!BoundaryNormals");

	*g_Log << "Compute cluster stats\n";	
	computeClusterStats(Clusters,0);

	// Merging
	unsigned int mergecount = 0;
	*g_Log << "Clusters: " << (unsigned int)m_Clusters.size() << "\n";
	while(true)
	{
		TTCluster * max1 = 0;
		TTCluster * max2 = 0;
		unsigned int maxbordersize = 0;

		// Find cluster pair with maximum border size
		for(x=1; x<m_Clusters.size(); x++)
		{
			TTCluster & s = *m_Clusters[x].get();
			if(s.m_Segments.size() == 0) continue;

			TTCluster::TNeighbors::iterator it;
			for(it = s.m_Neighbors.begin(); it != s.m_Neighbors.end(); it++)
			{
				TTCluster & t = * (*it).first;
				if(t.m_Segments.size() == 0) continue;
				if(!canBeMerged(&s, &t)) continue;

				if(t.m_Index == 0 || s.m_Index == 0) continue;
				if(t.m_Index == s.m_Index) continue;

				if( (*it).second > maxbordersize )
				{
					max1 = &s;
					max2 = &t;
					maxbordersize = (*it).second;
				}
			}
		}

		if(max1 == 0 || max2 == 0) 
		{
			*g_Log << "No mergeable clusters found.\n";
			*g_Log << "-----------------------------------------\n";
			break;
		}


		// Merge
		//*g_Log << "Merge #" << mergecount << ": " << max1->m_Index << "(#segments:"<<max1->m_Segments.size() << ") and " << max2->m_Index << "(#segments:"<<max1->m_Segments.size() << "), bordersize: " << maxbordersize << "\n";
		*g_Log << "Merge #" << mergecount << ": " << max1->m_Index << " and " << max2->m_Index << ", bordersize: " << maxbordersize << "\n";

		// Print segments in cluster1 
		{
			set<TTSegment*>::iterator it;
			*g_Log << "Segments in cluster1: ";
			for(it = max1->m_Segments.begin(); it != max1->m_Segments.end(); it++)
			{
				*g_Log << (*it)->m_Index << ",";
			}
			*g_Log << "\n";

			*g_Log << "Segments in cluster2: ";
			for(it = max2->m_Segments.begin(); it != max2->m_Segments.end(); it++)
			{
				*g_Log << (*it)->m_Index << ",";
			}
			*g_Log << "\n";
		}

		{
			set<TTSegment*>::iterator it;
			for(it = max1->m_Segments.begin(); it != max1->m_Segments.end(); it++)
			{
				max2->m_Segments.insert( *it );
			}
		}

		max1->m_Segments.clear();
		max1->m_Neighbors.clear();


		for(unsigned int y=0; y<m_Clusters.size(); y++)
		{
			updateClusterNeighbors( m_Clusters[y].get() );
		}

		// Intermediate output	
		if(false)
		{
			TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getName() + wxString::Format("%i",mergecount).ToStdString() ) );
			Output->clear();
			{
				unsigned int NewIndex = 1;
				for(x=1; x<m_Clusters.size(); x++)
				{
					TTCluster & s = *m_Clusters[x].get();
					//*g_Log << "Cluster " << s.m_Index << " consists of " << s.m_Segments.size() << " segments.\n";
					
					for(set<TTSegment*>::iterator jt = s.m_Segments.begin(); jt != s.m_Segments.end(); jt++)
					{
						for(unsigned int x=0; x<(*jt)->m_Voxels.size(); x++)
						{	
							//Output->wvaluex(*it) = NewIndex;
							Output->wvaluex( (*jt)->m_Voxels[x] ) = s.m_Index;
						}
						NewIndex++;
					}
				}
			}	
			Output->getLayer()->onFieldChanged();
		}
				
		mergecount++;
	}


	// Final output
	{
		TTypedFieldInterface<unsigned int>* Output = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, getStaticName()  ) );
		Output->clear();
		{
			unsigned int NewIndex = 1;
			for(x=1; x<m_Clusters.size(); x++)
			{
				TTCluster & s = *m_Clusters[x].get();
				//*g_Log << "Cluster " << s.m_Index << " consists of " << s.m_Segments.size() << " segments.\n";
				
				for(set<TTSegment*>::iterator jt = s.m_Segments.begin(); jt != s.m_Segments.end(); jt++)
				{
					for(unsigned int x=0; x<(*jt)->m_Voxels.size(); x++)
					{	
						//Output->wvaluex(*it) = NewIndex;
						Output->wvaluex( (*jt)->m_Voxels[x] ) = s.m_Index;
					}
					NewIndex++;
				}
			}
		}	
		Output->getLayer()->onFieldChanged();
	}


	printClusterInfo();
}


// ------------------------------------------------------------------------------------------


bool TAction_NotUsingSskelSegmentation3::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}

void TAction_NotUsingSskelSegmentation3::cleanUp(TTypedFieldInterface<unsigned int> * Clustering, const TTypedFieldInterface<TVector3> * BoundaryNormals, bool p_Output)
{
	const bool Output = p_Output;

	vector< set<unsigned int> > Clusters;
	unsigned int x;
	for(x=0; x<Clustering->getMaxIndex(); x++)
	{
		unsigned int cid = Clustering->vvaluex(x);
		if( cid == 0 ) continue;
		if( cid >= Clusters.size() ) Clusters.resize( cid + 1 );
		Clusters[cid].insert(x);
	}
	if(Output) *g_Log << "--- Cleaning up clustering, #clusters: " << (unsigned int)Clusters.size() << " \n";
		
	// Compute average cluster size
	float avgclustersize = 0.0f;
	{
		for(x=0; x<Clusters.size(); x++)
		{
			avgclustersize += Clusters[x].size();
		}
		avgclustersize /= (float)(Clusters.size()-1);
	}
	if(Output) *g_Log << "Avg. cluster size = " << avgclustersize << "\n";
		
	// Remove small clusters 
	for(x=0; x<Clusters.size(); x++)
	{
		if(Clusters[x].size() < avgclustersize * 0.1 )
		{
			if(Output) *g_Log << "Removing cluster " << x << ": size = " << (unsigned int)Clusters[x].size() << "\n";
			set<unsigned int>::iterator it;
			for(it = Clusters[x].begin(); it != Clusters[x].end(); it++)
			{
				Clustering->wvaluex(*it) = 0;
			}
		}
	}

	for(x=1; x<Clusters.size(); x++)
	{
		if(Clusters[x].size() == 0) continue;

		unsigned int clusterid = x;
		TVector3 avgnormal(0,0,0);
		unsigned int Count = 0;
		set<unsigned int>::iterator it;

		for(it = Clusters[x].begin(); it != Clusters[x].end(); it++)
		{
			avgnormal.add( BoundaryNormals->vvaluex(*it) );
			Count++;
		}
		avgnormal.normalize();

		// Compute standard deviation
		float stdev = 0.0f;
		{
			for(it = Clusters[x].begin(); it != Clusters[x].end(); it++)
			{
				stdev += (1.0f - avgnormal.dot(BoundaryNormals->vvaluex(*it))) * (1.0f - avgnormal.dot(BoundaryNormals->vvaluex(*it)));
			}
			stdev /= (float) Count;
			stdev = sqrtf(stdev);
			if(Output) *g_Log << "* Cluster " << clusterid << ", size: " << (unsigned int)Clusters[x].size() << ", normal: " << wxString::Format("(%.2f, %.2f, %.2f)", avgnormal.x, avgnormal.y, avgnormal.z).c_str() << ", ";
			if(Output) *g_Log << "stddev: " << stdev << "\n";
		}
		
		if(stdev < 0.2f) // Only if this is not a round segment
		{
			if(Output) *g_Log << "Cleaning up voxels with strange normals: ";
			unsigned int Removed = 0;
			for(it = Clusters[x].begin(); it != Clusters[x].end(); it++)
			{
				if( BoundaryNormals->vvaluex(*it).dot( avgnormal ) < 0.8f )
				{
					Clustering->wvaluex(*it) = 0;
					Clusters[x].erase(it);
					Removed++;
				}
			}
			if(Output) *g_Log << Removed << " removed.\n";
		}
	}

	Clustering->getLayer()->onFieldChanged();
}

TTypedFieldInterface<float>* TAction_NotUsingSskelSegmentation3::computeDistanceField(string p_Name, set<unsigned int> * p_Seeds, TTypedFieldInterface<unsigned int> * p_Domain, unsigned int p_DomainIdx)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TTypedFieldInterface<float>* Output = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to seeds " + p_Name ) );
	Output->clear();
	set<unsigned int>::iterator it;
	for(it = p_Seeds->begin(); it != p_Seeds->end(); it++)
	{
		Output->wvaluex( *it ) = 0.0001f;		
	}
	skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomain(Output, p_Domain, p_DomainIdx);
	Output->getLayer()->onFieldChanged();
	return Output;
}



void TAction_NotUsingSskelSegmentation3::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	//double FgThreshold = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue / 2.5f;
	double FgThreshold  = max( (skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue - 5.0f) / 2.0f, 4.0f );
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("FG Threshold", "FG Threshold", wxString::Format("%f",FgThreshold).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&FgThreshold) );
		}
	}

	//double BgThreshold = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue / 2.5f;
//	double BgThreshold = 4.0f;
	
	double BgThreshold = 0.0f;
	if(skel->m_BackgroundSurfaceSkeletonField)
	{
		BgThreshold  = max( (skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue - 5.0f) / 2.0f, 4.0f );
		{
			{
				wxString s = "";
				do
				{
					s = ::wxGetTextFromUser("BG Threshold", "BG Threshold", wxString::Format("%f",BgThreshold).c_str() );
					if(s == "") return;
				} 
				while( !s.ToDouble(&BgThreshold) );
			}
		}
	}
	const unsigned int SMALLEDGESIZE = 20;

	
	static long DiscardSparseSeeds = 0;
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("Discard sparse seeds", "Discard sparse seeds", wxString::Format("%i",(int)DiscardSparseSeeds).c_str() );
				if(s == "") return;
			} 
			while( !s.ToLong(&DiscardSparseSeeds) );
		}
	}


	// Get boundarynormals
	if(!g_Mediator.getCurrentLayerSet()->exists( TAction_ComputeNormalsClamped::getStaticName() ))
	{
		TAction_ComputeNormalsClamped Action;
		Action.perform();
	}
	BoundaryNormals = static_cast<TTypedFieldInterface<TVector3>*>( g_Mediator.getCurrentLayerSet()->getField( TAction_BoundaryNormalUsingForwardEftAndShortestPaths::getStaticName() )  );
	if(!BoundaryNormals) throw string("BoundaryNormals not available");

	TTypedFieldInterface<unsigned int>* Temporary = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Temporary uint field") );
	TTypedFieldInterface<float>* TemporaryFloat = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Temporary float field") );


//	TTypedFieldInterface<unsigned int>* Segments = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters 2") );
//	Segments->clear();
//	unsigned int segmaxidx = Segments->getMaxIndex();
	
	unsigned int x;
	// Fg
	TTypedFieldInterface<float>* FgDistanceField = 0;
	{
		*g_Log << "Process foreground\n";
		
		TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;
		// Simplify the skeleton
		{
			TAction_PruneSpSetForBoundarySegmentation SimplifiedEft;
			SimplifiedEft.m_FgBg = true;
			SimplifiedEft.m_ShortName = "spset pruned fg";
			const bool JustAdded = ! g_Mediator.getCurrentLayerSet()->exists( SimplifiedEft.m_ShortName ); 
			SimplifiedEft.perform();
			SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( SimplifiedEft.m_ShortName ) );
			if(! SPSF) throw string("!SPSF");
			//if(JustAdded) skel->addShortestPathSetAdaptorField(SPSF, SimplifiedEft.m_ShortName);
		}


		// Compute seeds
		TTypedFieldInterface<unsigned int>* Seeds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Seeds (fg)") );
		{
			const TFilter * Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			Seeds->clear();
			for(unsigned int x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				if(!Filter->test(s->getMaxLength())) continue;

				if(s->m_Paths.size() != 1) continue;
				for(unsigned int y=0; y<s->m_Paths.size(); y++)
				{
					if(!Filter->test(s->m_Paths[y]->m_Length)) continue;

					const unsigned int begin = s->m_Paths[y]->m_Begin;
					const unsigned int end = s->m_Paths[y]->m_End;
					if(begin < skel->m_BoundaryIndexField->getMaxIndex()) Seeds->wvaluex(begin) = 1;
					if(end < skel->m_BoundaryIndexField->getMaxIndex()) Seeds->wvaluex(end) = 1;
				}
			}	
			Seeds->getLayer()->onFieldChanged();
		}

		// Test: Remove seed points that only have a few neighbors
		if(DiscardSparseSeeds > 0)
		{
			*g_Log << "Discard sparse seeds with threshold " << DiscardSparseSeeds << "\n";
			TTypedFieldInterface<unsigned int> * Seeds =  static_cast<TTypedFieldInterface<unsigned int> *>(g_Mediator.getCurrentLayerSet()->getField( "Seeds (fg)" ) );
			TTypedFieldInterface<unsigned int>* SeedDensity = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Seed Density (fg)") );
			SeedDensity->clear();
			if(!Seeds) throw string("!Seeds");
			unsigned int x;
			for(x=0; x<Seeds->getMaxIndex(); x++)
			{
				if(Seeds->vvaluex(x) == 0) continue;

				vector<unsigned int> Neighbors;
				vector<float> Distances;
				// Determine all voxels within certain distance
				skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(x, Seeds, FgThreshold*2.0f, // *** PARAMETER
					&Neighbors, 
					&Distances
				);

				SeedDensity->wvaluex(x) = Neighbors.size();
			}
			SeedDensity->getLayer()->onFieldChanged();

			for(x=0; x<SeedDensity->getMaxIndex(); x++)
			{
				if(SeedDensity->vvaluex(x) < DiscardSparseSeeds )
				{
					SeedDensity->wvaluex(x) = 0;
					Seeds->wvaluex(x) = 0;
				}
			}
		}
		
		// Compute distance to seeds
		{
			FgDistanceField = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to seeds (fg)" ) );
			FgDistanceField->clear();
			skel->Omega->m_DeltaOmega->computeDistancesToNonZeros(Seeds, FgDistanceField);
			FgDistanceField->getLayer()->onFieldChanged();
			FgDistanceField->getLayer()->m_Filter->m_LowerValue = FgThreshold;
		}
		
		// Delete small components
		if(true)
		{
			vector< set<unsigned int> > Sizes;
			Temporary->clear();
			skel->Omega->m_DeltaOmega->findConnectedComponents(FgDistanceField->getLayer()->m_Filter.get(), Temporary, false, &Sizes);
			for(x=0; x<Temporary->getMaxIndex(); x++)
			{
				if(Temporary->vvaluex(x) != 0)
				{
					if(Sizes[Temporary->vvaluex(x)].size() < SMALLEDGESIZE)
					{
						FgDistanceField->wvaluex(x) = 0;
					}
				}
			}
			FgDistanceField->getLayer()->onFieldChanged();
		}

		FgDistanceField->getLayer()->m_Filter->m_LowerValue = FgThreshold;
	}

	// Bg
	TTypedFieldInterface<float>* BgDistanceField = 0;
	if(skel->m_BackgroundSpSetField)
	{
		*g_Log << "Process background\n";

		TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;
		// Simplify the skeleton
		{
			TAction_PruneSpSetForBoundarySegmentation SimplifiedEft;
			SimplifiedEft.m_FgBg = false;
			SimplifiedEft.m_ShortName = "spset pruned bg";
			const bool JustAdded = ! g_Mediator.getCurrentLayerSet()->exists( SimplifiedEft.m_ShortName ); 
			SimplifiedEft.perform();
			SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( SimplifiedEft.m_ShortName ) );
			if(! SPSF) throw string("!SPSF");
			//if(JustAdded) skel->addShortestPathSetAdaptorField(SPSF, SimplifiedEft.m_ShortName);
		}

		// Compute seeds
		TTypedFieldInterface<unsigned int>* Seeds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Seeds (bg)") );
		{
			const TFilter * Filter = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			Seeds->clear();
			for(unsigned int x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				if(!Filter->test(s->getMaxLength())) continue;

				if(s->m_Paths.size() != 1) continue;
				for(unsigned int y=0; y<s->m_Paths.size(); y++)
				{
					if(!Filter->test(s->m_Paths[y]->m_Length)) continue;

					const unsigned int begin = s->m_Paths[y]->m_Begin;
					const unsigned int end = s->m_Paths[y]->m_End;
					if(begin < skel->m_BoundaryIndexField->getMaxIndex()) Seeds->wvaluex(begin) = 1;
					if(end < skel->m_BoundaryIndexField->getMaxIndex()) Seeds->wvaluex(end) = 1;
				}
			}	
			Seeds->getLayer()->onFieldChanged();
		}


		// Compute distance to seeds
		{
			BgDistanceField = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to seeds (bg)" ) );
			BgDistanceField->clear();
			skel->Omega->m_DeltaOmega->computeDistancesToNonZeros(Seeds, BgDistanceField);
			BgDistanceField->getLayer()->onFieldChanged();
			BgDistanceField->getLayer()->m_Filter->m_LowerValue = BgThreshold;
		}

		// Delete small components
		if(true)
		{
			vector< set<unsigned int> > Sizes;
			Temporary->clear();
			skel->Omega->m_DeltaOmega->findConnectedComponents(BgDistanceField->getLayer()->m_Filter.get(), Temporary, false, &Sizes);
			for(x=0; x<Temporary->getMaxIndex(); x++)
			{
				if(Temporary->vvaluex(x) != 0)
				{
					if(Sizes[Temporary->vvaluex(x)].size() < SMALLEDGESIZE)
					{
						BgDistanceField->wvaluex(x) = 0;
					}
				}
			}
			BgDistanceField->getLayer()->onFieldChanged();
		}
		BgDistanceField->getLayer()->m_Filter->m_LowerValue = BgThreshold;
//		BgDistanceField->getLayer()->m_Filter->m_UpperValue = 10.0f; // Set upper bound
	}

	// !!!!!!!!!!!! ************* Tijdelijk verwijderd voor brain segmentatie verhaal
	return;


	// Combine edges
	TTypedFieldInterface<float>* Edges= static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Edges (combined)" ) );
	{
		Edges->clear();
		for(unsigned int x=0; x<FgDistanceField->getMaxIndex(); x++)
		{
			if( FgDistanceField->getLayer()->m_Filter->testx(x) ) 
			{
				Edges->wvaluex(x) = 0.001f;
			}
		}
		if(BgDistanceField)
		for(unsigned int x=0; x<BgDistanceField->getMaxIndex(); x++)
		{
			if( BgDistanceField->getLayer()->m_Filter->testx(x) ) 
			{
				Edges->wvaluex(x) = 0.001f;
			}
		}
		Edges->getLayer()->onFieldChanged();
	}

	// Store original edges
	TTypedFieldInterface<unsigned int>* OriginalEdges; 
	{
		OriginalEdges = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Original edges" ) );
		OriginalEdges->clear();		
		for(unsigned int y=0; y<OriginalEdges->getMaxIndex(); y++) OriginalEdges->wvaluex(y) = Edges->vvaluex(y) == 0.0f ? 0 : 1;
		OriginalEdges->getLayer()->onFieldChanged();
	}


	// Build extra edges
	TTypedFieldInterface<unsigned int>*  ExtraEdges = 0;
	TTypedFieldInterface<float>* InverseDistanceToSeeds  = 0;
	if(false)
	{
		TTypedFieldInterface<unsigned int>* EdgeComponents = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Edge components") );
		EdgeComponents->clear();
		vector< set<unsigned int> > EdgeComponentClusters;
		skel->Omega->m_DeltaOmega->findConnectedComponents(Edges->getLayer()->m_Filter.get(), EdgeComponents, false, &EdgeComponentClusters);
		EdgeComponents->getLayer()->onFieldChanged();

		TTypedFieldInterface<float>* EdgeEnds = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "EdgeEnds" ) );
		EdgeEnds->clear();

		// Delete small edge components
		if(true)
		{
			unsigned int MaxEdgeComponentClusterSize = 0;
			unsigned int y;
			for(y=1; y<EdgeComponentClusters.size(); y++)
			{
				if(EdgeComponentClusters[y].size() > MaxEdgeComponentClusterSize) MaxEdgeComponentClusterSize = EdgeComponentClusters[y].size();
			}

			unsigned int TooSmallThreshold = MaxEdgeComponentClusterSize * 0.05f;
			for(y=1; y<EdgeComponentClusters.size(); y++)
			{
				if(EdgeComponentClusters[y].size() < TooSmallThreshold)
				{
					*g_Log << "Deleted edge component " << y << " containing " << (unsigned int)EdgeComponentClusters[y].size() << " voxels (threshold: "<< MaxEdgeComponentClusterSize  << ")\n";
					for(set<unsigned int>::iterator it = EdgeComponentClusters[y].begin(); it != EdgeComponentClusters[y].end(); it++)
					{
						Edges->wvaluex(*it) = 0.0f;
					}
					EdgeComponentClusters[y].clear();
				}
			}
		}

		// Detect edge ends
		for(unsigned int y=1; y<EdgeComponentClusters.size(); y++)
		{
			if(EdgeComponentClusters[y].size() == 0) continue;

			EdgeComponents->getLayer()->m_Filter->m_LowerValue = ((float)y) - 0.01f;
			EdgeComponents->getLayer()->m_Filter->m_UpperValue = ((float)y) + 0.01f;

			set<unsigned int>::iterator it;
			for(it = EdgeComponentClusters[y].begin(); it != EdgeComponentClusters[y].end(); it++)
			{
				unsigned int idx = *it;
				const TPoint3 p = skel->m_BoundaryIndexField->vidx2coord(*it).toPoint();

				TPlane TangentPlane(p, BoundaryNormals->vvaluex(idx) );
				
				vector<unsigned int> Neighbors;
				vector<float> Distances;
				// Determine all voxels within certain distance
				skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(idx, EdgeComponents, 6.0f, // *** PARAMETER
					&Neighbors, 
					&Distances,
					EdgeComponents->getLayer()->m_Filter.get()
					);
				TVector3 avgnormal(0,0,0);
				
				vector<TVector3> Normals;
				unsigned int z;
				for(z=0; z<Neighbors.size(); z++)
				{
					if(Distances[z] < 3.0f) continue; // *** PARAMETER

					const unsigned int nidx = Neighbors[z];
					TVector3 q = skel->m_BoundaryIndexField->vidx2coord(nidx).toPoint();
					TangentPlane.project(q);
					q.subtract(p);
					q.normalize();
					Normals.push_back(q);
				}

				float mindot = 1000.0f;
				// Find maximum difference
				{
					for(unsigned int z1=0; z1<Normals.size(); z1++)
					for(unsigned int z2=z1+1; z2<Normals.size(); z2++)
					{
						const float dot = Normals[z1].dot(Normals[z2]);
						if(dot < mindot) mindot = dot;
					}
				}
				
				EdgeEnds->wvaluex(idx) = 1.0001f - mindot;
			}
		}
		EdgeComponents->getLayer()->onFieldChanged();
		EdgeEnds->getLayer()->onFieldChanged();

		// Build set EdgeEndsSet
		set<unsigned int> EdgeEndsSet;
		{
			EdgeEnds->getLayer()->m_Filter->m_LowerValue = 0.001f;
			EdgeEnds->getLayer()->m_Filter->m_UpperValue = 0.8f;
			Temporary->clear();
			vector< set<unsigned int> > EndsClusters;
			skel->Omega->m_DeltaOmega->findConnectedComponents(EdgeEnds->getLayer()->m_Filter.get(), Temporary, false, &EndsClusters);
			for(unsigned int x=0; x<EndsClusters.size(); x++)
			{
				if(EndsClusters.size() == 0) continue;
				EdgeEndsSet.insert( *EndsClusters[x].begin() );
			}
		}
		*g_Log << "Found " << (unsigned int)EdgeEndsSet.size() << " edge ends\n";



		// Compute inverse distance field for edge tracking
		unsigned int EdgeCount = 1;
		InverseDistanceToSeeds = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "InverseDistanceToSeeds" ) );
		{
			InverseDistanceToSeeds->clear();
			for(x=0; x<FgDistanceField->getMaxIndex(); x++)
			{
				InverseDistanceToSeeds->wvaluex(x) =  FgDistanceField->getLayer()->m_FilterMeasure->getMaxValue() - FgDistanceField->vvaluex(x);
			}
		//	for(x=0; x<BgDistanceField->getMaxIndex(); x++)
		//	{
		//		const float v = BgDistanceField->getLayer()->m_FilterMeasure->getMaxValue() - BgDistanceField->vvaluex(x);;
		//		if(v < InverseDistanceToSeeds->vvaluex(x)) InverseDistanceToSeeds->wvaluex(x) = v;
		//	}
			InverseDistanceToSeeds->getLayer()->onFieldChanged();
		}

		// Compute distance to edge ends on non-edges
		{
			TTypedFieldInterface<float>* EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Edge End Distance" ) );
			EdgeDistance->clear(); 
			TInvertFilter InverseFilter(Edges->getLayer()->m_Filter.get());
			skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomainFilter(&EdgeEndsSet, &InverseFilter, EdgeDistance, InverseDistanceToSeeds);
			EdgeDistance->getLayer()->onFieldChanged();
			EdgeDistance->getLayer()->m_Filter->m_LowerValue = 0.01f;
		}
		

		// Make extra edges
		ExtraEdges = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Extra Edges") );
		ExtraEdges->clear();
		for(set<unsigned int>::iterator it = EdgeEndsSet.begin(); it != EdgeEndsSet.end(); it++)
		{
			unsigned int idx = *it;
			set<unsigned int> SinglePoint;
			SinglePoint.insert( idx );
			TemporaryFloat->clear();
			skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomainFilter(&SinglePoint, Edges->getLayer()->m_Filter.get(), TemporaryFloat);
			for(unsigned int x=0; x<TemporaryFloat->getMaxIndex(); x++)
			{
				if(TemporaryFloat->vvaluex(x) == 0.0f && Edges->vvaluex(x) != 0.0f)
				{
					TemporaryFloat->wvaluex(x) = 5000.0f;
				}
			}

			float Length;
			TemporaryFloat->getLayer()->m_Filter->m_LowerValue = 50.0f; // *** PARAMETER
			TemporaryFloat->getLayer()->m_Filter->m_UpperValue = 9000.0f;
			TIndexedOrigins_Vector Path;
			TAbstractFilter * TargetFilter = TemporaryFloat->getLayer()->m_Filter.get();
			TAbstractFilter * DomainFilter = &TInvertFilter( Edges->getLayer()->m_Filter.get() );
			unsigned int nidx = skel->Omega->m_DeltaOmega->findNearestWithTargetFilterAndDomainFilter(idx, Length, InverseDistanceToSeeds, TargetFilter, DomainFilter, &Path ); 
			float maxinvdist = 0.0f; 
			if(nidx < skel->m_BoundaryIndexField->getMaxIndex())
			{
				for(unsigned int z=0; z<Path.size(); z++)
				{
					ExtraEdges->wvaluex( Path[z] ) = EdgeCount;
					if( InverseDistanceToSeeds->vvaluex( Path[z] ) > maxinvdist )
					{
						maxinvdist = InverseDistanceToSeeds->vvaluex( Path[z] );
					}
				}

				// Print extra edge info
				*g_Log << "Extra edge " << EdgeCount << ", from: " << idx << ", to: " << nidx << ", length: " << Length << ", max inv. dist.: " << maxinvdist << "\n";

				EdgeCount++;
			}
		}
		ExtraEdges->getLayer()->onFieldChanged();
	}

	// Distance to original edges
	{
		TTypedFieldInterface<float>* EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to original edges using cost" ) );
		EdgeDistance->clear();
		skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeeds(Edges, EdgeDistance, false, InverseDistanceToSeeds);
		EdgeDistance->getLayer()->onFieldChanged();
		EdgeDistance->getLayer()->m_Filter->m_LowerValue = 1.0f;
	}

	return;

	// Make original clustering
	TTypedFieldInterface<float>* EdgeDistance;
	TTypedFieldInterface<unsigned int>* OriginalClustering;
	{
		// Build Edge Distance 
		EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to original edges" ) );
		EdgeDistance->clear();
		skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeeds(Edges, EdgeDistance, false);
		EdgeDistance->getLayer()->onFieldChanged();
		EdgeDistance->getLayer()->m_Filter->m_LowerValue = 0.01f;

		OriginalClustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters using original edges") );
		OriginalClustering->clear();
		skel->Omega->m_DeltaOmega->findConnectedComponents(EdgeDistance->getLayer()->m_Filter.get(), OriginalClustering, false, 0);
	
//		cleanUp( OriginalClustering, BoundaryNormals );
	}


	// Make ext. clustering
	if(ExtraEdges)
	{
		// Merge extra edges into edges
		for(unsigned int y=0; y<ExtraEdges->getMaxIndex(); y++)
		{
			if(ExtraEdges->vvaluex(y) != 0.0f ) Edges->wvaluex(y) = 0.001f;
		}

		// Build Edge Distance 
		TTypedFieldInterface<float>* EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Distance to ext. edges" ) );
		EdgeDistance->clear();
		skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeeds(Edges, EdgeDistance, false);
		EdgeDistance->getLayer()->onFieldChanged();
		EdgeDistance->getLayer()->m_Filter->m_LowerValue = 1.0f;

		TTypedFieldInterface<unsigned int>* Clustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clustering using ext. edges") );
		Clustering->clear();
		skel->Omega->m_DeltaOmega->findConnectedComponents(EdgeDistance->getLayer()->m_Filter.get(), Clustering, false, 0);
	
//		cleanUp( Clustering, BoundaryNormals );
	}


	// Do incremental splitting
	if(false)
	{
		unsigned int x;
		TTypedFieldInterface<unsigned int>* Clustering = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clustering splits") );
		for(x=0; x<Clustering->getMaxIndex(); x++) Clustering->wvaluex(x) = OriginalClustering->vvaluex(x);


		// Delete all previous debugging split layers
		const unsigned int SplitSteps = 40;
		{
			for(x=1; x<SplitSteps ; x++)
			{
				g_Mediator.getCurrentLayerSet()->deleteLayer( wxString::Format("Clustering split %i", x).ToStdString() );
			}
		}
		
		// Split components with normal fluctuation
		for(x=1; x<SplitSteps ; x++)
		{
			EdgeDistance->getLayer()->m_Filter->m_LowerValue = 0.001f + 0.5f * (float)x;

			unsigned int MaxOldClustering = 0;
			{
				for(unsigned int y=0; y<Clustering->getMaxIndex(); y++)
				{
					if( Clustering->vvaluex(y) > MaxOldClustering ) MaxOldClustering = Clustering->vvaluex(y);
				}
			}

			vector< set<unsigned int> > NewClusters;
			
			TTypedFieldInterface<unsigned int>* NewClustering = Temporary;
			NewClustering->clear();
			skel->Omega->m_DeltaOmega->findConnectedComponents(EdgeDistance->getLayer()->m_Filter.get(), NewClustering, false, &NewClusters);
			NewClustering->getLayer()->onFieldChanged();

			// See which new clusters are included in old clusters
			vector< set<unsigned int> > Old2New; 
			Old2New.resize( MaxOldClustering + 1 );
			unsigned int y;
			for(y=1; y<NewClusters.size(); y++)
			{
				if(NewClusters[y].size() < 20) continue;

				set<unsigned int>::iterator it = NewClusters[y].begin();
				unsigned int newclustervoxel = *it;
				Old2New[ Clustering->vvaluex(newclustervoxel) ].insert( y );
			}

			// Now see if there's an old cluster which has multiple new clusters
			*g_Log << "*** Try split edge distance: " << EdgeDistance->getLayer()->m_Filter->m_LowerValue << "\n";

			bool split = false;
			for(y=0; y<Old2New.size(); y++)
			{
				unsigned int oldid = y;

				if(Old2New[oldid].size() >= 2) // If a cluster is split (minimally two subclusters)
				{

					// Replace old cluster with split new clusters

					// Compute average normal of old cluster
					float stdev = 0.0f;
					unsigned int OldClusterCount = 0;
					TVector3 oldnormal(0,0,0);
					{
						unsigned int z;
						for(z=0; z<Clustering->getMaxIndex(); z++)
						{
							if(Clustering->vvaluex(z) == oldid)
							{
								oldnormal.add( BoundaryNormals->vvaluex(z) );
								OldClusterCount++;
							}
						}
						oldnormal.normalize();

						// Compute standard deviation
						for(z=0; z<Clustering->getMaxIndex(); z++)
						{
							if(Clustering->vvaluex(z) == oldid)
								//stdev += oldnormal.dot(BoundaryNormals->vvaluex(z)) * oldnormal.dot(BoundaryNormals->vvaluex(z));
								stdev += (1.0f - oldnormal.dot(BoundaryNormals->vvaluex(z))) * (1.0f - oldnormal.dot(BoundaryNormals->vvaluex(z)));
						}
						stdev /= (float) OldClusterCount;
						stdev = sqrtf(stdev);
					}
					
					// Sum of new clusters replacing the old one
					unsigned int sumnew = 0;
					{
						set<unsigned int>::iterator it;
						for(it = Old2New[oldid].begin(); it != Old2New[oldid].end(); it++)
						{
							sumnew += NewClusters[ *it ].size();
						}
					}
					float newoldratio = (float) sumnew / (float) OldClusterCount;

					*g_Log << "Candidate split, cluster " << oldid << " normal: " << wxString::Format("(%.2f, %.2f, %.2f)", oldnormal.x, oldnormal.y, oldnormal.z).c_str() << ", ";
					*g_Log << "stddev: " << wxString::Format("%.4f",stdev) << ", ";
					*g_Log << "newoldratio: " << wxString::Format("%.4f",newoldratio) << ", ";
					*g_Log << "\n";

					// New: find a path from center of new segments to each other with and without obstructions
					{
						*g_Log << "SP dist ratio: ";
						set<unsigned int> & OldClusters = Old2New[oldid];
						for(set<unsigned int>::iterator it = OldClusters.begin(); it != OldClusters.end(); it++)
						{
							for(set<unsigned int>::iterator jt = it; jt != OldClusters.end(); jt++)
							{
								if(it == jt) continue;

								unsigned int from = *NewClusters[ *it ].begin();
								unsigned int to = *NewClusters[ *jt ].begin();
								float DistanceWithoutEdges = skel->Omega->m_DeltaOmega->findShortestPath(from, to, 0);
								TInvertFilter InvertFilter( Edges->getLayer()->m_Filter.get() );
								float DistanceWithEdge = skel->Omega->m_DeltaOmega->findShortestPath(from, to, &InvertFilter);

								*g_Log << "from " << from << " to " << to << ": " << (DistanceWithEdge / DistanceWithoutEdges) << ", ";
							}
						}
						*g_Log << "\n";
					}


					if(stdev > 0.02f && newoldratio > 0.3f)
					{
						// First remove old cluster
						for(unsigned int z=0; z<Clustering->getMaxIndex(); z++)
						{	
							if(Clustering->vvaluex(z) == oldid) Clustering->wvaluex(z) = 0;
						}

						// Now put the new clusters in place
						set<unsigned int>::iterator it,jt;
						for(it = Old2New[oldid].begin(); it != Old2New[oldid].end(); it++)
						{
							MaxOldClustering++;
							for(jt = NewClusters[*it].begin(); jt != NewClusters[*it].end(); jt++)
							{
								Clustering->wvaluex(*jt) = MaxOldClustering;
							}
						}
						split = true;

					}

					/*
					// See if potential new cluster has a different normal than old cluster, only then split
					set<unsigned int>::iterator it;
					for(it = Old2New[oldid].begin(); it != Old2New[oldid].end(); it++)
					{
						// Compute new normal
						TVector3 newnormal(0,0,0);
						{
							set<unsigned int>::iterator jt;
							for(jt = NewClusters[*it].begin(); jt != NewClusters[*it].end(); jt++)
							{
								newnormal.add( BoundaryNormals->vvaluex(*jt) );
							}
							newnormal.normalize();
						}
						
						if( newnormal.dot(oldnormal) < 0.9f )
						{
							*g_Log << "Splitting oldid " << oldid << " into "; 

							// First remove old cluster
							for(unsigned int z=0; z<Clustering->getMaxIndex(); z++)
							{	
								if(Clustering->vvaluex(z) == oldid) Clustering->wvaluex(z) = 0;
							}

							// Now put the new clusters in place
							set<unsigned int>::iterator it,jt;
							for(it = Old2New[oldid].begin(); it != Old2New[oldid].end(); it++)
							{
								MaxOldClustering++;
								for(jt = NewClusters[*it].begin(); jt != NewClusters[*it].end(); jt++)
								{
									Clustering->wvaluex(*jt) = MaxOldClustering;
								}
							}
							split = true;
						}
						else
						{
							*g_Log << "Not splitting oldid " << oldid << " because of limited normal difference: " << dot << "\n"; 
						}
					}
					*/
				}
			}

			if(split)
			{
				TTypedFieldInterface<unsigned int>* CopyCluster = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, wxString::Format("Clustering split %i", x).ToStdString() ) );
				CopyCluster->getLayer()->m_Name = wxString::Format("Clustering split %i (%.2f)", x, EdgeDistance->getLayer()->m_Filter->m_LowerValue).ToStdString();
				CopyCluster->clear();		
				for(unsigned int y=0; y<Clustering->getMaxIndex(); y++) CopyCluster->wvaluex(y) = Clustering->vvaluex(y);
				CopyCluster->getLayer()->onFieldChanged();
			}
		}
		Clustering->getLayer()->onFieldChanged();
//		cleanUp( Clustering,  BoundaryNormals );
	}


	/*
	// Test: perform CLUSTERING using forbidden
	{
		Id2Cluster.clear();
		Id2Cluster.push_back(0);

		TTypedFieldInterface<TIndexedOrigins_Vector*>* BoundaryForbidden= static_cast<TTypedFieldInterface<TIndexedOrigins_Vector*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, "Forbidden (fg)") );
		BoundaryForbidden->clear();

		TTypedFieldInterface<float >* ClusterRho = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "ClusterRho") );
		ClusterRho->clear();

		TTypedFieldInterface<unsigned int>* ClusterIds = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "ClusterIds") );
		ClusterIds->clear();

		// Process foreground skeleton
		{
			TTypedFieldInterface<TShortestPathSet*> * SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( "spset pruned fg") );
			const TFilter * Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			for(x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				TShortestPathSet::TPaths & Paths = s->m_Paths;
				if(Filter && !Filter->test(s->m_SourceVoxel)) continue;

				// Old approach: take only longest path
				if(s->m_Paths.size() != 1) continue;
				for(y=0; y<Paths.size(); y++)
				{
					if(!Filter->test( Paths[y]->m_Length ) ) continue;

					unsigned int idx1 = Paths[y]->m_Begin;
					unsigned int idx2 = Paths[y]->m_End;
					//if(ClusterRho->vvaluex(idx1) == 0.0f || Paths[y]->m_Length > ClusterRho->vvaluex(idx1)) ClusterRho->wvaluex(idx1) = Paths[y]->m_Length;
					//if(ClusterRho->vvaluex(idx2) == 0.0f || Paths[y]->m_Length > ClusterRho->vvaluex(idx2)) ClusterRho->wvaluex(idx2) = Paths[y]->m_Length;
					
					// See if shortest path crosses a border
					shared_ptr<TShortestPath> sp = skel->Omega->m_DeltaOmega->getShortestPath(idx1,idx2);
					bool CrossesEdge = false;
					for(unsigned int z=0; z<sp->m_Path->size(); z++)
					{
						if( OriginalEdges->vvaluex( (*sp->m_Path)[z] ) != 0.0f )
						{
							CrossesEdge = true;
							break;
						}
					}
					if(!CrossesEdge) continue;

					
					TCluster2 * Cluster1 = Id2Cluster[ ClusterIds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster2(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						m_Clusters.insert(Cluster1);
						ClusterIds->wvaluex(idx1) = Cluster1->m_Id;
					}
					Cluster1->m_Forbidden.insert( idx2 );
					if( !BoundaryForbidden->vvaluex(idx1) ) BoundaryForbidden->wvaluex(idx1) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx1)->push_back( idx2 );
					
					
					TCluster2 * Cluster2 = Id2Cluster[ ClusterIds->vvaluex(idx2) ];
					if(Cluster2 == 0)
					{
						Cluster2 = new TCluster2(Id2Cluster.size(),idx2);
						Id2Cluster.push_back(Cluster2);
						m_Clusters.insert(Cluster2);
						ClusterIds->wvaluex(idx2) = Cluster2->m_Id;
					}
					Cluster2->m_Forbidden.insert( idx1 );
					if( !BoundaryForbidden->vvaluex(idx2) ) BoundaryForbidden->wvaluex(idx2) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx2)->push_back( idx1 );
				}
			}
		}

		// Process background skeleton
		{
			TTypedFieldInterface<TShortestPathSet*> * SPSF =  static_cast<TTypedFieldInterface<TShortestPathSet*> *>(g_Mediator.getCurrentLayerSet()->getField( "spset pruned bg") );
			const TFilter * Filter = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			for(x=0; x<SPSF->getMaxIndex(); x++)
			{
				TShortestPathSet * s = SPSF->vvaluex(x);
				TShortestPathSet::TPaths & Paths = s->m_Paths;
				if(Filter && !Filter->test(s->m_SourceVoxel)) continue;

				// Old approach: take only longest path
				if(s->m_Paths.size() != 1) continue;
				for(y=0; y<Paths.size(); y++)
				{
					if(!Filter->test( Paths[y]->m_Length ) ) continue;

					unsigned int idx1 = Paths[y]->m_Begin;
					if(idx1 > skel->m_BoundaryIndexField->getMaxIndex()) continue;
					unsigned int idx2 = Paths[y]->m_End;
					if(idx2 > skel->m_BoundaryIndexField->getMaxIndex()) continue;
					//if(ClusterRho->vvaluex(idx1) == 0.0f || Paths[y]->m_Length > ClusterRho->vvaluex(idx1)) ClusterRho->wvaluex(idx1) = Paths[y]->m_Length;
					//if(ClusterRho->vvaluex(idx2) == 0.0f || Paths[y]->m_Length > ClusterRho->vvaluex(idx2)) ClusterRho->wvaluex(idx2) = Paths[y]->m_Length;
					
					// See if shortest path crosses a border
					shared_ptr<TShortestPath> sp = skel->Omega->m_DeltaOmega->getShortestPath(idx1,idx2);
					bool CrossesEdge = false;
					for(unsigned int z=0; z<sp->m_Path->size(); z++)
					{
						if( OriginalEdges->vvaluex( (*sp->m_Path)[z] ) != 0.0f )
						{
							CrossesEdge = true;
							break;
						}
					}
					if(!CrossesEdge) continue;

					
					TCluster2 * Cluster1 = Id2Cluster[ ClusterIds->vvaluex(idx1) ];
					if(Cluster1 == 0)
					{
						Cluster1 = new TCluster2(Id2Cluster.size(), idx1);
						Id2Cluster.push_back(Cluster1);
						m_Clusters.insert(Cluster1);
						ClusterIds->wvaluex(idx1) = Cluster1->m_Id;
					}
					Cluster1->m_Forbidden.insert( idx2 );
					if( !BoundaryForbidden->vvaluex(idx1) ) BoundaryForbidden->wvaluex(idx1) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx1)->push_back( idx2 );
					
					
					TCluster2 * Cluster2 = Id2Cluster[ ClusterIds->vvaluex(idx2) ];
					if(Cluster2 == 0)
					{
						Cluster2 = new TCluster2(Id2Cluster.size(),idx2);
						Id2Cluster.push_back(Cluster2);
						m_Clusters.insert(Cluster2);
						ClusterIds->wvaluex(idx2) = Cluster2->m_Id;
					}
					Cluster2->m_Forbidden.insert( idx1 );
					if( !BoundaryForbidden->vvaluex(idx2) ) BoundaryForbidden->wvaluex(idx2) = new TIndexedOrigins_Vector(4);
					BoundaryForbidden->wvaluex(idx2)->push_back( idx1 );
				}
			}
		}


		BoundaryForbidden->getLayer()->onFieldChanged();
		ClusterIds->getLayer()->onFieldChanged();
		ClusterRho->getLayer()->onFieldChanged();

		*g_Log << "Compute neighborhoods\n";
		m_VoxelNeighborhoods = static_cast<TTypedFieldInterface<TIndexedOrigins*>*>( g_Mediator.getCurrentLayerSet()->newIoField( skel->Omega->m_BoundaryIndexField, skel->Omega->m_BoundaryIndexField, "Neighborhoods" ) );
		m_VoxelNeighborhoods->clear();

		for(x=0; x<ClusterIds->getMaxIndex(); x++)
		{
			m_VoxelNeighborhoods->wvaluex(x) = new TIndexedOrigins_Vector(4);
		}

		{
			const float Threshold = max( skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue - 2.0f, 4.0f );

			*g_Log << "Computing neighborhoods with max distance " << Threshold << "\n";
			for(x=0; x<ClusterIds->getMaxIndex(); x++)
			{
				if(ClusterIds->vvaluex(x) != 0)
				{
					determineVoxelNeighborhood( x, Threshold, ClusterIds );
				}
			}
		}
		m_VoxelNeighborhoods->getLayer()->onFieldChanged();
		
		typedef multimap<float, pair<unsigned int, unsigned int>, greater<float> > TQueue;
		TQueue Queue;

		for(x=0; x<ClusterIds->getMaxIndex(); x++)
		{
			if(ClusterIds->vvaluex(x) == 0) continue;

			const unsigned int idx = x;
			const TIndexedOrigins_Vector * vec = m_VoxelNeighborhoods->vvaluex(idx)->castVector();
			for(unsigned int y=0; y<vec->size(); y++)
			{
				const unsigned int nidx = vec->at(y);
				
				// Use edge distance: werkt niet goed
				//Queue.insert( TQueue::value_type( EdgeDistance->vvaluex(idx) + EdgeDistance->vvaluex(nidx), pair<unsigned int, unsigned int>(idx,nidx) ) );

				// Use rho: werkt niet goed
				// Queue.insert( TQueue::value_type( ClusterRho->vvaluex(idx) + ClusterRho->vvaluex(nidx), pair<unsigned int, unsigned int>(idx,nidx) ) );
				
				// Use normal 
				 Queue.insert( TQueue::value_type( BoundaryNormals->vvaluex(idx).dot( BoundaryNormals->vvaluex(nidx) ), pair<unsigned int, unsigned int>(idx,nidx) ) );
			}
		}

		unsigned int MergeCount = 0;
		while( !Queue.empty() )
		{
			unsigned int idx1 = Queue.begin()->second.first;
			unsigned int idx2 = Queue.begin()->second.second;
			Queue.erase( Queue.begin() );
			
			unsigned int cid1 = ClusterIds->vvaluex(idx1);
			TCluster2 * Cluster1 = Id2Cluster[cid1];
			if(!Cluster1) 
			{
				*g_Log << "!";
				continue;
			}
			unsigned int cid2 = ClusterIds->vvaluex(idx2);
			TCluster2 * Cluster2 = Id2Cluster[cid2];
			if(!Cluster2) 
			{
				*g_Log << "!";
				continue;
			}
			if(Cluster1 == Cluster2) continue;

			if( canBeMerged(Cluster1,Cluster2) )
			{
				// Merge voxels of 2 to 1
				for(set<unsigned int>::iterator jt=Cluster2->m_Voxels.begin(); jt!=Cluster2->m_Voxels.end(); jt++)
				{
					const unsigned int idx = *jt;
					Cluster1->m_Voxels.insert(idx);
					ClusterIds->wvaluex(idx) = Cluster1->m_Id;
				}

				// Merge forbidden
				{
					for(set<unsigned int>::iterator kt=Cluster2->m_Forbidden.begin(); kt!=Cluster2->m_Forbidden.end(); kt++)
					{
						Cluster1->m_Forbidden.insert(*kt);
					}
				}
				// Clear cluster2
				Id2Cluster[Cluster2->m_Id] = 0;
				Cluster2->m_Id = 0;
				Cluster2->m_Voxels.swap( set<unsigned int>() );
				Cluster2->m_Forbidden.swap( set<unsigned int>() );
				MergeCount++;
			}
		}


		// Delete clusters
		{
			for(set<TCluster2*>::iterator it=m_Clusters.begin(); it != m_Clusters.end(); it++) delete *it;
		}
	}
	*/

}

bool TAction_NotUsingSskelSegmentation3::canBeMerged(TCluster2 * f, TCluster2 * t)
{
	set<unsigned int>::iterator jt, kt;

	jt = f->m_Voxels.begin();
	kt = t->m_Forbidden.begin();
	while(jt != f->m_Voxels.end() && kt != t->m_Forbidden.end())
	{
		if(*jt < *kt) jt++;
		else if(*jt > *kt) kt++;
		else if(*jt == *kt) 
		{ 
			return false;
		}
	}

	jt = f->m_Forbidden.begin();
	kt = t->m_Voxels.begin();
	while(jt != f->m_Forbidden.end() && kt != t->m_Voxels.end())
	{
		if(*jt < *kt) jt++;
		else if(*jt > *kt) kt++;
		else if(*jt == *kt) 
		{ 
			return false;
		}
	}
// */

	return true;
}

void TAction_NotUsingSskelSegmentation3::determineVoxelNeighborhood(unsigned int p_Voxel, float p_Threshold, TTypedFieldInterface<unsigned int> * p_Seeds)
{
	// This should be called only once for each voxel
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	unsigned int x,y;

	vector<unsigned int> Neighbors;
	vector<float> Distances;
	// Determine all voxels within certain distance
	skel->Omega->m_DeltaOmega->findAllNonZerosWithinDistance(p_Voxel, p_Seeds, p_Threshold, 
		&Neighbors, 
		&Distances
		);
	
	if(!BoundaryNormals) throw string("!BoundaryNormals");

	vector< pair<TVector3, unsigned int> > Neighborhood;
	Neighborhood.clear();
	TCluster::TNeighbors::iterator it;
	const TCoord3 scoord = skel->m_BoundaryIndexField->vidx2coord(p_Voxel);
	TPlane TangentPlane( scoord.toPoint(), BoundaryNormals->vvaluex(p_Voxel) );
	
	for(x=0; x<Neighbors.size(); x++)
	{
		const unsigned int nidx = Neighbors[x];
		const TCoord3 ncoord = skel->m_BoundaryIndexField->vidx2coord(nidx);
		TVector3 nv = ncoord.toVector();
		//nv.subtract( scoord.toPoint() );
		//nv.normalize();
		
		TangentPlane.project( nv );
		nv.subtract( scoord.toPoint() );
		if(nv.length() > 0.1f)
		{
			nv.normalize();
		
			// nv is projected, now look at angle with existing neighbors
			bool add = true;
			for(y=0; y<Neighborhood.size(); y++)
			{
				float dot = Neighborhood[y].first.dot( nv );
				if(dot > 0.999f) dot = 0.999f;
				if(dot < -0.999f) dot = -0.999f;
				const float degrees = ( acos(dot) / PI ) * 180.0f;
				if( degrees < 25.0f )
				{
					add = false;
					break;
				}
			}

			Neighborhood.push_back( pair<TVector3,unsigned int>( nv, nidx ) );

			if(add)
			{
				{
					unsigned int voxel = p_Voxel;
					unsigned int inserthis = Neighbors[x];
					TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(voxel)->castVector();
					unsigned int z;
					for(z=0; z<v->size(); z++) if((*v)[z] == inserthis) break;
					if( z==v->size() ) v->push_back( inserthis );
				}

				// Make symmetrical
				{
					unsigned int voxel = Neighbors[x];
					unsigned int inserthis = p_Voxel; 
					TIndexedOrigins_Vector * v = m_VoxelNeighborhoods->vvaluex(voxel)->castVector();
					unsigned int z;
					for(z=0; z<v->size(); z++) if((*v)[z] == inserthis) break;
					if( z==v->size() ) v->push_back( inserthis );
				}
			}
		}			
	}
}


// ------------------------------------------------------------------------------------------


bool TAction_UsingRhoMapping::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}

TTypedFieldInterface<float>* TAction_UsingRhoMapping::mapTo(const string p_Name, const TTypedFieldInterface<TShortestPathSet*> * p_SPSF, const TFilter * p_Filter)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	unsigned int x,y;
	TTypedFieldInterface<float>* Rho = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Rho on boundary " + p_Name) );
	Rho->clear();
	for(x=0; x<p_SPSF->getMaxIndex(); x++)
	{
		const TCoord3 p = p_SPSF->getIndexField()->vidx2coord(x);
		TShortestPathSet * s = p_SPSF->vvaluex(x);
		TShortestPathSet::TPaths & Paths = s->m_Paths;
//			if(!Filter || !Filter->test(s->m_SourceVoxel)) continue;
//		if(s->getMaxLength() < ThresholdLow && s->getMaxLength() > ThresholdHigh) continue;

		if(s->m_Paths.size() != 1) continue;
		for(y=0; y<Paths.size(); y++)
		{
			const float rho = Paths[y]->m_Length;
			if(!p_Filter->test(rho)) continue;
			
			if(Rho->vvaluex(Paths[y]->m_Begin) == 0.0f || rho < Rho->vvaluex(Paths[y]->m_Begin)) Rho->wvaluex(Paths[y]->m_Begin) = rho;
			if(Rho->vvaluex(Paths[y]->m_End)== 0.0f || rho < Rho->vvaluex(Paths[y]->m_End)) Rho->wvaluex(Paths[y]->m_End) = rho;
		}
	}

	Rho->getLayer()->onFieldChanged();
	return Rho;
}

void TAction_UsingRhoMapping::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

//	shared_ptr<TLayer> Layer = g_Mediator.getCurrentLayer();
//	if(!Layer) throw string("!Layer");
//	const TFilter * Filter = Layer->m_Filter.get();
//	const TMeasure * Measure = Layer->m_FilterMeasure.get();

	{
		TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_ForegroundSpSetField.get();
		const TFilter * Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		TTypedFieldInterface<float>* Rho = mapTo("(fg)", SPSF,Filter);

		//TTypedFieldInterface<float>* RhoFilled = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Rho on boundary filled (fg)") );
		//for(unsigned int x=0; x<Rho->getMaxIndex(); x++) RhoFilled->wvaluex(x) = Rho->vvaluex(x);
		//skel->Omega->m_DeltaOmega->fillZerosByPropagation(RhoFilled);
		//RhoFilled->getLayer()->onFieldChanged();

		// Idee: doe computeDistancesToNonZeros en kijk naar closestpoint
		// Trek berekende afstand af van rho op closest point
		// Dit is de nieuwe waarde
		
	}

	if(skel->m_BackgroundSpSetField)
	{
		TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_BackgroundSpSetField.get();
		const TFilter * Filter = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		TTypedFieldInterface<float>* Rho = mapTo("(bg)", SPSF,Filter);
//		skel->Omega->m_DeltaOmega->fillZerosByPropagation(Rho);
	}

}




// ------------------------------------------------------------------------------------------


bool TAction_UsingRhoMappingAndShortestPaths::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}

TTypedFieldInterface<float>* TAction_UsingRhoMappingAndShortestPaths::mapTo(const string p_Name, const TTypedFieldInterface<TShortestPathSet*> * p_SPSF, const TFilter * p_Filter)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	unsigned int x,y;
	TTypedFieldInterface<float>* Rho = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Rho on boundary " + p_Name) );
	Rho->clear();
	typedef multimap<float, TShortestPath*> TShortestPaths;
	TShortestPaths ShortestPaths;
	for(x=0; x<p_SPSF->getMaxIndex(); x++)
	{
		const TCoord3 p = p_SPSF->getIndexField()->vidx2coord(x);
		TShortestPathSet * s = p_SPSF->vvaluex(x);
		TShortestPathSet::TPaths & Paths = s->m_Paths;
//			if(!Filter || !Filter->test(s->m_SourceVoxel)) continue;
//		if(s->getMaxLength() < ThresholdLow && s->getMaxLength() > ThresholdHigh) continue;

		if(s->m_Paths.size() != 1) continue;
		for(y=0; y<Paths.size(); y++)
		{
			const float rho = Paths[y]->m_Length;
			if(!p_Filter->test(rho)) continue;

			ShortestPaths.insert( TShortestPaths::value_type(rho, Paths[y].get()) );
		}
	}

	TShortestPaths::iterator it;
	for(it = ShortestPaths.begin(); it != ShortestPaths.end(); it++)
	{
		TShortestPath * sp = it->second;
		shared_ptr<TIndexedOrigins_Vector> v;
		if(sp->m_Path) v = sp->m_Path;
		else v = skel->Omega->m_DeltaOmega->getShortestPath(sp->m_Begin, sp->m_End)->m_Path;

//		const TIndexedOrigins_Vector * v = sp->m_Path.get();
		const float currentpos = sp->m_Length;
		for(unsigned int z=0; z<v->size(); z++)
		{
			const float idx = (*v)[z];
			const int l = abs( (int)((v->size()/2) - z) );
			if(Rho->vvaluex(idx) == 0)
			{	
				Rho->wvaluex(idx) = l;
			}
		}
	}


	Rho->getLayer()->onFieldChanged();
	return Rho;
}

void TAction_UsingRhoMappingAndShortestPaths::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

//	shared_ptr<TLayer> Layer = g_Mediator.getCurrentLayer();
//	if(!Layer) throw string("!Layer");
//	const TFilter * Filter = Layer->m_Filter.get();
//	const TMeasure * Measure = Layer->m_FilterMeasure.get();

	{
		TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_ForegroundSpSetField.get();
		const TFilter * Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		TTypedFieldInterface<float>* Rho = mapTo("(fg)", SPSF,Filter);

		//TTypedFieldInterface<float>* RhoFilled = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Rho on boundary filled (fg)") );
		//for(unsigned int x=0; x<Rho->getMaxIndex(); x++) RhoFilled->wvaluex(x) = Rho->vvaluex(x);
		//skel->Omega->m_DeltaOmega->fillZerosByPropagation(RhoFilled);
		//RhoFilled->getLayer()->onFieldChanged();

		// Idee: doe computeDistancesToNonZeros en kijk naar closestpoint
		// Trek berekende afstand af van rho op closest point
		// Dit is de nieuwe waarde
		
	}

	if(skel->m_BackgroundSpSetField)
	{
		TTypedFieldInterface<TShortestPathSet*> * SPSF = skel->m_BackgroundSpSetField.get();
		const TFilter * Filter = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
		TTypedFieldInterface<float>* Rho = mapTo("(bg)", SPSF,Filter);
//		skel->Omega->m_DeltaOmega->fillZerosByPropagation(Rho);
	}

}


// ------------------------------------------------------------------------------------------


bool TAction_NotUsingSskelSegmentation4::isAvailable()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	if(!skel) return false;
	return true; 

}


void TAction_NotUsingSskelSegmentation4::perform_main()
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TSskelSegmenter * segm = g_Mediator.getSskelSegmenter().get();

	double FgThreshold = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue;
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("FG Threshold", "FG Threshold", wxString::Format("%f",FgThreshold).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&FgThreshold) );
		}
	}

	double BgThreshold = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter->m_LowerValue;
	{
		{
			wxString s = "";
			do
			{
				s = ::wxGetTextFromUser("BG Threshold", "BG Threshold", wxString::Format("%f",BgThreshold).c_str() );
				if(s == "") return;
			} 
			while( !s.ToDouble(&BgThreshold) );
		}
	}

	unsigned int x,y,z;

	// Fg
	TTypedFieldInterface<float>* FgField = 0; 
	TTypedFieldInterface<float>* BgField = 0;
	for(unsigned int fgbg = 0; fgbg < 2; fgbg++)
	{
		TFloatFilter * Filter  = 0;
		TTypedFieldInterface<TShortestPathSet*> * SPSF = 0;
		TTypedFieldInterface<float>* OutputField = 0; 
		TTypedFieldInterface<float>* OutputField2 = 0;
		if(fgbg == 0)
		{
			*g_Log << "Process foreground\n";
			Filter = skel->m_ForegroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			Filter->m_LowerValue = FgThreshold;
			Filter->m_UpperValue = FgThreshold * 2;
			SPSF = skel->m_ForegroundSpSetField.get();
			OutputField = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "FG paths" ) );
			OutputField2 = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "FG paths 2" ) );
			FgField = OutputField2;
		}
		else
		{
			*g_Log << "Process foreground\n";
			Filter = skel->m_BackgroundSurfaceSkeletonField->getLayer()->m_Filter.get();
			Filter->m_LowerValue = BgThreshold;
			Filter->m_UpperValue = BgThreshold * 2;
			SPSF = skel->m_BackgroundSpSetField.get();
			OutputField = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "BG paths" ) );
			OutputField2 = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "BG paths 2" ) );
			BgField = OutputField2;
		}

		OutputField->clear();
	
		for(x=0; x<SPSF->getIndexField()->getMaxIndex(); x++)
		{
			const TShortestPathSet * sps = SPSF->vvaluex(x);
			if( !Filter->test(sps->getMaxLength() )) continue;

			for(y=0; y<sps->m_Paths.size(); y++)
			{
				shared_ptr<TShortestPath> sp = sps->m_Paths[y];
				if(Filter->test(sp->m_Length))
				{
					if( !sp->m_Path )
					{
						sp = skel->Omega->m_DeltaOmega->getShortestPath( sp->m_Begin, sp->m_End );
					}

					if(sp->m_Path)
					{
						float currentpos = - sp->m_Length / 2.0f;
						for(z=1; z<sp->m_Path->size(); z++)
						{
							const unsigned int idx = (*sp->m_Path)[z];
							char weight = 3;
							
							if(z > 0)
							{
								const TCoord3 p = skel->Omega->m_BoundaryIndexField->vidx2coord( (*sp->m_Path)[z-1] );
								const TCoord3 np = skel->Omega->m_BoundaryIndexField->vidx2coord( idx );
								if( np.x == p.x ) weight--;
								if( np.y == p.y ) weight--;
								if( np.z == p.z ) weight--;
								if(weight == 0) continue;
								currentpos += skel->Omega->m_DeltaOmega->WEIGHTS[weight];
							}
							
							const float v = fabs(currentpos);
							if( OutputField->vvaluex( idx ) == 0 || v < OutputField->vvaluex( idx )	) 
								OutputField->wvaluex( idx ) = v;
						}
					}
				}
			}
		}
		OutputField->getLayer()->onFieldChanged();

		{
			OutputField2->clear();
			skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeeds(OutputField, OutputField2);
			OutputField2->getLayer()->onFieldChanged();
			if(fgbg == 0) OutputField2->getLayer()->m_Filter->m_UpperValue = FgThreshold/1.5f;
			else if(fgbg == 1) OutputField2->getLayer()->m_Filter->m_UpperValue = BgThreshold/1.5f;
		}
	}

	// Combine fg and bg
	{
		// Check if bg is empty
		bool BgEmpty = true;
		if(!BgField)
		{
			for(x=0; x<BgField->getMaxIndex(); x++)
			{	
				if(BgField->vvaluex(x) != 0.0f) 
				{
					BgEmpty = false;
					break;
				}
			}
		}

		TTypedFieldInterface<float>* CombinedDistanceField = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "Combined" ) );
		CombinedDistanceField->clear();
		for(x=0; x<FgField->getMaxIndex(); x++)
		{	
			if(!BgEmpty)
			{
				CombinedDistanceField->wvaluex(x) = min( FgField->vvaluex(x), BgField->vvaluex(x) );
			}
			else
			{
				CombinedDistanceField->wvaluex(x) = FgField->vvaluex(x);
			}
		}
		CombinedDistanceField->getLayer()->onFieldChanged();
		if(!BgEmpty)
		{
			CombinedDistanceField->getLayer()->m_Filter->m_UpperValue = min(FgField->getLayer()->m_Filter->m_UpperValue, BgField->getLayer()->m_Filter->m_UpperValue);
		}
		else
		{
			CombinedDistanceField->getLayer()->m_Filter->m_UpperValue = FgField->getLayer()->m_Filter->m_UpperValue;
		}

		TTypedFieldInterface<unsigned int>* Segments = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Clusters") );
		Segments->clear();
		skel->Omega->m_DeltaOmega->findConnectedComponents(CombinedDistanceField->getLayer()->m_Filter.get(), Segments, true);
		Segments->getLayer()->onFieldChanged();
	}
	


}

// ------------------------------------------------------------------------------------------






				 /*
				// Test: for each end, take path to closest edge point that has higher distance than threshold
				
				{	
					TTypedFieldInterface<unsigned int>* ExtraEdges = static_cast<TTypedFieldInterface<unsigned int>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_UINT, skel->Omega->m_BoundaryIndexField, "Extra Edges") );
					ExtraEdges->clear();

					for(set<unsigned int>::iterator it = EdgeEndsSet.begin(); it != EdgeEndsSet.end(); it++)
					{
						unsigned int idx = *it;
						set<unsigned int> SinglePoint;
						SinglePoint.insert( idx );
						TemporaryFloat->clear();
						skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomainFilter(&SinglePoint, Edges->getLayer()->m_Filter.get(), TemporaryFloat);
						for(unsigned int x=0; x<TemporaryFloat->getMaxIndex(); x++)
						{
							if(TemporaryFloat->vvaluex(x) == 0.0f && Edges->vvaluex(x) != 0.0f)
							{
								TemporaryFloat->wvaluex(x) = 5000.0f;
							}
						}

						float Distance;
						TemporaryFloat->getLayer()->m_Filter->m_LowerValue = 50.0f; // *** PARAMETER
						TemporaryFloat->getLayer()->m_Filter->m_UpperValue = 9000.0f;
						unsigned int nidx = skel->Omega->m_DeltaOmega->findNearestWithFilter(idx, Distance, TemporaryFloat->getLayer()->m_Filter.get() ); 
						if(nidx < skel->m_BoundaryIndexField->getMaxIndex())
						{
							// Find shortest path 
							shared_ptr<TShortestPath> sp = skel->Omega->m_DeltaOmega->getShortestPath(idx,nidx);
							for(unsigned int z=0; z<sp->m_Path->size(); z++)
							{
								ExtraEdges->wvaluex( (*sp->m_Path)[z] ) = 1;
							}
						}
					}
					ExtraEdges->getLayer()->onFieldChanged();

					for(unsigned int y=0; y<ExtraEdges->getMaxIndex(); y++)
					{
						if( ExtraEdges->vvaluex(y) != 0.0f )
						{
							Edges->wvaluex( y ) = 0.001f;
						}
					}
				}
				// */

				/*	
				// Test: zie of distance to edge gebruikt kan worden voor alternatief EdgeDistance field
				// Compute distance to seeds on edges
				{
					TTypedFieldInterface<float>* EdgeDistanceFromEnds = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "EdgeDistanceFromEnds" ) );
					EdgeDistanceFromEnds->clear(); 
					skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedsAndDomainFilter(&EdgeEndsSet, Edges->getLayer()->m_Filter.get(), EdgeDistanceFromEnds);
					// Square them
					EdgeDistanceFromEnds->getLayer()->onFieldChanged();
					EdgeDistanceFromEnds->getLayer()->m_Filter->m_LowerValue = 0.01f;

					TTypedFieldInterface<float>* EdgeDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "EdgeDistanceFromEnds distance" ) );
					EdgeDistance->clear(); 
					TInvertFilter InverseFilter(Edges->getLayer()->m_Filter.get());
					skel->Omega->m_DeltaOmega->computeDistanceFieldWithSeedDistancesAndDomainFilter(EdgeDistanceFromEnds, &InverseFilter, EdgeDistance);
					EdgeDistance->getLayer()->onFieldChanged();
				}
				*/


//			}

			/*
			TTypedFieldInterface<float>* EdgeComponentDistance = static_cast<TTypedFieldInterface<float>*>( g_Mediator.getCurrentLayerSet()->newField( TType::TYPE_FLOAT, skel->Omega->m_BoundaryIndexField, "EdgeComponentDistance" ) );
			EdgeComponentDistance->clear();
			
			for(unsigned int y=0; y<Clusters.size(); y++)
			{
				if(Clusters[y].size() == 0) continue;

				skel->Omega->m_DeltaOmega->computeDistancesOnFilterUsingSeed( *Clusters[y].begin(), EdgeComponents->getLayer()->m_Filter.get(), EdgeComponentDistance);
			}
			EdgeComponentDistance->getLayer()->onFieldChanged();
			*/
