#ifndef BOUNDARYSEGMENTATION_OLD_H
#define BOUNDARYSEGMENTATION_OLD_H

#include "abstractaction.h"
#include "shortestpath.h"
#include "utils.h"
#include "abstractfilter.h"

#include <map>
using std::multimap;




class TAction_ForwardBoundarySegmentationUsingNearestNonZero : public TAction
{
public:
	virtual string getName() { return "Forward boundary segmentation using nearest nonzero"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};

class TAction_ForwardBoundarySegmentationUsingNearestNonZeroAndNeighborsFirst : public TAction
{
public:
	virtual string getName() { return "Forward boundary segmentation using nearest nonzero and neighbors first"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};





class TAction_CurvatureUsingReverseTftAndLocalSheets : public TAction
{
public:
	static string getStaticName() { return "Curvature w/ reverse Tft, local sheets, and pruned S-skel segmentation"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};


class TAction_MapSskelSegmUsingFt : public TAction
{
public:
	virtual string getName() { return "A. Map S-skel segm. to boundary using FT"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	TTypedFieldInterface<unsigned int>* mapFt(class TSskelSegmenter * p_Segm, string p_Name);
	void cleanup(TTypedFieldInterface<unsigned int> * p_Field);
	void renumber(TTypedFieldInterface<unsigned int> * p_Field);
	TTypedFieldInterface<unsigned int>* mapFt(TTypedFieldInterface<unsigned int>* p_Segm, const TTypedFieldInterface<TShortestPathSet*>* p_SPSF, string p_Name);
};

class TAction_MapSskelSegmUsingFtAndGeodesics : public TAction
{
public:
	virtual string getName() { return "A. Map S-skel segm. to boundary using FT and geos"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
};



class TAction_DistanceToField : public TAction
{
public:
	TAction_DistanceToField()
		: m_Output(0)
	{}
	static string getStaticName() { return "Distance to field"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static TTypedFieldInterface<float>* computeField(TTypedFieldInterface<TShortestPathSet*> * SPSF, const TFloatFilter * p_Filter, string p_Name, TTypedFieldInterface<unsigned int>* p_ClosestPoint = 0);
	string m_UseNameForOutput;
	TTypedFieldInterface<float>* m_Output;
protected:
	virtual void perform_main();
};


class TAction_NotUsingSskelSegmentation : public TAction
{
public:
	virtual string getName() { return "A. Not using S-skel segm."; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	unsigned int cluster(TTypedFieldInterface<unsigned int>* p_Clusters, bool p_HandleConcavities, bool p_StoreClustering);
	float m_ThresholdCluster;
	float m_Threshold;
	float m_ThresholdNeighbors;

};


class TTSegment
{
public:
	TTSegment(unsigned int p_Index) 
		: m_Cluster(0) 
		, m_Index(p_Index)
	{};
	
	unsigned int m_Index;
	typedef map<TTSegment*, unsigned int> TNeighbors;
	TNeighbors m_Neighbors;

	vector<unsigned int> m_Voxels;
	class TTCluster * m_Cluster;
};

class TTCluster
{
public:
	unsigned int m_Index;
	TTCluster(unsigned int p_Index, TTSegment*s) 
		: m_Index(p_Index) 
	{ 
		m_Segments.insert(s); 
		s->m_Cluster = this; 
	}

	typedef map<TTCluster*, unsigned int> TNeighbors;
	TNeighbors m_Neighbors;
	set<TTSegment*>	m_Segments;
};


class TAction_MergeClusters : public TAction
{
public:
	static string getStaticName() { return "C. Merge clusters"; }
	virtual string getName() { return getStaticName(); }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	typedef map<unsigned int, set<unsigned int> > TForbidden;
	TForbidden * m_Forbidden;
protected:
	virtual void perform_main();
	void computeClusterStats(const TTypedFieldInterface<unsigned int>* Clusters, const TTypedFieldInterface<TVector3>* BoundaryNormals);
	vector<shared_ptr<TTSegment> > m_Segments;
	vector<shared_ptr<TTCluster> > m_Clusters;
	void updateClusterNeighbors(TTCluster * c);
	bool canBeMerged(TTCluster * c, TTCluster * d);
	void printClusterInfo();

};


class TCluster2
{
public:
	TCluster2(unsigned int p_Id, unsigned int p_Voxel)
		: m_Id(p_Id)
	{
		m_Voxels.insert( p_Voxel );
	}
	unsigned int m_Id;
	set<unsigned int> m_Voxels;
	set<unsigned int> m_Forbidden;
};

class TAction_NotUsingSskelSegmentation3 : public TAction
{
public:
	virtual string getName() { return "A. Use distance to seed points (level sets)"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
	static void cleanUp(TTypedFieldInterface<unsigned int> * Clustering, const TTypedFieldInterface<TVector3> * BoundaryNormals, bool p_Output = false);
protected:
	virtual void perform_main();
	TTypedFieldInterface<float>* computeDistanceField(string p_Name, set<unsigned int> * p_Seeds, TTypedFieldInterface<unsigned int> * p_Domain, unsigned int p_DomainIdx);
//	TTypedFieldInterface<unsigned int> * Seeds;
	TTypedFieldInterface<TVector3>* BoundaryNormals;
	TTypedFieldInterface<TIndexedOrigins*>*  m_VoxelNeighborhoods;
	set<TCluster2*> m_Clusters;
	vector<TCluster2*> Id2Cluster;
	bool canBeMerged(TCluster2 * f, TCluster2 * t);
	void determineVoxelNeighborhood(unsigned int p_Voxel, float p_Threshold, TTypedFieldInterface<unsigned int> * p_Seeds);
};



class TAction_NotUsingSskelSegmentation4 : public TAction
{
public:
	virtual string getName() { return "A. Use rho of S-skel boundary"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();

};

class TAction_UsingRhoMapping : public TAction
{
public:
	virtual string getName() { return "A. Use rho mapping"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	TTypedFieldInterface<float>* mapTo(const string p_Name, const TTypedFieldInterface<TShortestPathSet*> * p_SPSF, const TFilter * p_Filter);

};


class TAction_UsingRhoMappingAndShortestPaths : public TAction
{
public:
	virtual string getName() { return "A. Use rho mapping and sps"; }
	virtual string getHelpString() { return ""; }
	virtual bool isAvailable();
protected:
	virtual void perform_main();
	TTypedFieldInterface<float>* mapTo(const string p_Name, const TTypedFieldInterface<TShortestPathSet*> * p_SPSF, const TFilter * p_Filter);

};



#endif

