
#include "stdafx.h"


TCamera::TCamera()
{
	m_Position = TVector3( -10.0f, 0.0f, 0.0f );
	m_Heading = 0.0f;
	m_Pitch = 0.0f;
	calculateDirection();
};





void TCamera::setMatrices()
{
	TVector3 ref = m_Position;
	ref.add(m_Direction);

	gluLookAt( 
		m_Position.x,
		m_Position.y,
		m_Position.z,
		ref.x,
		ref.y,
		ref.z,
		0.0f,
		1.0f,
		0.0f
		);
}




void TCamera::moveForward( float d )
{
	TVector3 v = m_Direction; 
	v.scale(d);
	m_Position.add(v);
};



void TCamera::calculateDirection()
{
	m_Direction.x = cos(m_Pitch) * cos(m_Heading);
	m_Direction.y = sin(m_Pitch);
	m_Direction.z = cos(m_Pitch) * sin(m_Heading);
	m_Direction.normalize();
}



void TCamera::turn( float d )
{
	m_Heading += d;
	if(m_Heading > 2*PI) 
	{
		m_Heading -= 2*PI;
	}
	else if(m_Heading < 0.0f )
	{
		m_Heading += 2*PI;
	}
	calculateDirection();
};


void TCamera::pitch( float d )
{
	m_Pitch += d;
	if(m_Pitch < -0.49f * PI ) m_Pitch = -0.49f * PI ;
	else if(m_Pitch > 0.49f * PI ) m_Pitch = 0.49f * PI ;
	calculateDirection();
};


void TCamera::climb( float d )
{
	m_Position.y += d;
};


void TCamera::panvertical( float d )

{
	TVector3 v = m_Direction;
	v = v.cross( TVector3( 0.0f, 1.0f, 0.0f ) );
	v = v.cross( m_Direction );
	v.normalize();
	v.scale(d);
	m_Position.add(v);
};


void TCamera::panhorizontal( float d )

{
	TVector3 v = m_Direction;
	v = v.cross( TVector3( 0.0f, 1.0f, 0.0f ) );
	v.scale(d);
	m_Position.add(v);
};


void TCamera::setPosition(float x,float y,float z)
{
	m_Position.x = x;
	m_Position.y = y;
	m_Position.z = z;
}

void TCamera::setHeading(float v)
{
	m_Heading = v;
	calculateDirection();
}


void TCamera::setPitch(float v)
{
	m_Pitch = v;
	calculateDirection();
}






