#ifndef CAMERA2_H
#define CAMERA2_H

#include "stdafx.h"
#include "Geometry.h"
#include <iostream>
#include <fstream>

class TCamera
{
public:
	enum PROJECTIONMODE { PROJECTIONMODE_NONE, PROJECTIONMODE_PERSPECTIVE, PROJECTIONMODE_ORTHOGONAL };
	enum CAMERATYPE { CAMERATYPE_NONE, CAMERATYPE_OBSERVING, CAMERATYPE_ROAMING };

	TCamera() 
		: m_ProjectionMode(PROJECTIONMODE_PERSPECTIVE)
	{}
	virtual void setMatrices() = 0;
	virtual void move(float x, float y, bool p_Left, bool p_Middle, bool p_Right) = 0;
	virtual void snapToAxis(int p_Axis) = 0;
	virtual void setProjectionMatrix(int w,int h) = 0;
	virtual void reset() = 0;
	virtual TVector3 getPos() = 0;
	virtual TVector3 getLookAt() = 0;

	inline void setProjectionMode(PROJECTIONMODE p_Mode) { m_ProjectionMode = p_Mode; }
	inline PROJECTIONMODE getProjectionMode() const { return m_ProjectionMode; }
	virtual CAMERATYPE getCameraType() const = 0;

protected:
	PROJECTIONMODE m_ProjectionMode;
};


class TObservingCamera : public TCamera
{
public:
	TObservingCamera(float p_InitialHeading, float p_InitialPitch, float p_InitialZoom)
		: m_InitialHeading(p_InitialHeading)
		, m_InitialPitch(p_InitialPitch)
		, m_InitialZoom(p_InitialZoom)
		, m_Middle(TPoint3(1,1,1))
	{
		reset();
	}

	virtual void setMatrices();
	virtual void move(float x, float y, bool p_Left, bool p_Middle, bool p_Right);
	virtual void snapToAxis(int p_Axis);
	virtual void setProjectionMatrix(int w,int h);
	virtual void reset();
	virtual CAMERATYPE getCameraType() const { return TCamera::CAMERATYPE_OBSERVING; }
	virtual TVector3 getPos();
	virtual TVector3 getLookAt() { return TVector3(0,0,0); };
	
	void setMiddle(TPoint3 & p_Middle) { m_Middle = p_Middle; } 
	const TPoint3 & getMiddle() { return m_Middle; }
protected:
	float m_Heading;
	float m_Pitch;		
	TPoint3 m_Middle;
	float m_Zoom;

	float m_InitialHeading;
	float m_InitialPitch;
	float m_InitialZoom;
};



class TRoamingCamera : public TCamera
{
public:
	TRoamingCamera(TPoint3 p_InitialPosition, float p_InitialHeading, float p_InitialPitch);

	virtual void setMatrices();
	virtual void move(float x, float y, bool p_Left, bool p_Middle, bool p_Right);
	virtual void snapToAxis(int p_Axis);
	void setPosition(float x,float y,float z);
	void setHeading(float v);
	void setPitch(float v);
	virtual void setProjectionMatrix(int w,int h);
	virtual void reset();
	virtual CAMERATYPE getCameraType() const { return TCamera::CAMERATYPE_ROAMING; }
	virtual TVector3 getPos();
	virtual TVector3 getLookAt();

	virtual void writeToStream(std::ofstream * s) const;
	static TRoamingCamera * readFromStream(std::ifstream * s);

protected:
	float m_Heading;
	float m_Pitch;		
	TPoint3 m_Position;
	TVector3 m_Direction;
	float m_Zoom;
	TPoint3 m_InitialPosition;
	float m_InitialHeading;
	float m_InitialPitch;

	void calculateDirection();
	TRoamingCamera() {};
};

#endif
