

#include "cdt.h"


/*

Old version, but still used for FMM field

*/

#include "field.h"


void TCdt::stageInit()
{
	m_FmmDistance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );

	// Fields needed for FMM algorithm
	m_FlagField.reset( TFlagField3::construct(m_Image, m_FmmDistance.get(), 0) );
	m_OrigsIndexed = new FIELD<std::multimap<float,int> >(m_FlagField->getMaxX(), m_FlagField->getMaxY() );
	m_Pointers = new FIELD<std::multimap<float,TCoord2>::iterator>(m_FlagField->getMaxX(), m_FlagField->getMaxY() );
}

void TCdt::stageMain()
{
	if(m_AlreadyPerformed) throw string("Edt already performed"); 

	// Fill m_From & m_OrigsIndexed
	{
		const int M = m_FlagField->dimX();
		const int N = m_FlagField->dimY();
		for(int i=0;i<M;i++)
		{
			for(int j=0;j<N;j++)
			{
				if(m_FlagField->value(i,j) == TFlagField3::NARROW_BAND)
				{
					m_Pointers->value(i,j) = m_Narrowband.insert( 
						std::multimap<float,TCoord2>::value_type(m_FmmDistance->value(i,j), TCoord2(i,j)) 
						);
					
					m_From.push_back( TCoord2(i,j) );
				} 
			}
		}
	}

	// Add origins for narrowband points
	{
		for(int i=0; i<m_From.size(); i++)
		{
			const TCoord2 & ci = m_From[i];
			for(int j=0; j<m_From.size(); j++)
			{
				const TCoord2 & cj = m_From[j];
				const float d = ci.distance(cj);
				if(d <= m_Tolerance)
				{
					m_OrigsIndexed->value(ci.i,ci.j).insert( std::multimap<float,int>::value_type(d,j) );
				}
			}
		}
	}

	// Perform FMM
	m_Iterations = 0;
	while(diffuse())
	{
		m_Iterations++;
	}


	m_AlreadyPerformed = true;
}

void TCdt::stageEnd()
{
	// Create CDT distances and origin fields
	m_CdtDistance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	m_Origins.reset( new TOrigSetField2( m_Image->getMaxX(), m_Image->getMaxY()) );
	for(int i=0;i<m_OrigsIndexed->dimX();i++)
	{
		for(int j=0;j<m_OrigsIndexed->dimY();j++)
		{
			// Assign m_CdtDistance
			if(m_OrigsIndexed->value(i,j).size() > 0)
			{
				m_CdtDistance->value(i,j) = m_From[m_OrigsIndexed->value(i,j).begin()->second].distance(TCoord2(i,j));
			}
			else
			{
				m_CdtDistance->value(i,j) = -1;
			}

			// Assign m_Origins
			std::multimap<float,int>::iterator it;
			for(it = m_OrigsIndexed->value(i,j).begin(); it != m_OrigsIndexed->value(i,j).end(); it++)
			{
				const TCoord2 & c = m_From[it->second];
				const float v = m_From[it->second].distance(TCoord2(i,j));
				m_Origins->value(i,j).insert( TOrigSet2::value_type(v, TCoord2(c.i, c.j) ) );
			}
		}
	}

	delete m_OrigsIndexed;
	delete m_Pointers;
}


bool TCdt::diffuse()
{
    static NewValue newp[20]; 

    //*** 1. FIND MIN-POINT IN NARROWBAND WITH LOWEST VALUE
    int min_i,min_j;
    std::multimap<float,TCoord2>::iterator it=m_Narrowband.begin();
    if (it==m_Narrowband.end()) return 0;

    min_i  = (*it).second.i;
    min_j  = (*it).second.j;
    m_Narrowband.erase(it);					//erase point from 'm_Narrowband', since we'll make it alive in step 2

    //*** 2. MAKE MIN-POINT ALIVE
    m_FlagField->value(min_i,min_j) = TFlagField3::KNOWN;		

	// Dennie: disabled
    //if (m_FmmDistance->value(min_i,min_j)>=maxf) return 1;		//stop evolution if we reached the user-prescribed threshold
  

    //*** 3. FIND ALL ITS STILL-TO-BE-UPDATED NEIGHBOURS
    TCoord2 nbs[4]; 
	int nn = 0;
    tag_nbs(min_i-1,min_j,min_i,min_j,nbs,nn);
    tag_nbs(min_i+1,min_j,min_i,min_j,nbs,nn);
    tag_nbs(min_i,min_j-1,min_i,min_j,nbs,nn);
    tag_nbs(min_i,min_j+1,min_i,min_j,nbs,nn);


	// Dennie: no more FAR_AWAY or TRIAL-neighbors (?) of point (min_i,min_j) found,
    if (!nn) 						//no more alive-neighbous of point (min_i,min_j) found,
    { 							//so it should be an extremum point...
		m_FlagField->value(min_i,min_j) = TFlagField3::EXTREMUM;
        m_ExtremumCount++;
		return 1;	
    }

    //*** 4. UPDATE VALUES OF NEIGHBOURS OF MIN-POINT
    NewValue* nnewp = newp;				//start updating neighbours. Their new values will be saved
    for(nn--;nn>=0;nn--)				//in nnewp[] and pasted back in 'f' at the update end.
    {
		int i = nbs[nn].i;
		int j = nbs[nn].j;

		float vi_1j = m_FmmDistance->value(i-1,j),     vijx1 = m_FmmDistance->value(i,j+1);
		float vix1j = m_FmmDistance->value(i+1,j),     vij_1 = m_FmmDistance->value(i,j-1);
		int   fi_1j = m_FlagField->value(i-1,j), fijx1 = m_FlagField->value(i,j+1);
		int   fix1j = m_FlagField->value(i+1,j), fij_1 = m_FlagField->value(i,j-1);

		float sol = INFINITY; 
		solve(fi_1j,fij_1,vi_1j,vij_1,sol);
		solve(fix1j,fij_1,vix1j,vij_1,sol);
		solve(fi_1j,fijx1,vi_1j,vijx1,sol); 
		solve(fix1j,fijx1,vix1j,vijx1,sol); 

		// Dennie: sol is minimum afstand
		if (sol < INFINITY/2) 
		{ 
			nnewp->i = i; 
			nnewp->j = j; 
			// Todo: Dennie: vervang FMM solution door echte afstand
			// Let op: punt (i,j) is punt met minimale afstand volgens solve(), dus op basis van FMM afstand
			nnewp->value = sol; // original

			nnewp++; 
		}
    }

    //***5. Write updated values back in field.
    for(nnewp--;nnewp>=newp;nnewp--)				//for all updated neighbours:
    {
       m_Narrowband.erase(m_Pointers->value(nnewp->i,nnewp->j));		//remove the neighbour's entry from the sorted m_Narrowband...
       std::multimap<float,TCoord2>::value_type v(nnewp->value,TCoord2(nnewp->i,nnewp->j));
       m_Pointers->value(nnewp->i,nnewp->j) = m_Narrowband.insert(v);		//...and insert it back since its field-value changed		
       m_FmmDistance->value(nnewp->i,nnewp->j) = nnewp->value;		//update the field too
   }
   return 1;

}

void TCdt::solve(int fi_1j,int fij_1,float vi_1j,float vij_1,float& sol)
{
	float ss,d,r;

	if (fi_1j == TFlagField3::KNOWN || fi_1j == TFlagField3::EXTREMUM)
	  if (fij_1 == TFlagField3::KNOWN || fij_1 == TFlagField3::EXTREMUM)	//sol determined by two points: solve order-2 equation
	  {
//	     d = 2 - SQR(vi_1j-vij_1);
	     d = 2 - (vi_1j-vij_1)*(vi_1j-vij_1);
	     if (d>=0)
	     {	
	       r   = sqrt(d);
	       ss  = ((vi_1j+vij_1) - r)/2; 
	       if (ss >= vi_1j && ss >= vij_1) sol = min(sol,ss); 
	       else
	       {
	          ss += r;
	          if (ss >= vi_1j && ss >= vij_1) sol = min(sol,ss); 
	       }
	     }
	     else 
		 { 
			 throw string( wxString::Format("solve() failure, vi_1j: %f, vij_1: %f", vi_1j, vij_1) );
			 // Dennie: disable
			 //negd++; 
			 return; 
		 }  					//should never happen, but still...
          }
	  else sol = min(sol,1 + vi_1j);  			 	//sol determined by one point: solve order-1 equation
        else        
          if (fij_1 == TFlagField3::KNOWN || fij_1 == TFlagField3::EXTREMUM) 
             sol = min(sol,1 + vij_1);  		 		//sol determined by one point: solve order-1 equation
}


//Gathers all neighbours (min_i,min_j) of (i,j) are to be updated because updating (i,j).
void TCdt::tag_nbs(int min_i,int min_j, int i,int j,TCoord2* nbs, int& nn)
{

	// For each a \in N^TU
    if (min_i>=0 && min_i<m_FlagField->dimX() && min_j>=0 && min_j<m_FlagField->dimY() && 
       !m_FlagField->known(min_i,min_j,0) 
	// && !m_FlagField->extremum(min_i,min_j,0)
	)
	// For each a \in N^U
	//if (min_i>=0 && min_i<m_FlagField->dimX() && min_j>=0 && min_j<m_FlagField->dimY() && 
    //   m_FlagField->unknown(min_i,min_j,0) && !m_FlagField->extremum(min_i,min_j,0))
    {
       nbs[nn].i = min_i; 
	   nbs[nn].j = min_j; 
	   nn++;
       if (m_FlagField->value(min_i,min_j)!=TFlagField3::NARROW_BAND)
		   // Voeg (min_i,min_j) toe aan narrowband, i,j hebben geen betekenis, maar WEL bij de overerfde add_to_narrowband
          add_to_narrowband(min_i,min_j,i,j);			//Here we do our gathering stuff
    }
}


void TCdt::add_to_narrowband(int i,int j,int active_i,int active_j)
{
	m_FlagField->value(i,j) = TFlagField3::NARROW_BAND;

	// Add new point to narrowbad
	std::multimap<float,TCoord2>::value_type v(m_FmmDistance->value(i,j),TCoord2(i,j));
	m_Pointers->value(i,j) = m_Narrowband.insert(v);



    static std::multimap<float,int> om;			//candidates for origins of (i,j)
    om.erase(om.begin(),om.end());			//we declare this static since it's faster


	float m=INFINITY,dmin=INFINITY,M=-m,INFINITY_2 = INFINITY/2; 
	float cv=0; int cc=0,pt_i,pt_j;		        //    

	// Dennie:
	// Vindt alle neighbors van (i,j) en vul 'om' met de origins van deze buren. 
	for(int ii=i-1;ii<=i+1;ii++) // original
	{
		for(int jj=j-1;jj<=j+1;jj++)
		{
			if (m_NeighborCount == 4 && i!=ii && j!=jj) continue; // only 4-neighbors

			// Dennie: proberen
//			if (! m_FlagField->unknown(ii,jj) && count->value(ii,jj)<INFINITY_2)
			const char Flag = m_FlagField->unknown(ii,jj);
			if (! Flag)
			{						
				std::multimap<float,int>& o = m_OrigsIndexed->value(ii,jj);	//All origins of neighbor (ii,jj)
				for(std::multimap<float,int>::iterator oi=o.begin();oi!=o.end();oi++)
				{
					int   O = (*oi).second;
					TCoord2 c = m_From[O];				
					
					//Find where neighbor came from on the initial boundary
					int   d = (c.i-i)*(c.i-i)+(c.j-j)*(c.j-j);	//Find distance from current point (i,j) to its potential origin

					bool go=true;					//Collect (i,j)'s potential origins & their distances
					for(std::multimap<float,int>::iterator it=om.begin();go && it!=om.end();it++)
						if ((*it).second==O) go=false;			//Take care we don't insert same origin twice
					
					// Dennie: vervangen door eigen distance berekening	
					//if (go)
					//	om.insert(std::multimap<float,int>::value_type(sqrt(d),O)); // original

					if(go) 
						om.insert( std::multimap<float,int>::value_type(m_From[O].distance(TCoord2(i,j)), O) );
				}
			}
		}
	}


	// Dennie:
	// Stop alle punten van 'om' op kortste afstand in de origins van (i,j)

	//If we compute VDT, update origins of (i,j)
	//These are simply all points in our potential-list om[]
	//with smallest distance from the crt-point, using dist_tol.
	//Since om[] is sorted on distance, this means its first elements
	//until we reach (*om.begin()).first + dist_tol
	assert(om.size() != 0);
	dmin = (*om.begin()).first + m_Tolerance;		
	pt_i = m_From[(*om.begin()).second].i;		
	pt_j = m_From[(*om.begin()).second].j;		
	std::multimap<float,int>& oa = m_OrigsIndexed->value(i,j); 
	// Dennie: < vervangen door <= zodat threshold op 0 gezet kan worden.
	// for(std::multimap<float,int>::iterator oi=om.begin();oi!=om.end() && (*oi).first<dmin;oi++) // original
	for(std::multimap<float,int>::iterator oi=om.begin();oi!=om.end() && (*oi).first<=dmin;oi++)
		oa.insert(*oi); 
}



string TCdt::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	string r = wxString::Format("\\fcdt{}%i $\\epsilon%s$", m_NeighborCount, sTolerance.c_str());
	return r;
}



string TCdt::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("FCDT%i e%s", m_NeighborCount, sTolerance.c_str());
	return r;
}


void TCdt::deleteFields()
{
	//m_FlagField.reset();
	//m_FmmDistance.reset();
	//m_CdtDistance.reset();
	//m_Origins.reset();
}















string TFmm::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }

	string r = wxString::Format("\fmm{}", m_NeighborCount, sTolerance.c_str());
	return r;
}



string TFmm::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("FMM", m_NeighborCount, sTolerance.c_str());
	return r;
}

int TFmm::getAllocatedMemory() const
{
	int size = 0;
	size += m_FmmDistance->getMaxX() * m_FmmDistance->getMaxY() * sizeof(float);
	size += m_FlagField->getMaxX() * m_FlagField->getMaxY() * sizeof(unsigned char);
	
	for(int j=0; j<m_Origins->getMaxY(); j++)
		for(int i=0; i<m_Origins->getMaxX(); i++)
		{
			size += m_Origins->value(i,j).size();
		}

	return size;
}






