
#ifndef CDT_H
#define CDT_H

#include "dt.h"
#include "field3.h"

class TCdt : public TDt
{
public:
	TCdt(const TFloatField3 * p_Image, float p_Tolerance, int p_NeighborCount)
		: TDt()
		, m_Image(p_Image)
		, m_Tolerance(p_Tolerance)
		, m_NeighborCount(p_NeighborCount) 
	{
	}

	virtual DT_TYPE getDtType() const { return DT_FCDT; }
	virtual int getNeighborCount() const { return m_NeighborCount; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();

	virtual shared_ptr<TFloatField3> getDistance() const { return m_CdtDistance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { return m_Origins; }
	virtual string getLatexName() const;
	virtual string getShortName() const;
	virtual void deleteFields();

protected:
	// Types
	struct NewValue {  int i; int j; float value; }; 

	// Data
	float m_Tolerance;
	int m_NeighborCount;
	const TFloatField3 * m_Image;
	shared_ptr<class TFlagField3> m_FlagField;
	shared_ptr<class TFloatField3> m_FmmDistance;
	shared_ptr<class TFloatField3> m_CdtDistance;
	shared_ptr<class TOrigSetField2> m_Origins;
    std::multimap<float,TCoord2> m_Narrowband;	  	// was: map, Narrowband points sorted in ascending distance order
	int m_ExtremumCount;		// was: nextr, Number of extremum points detected in diffuse()
	FIELD<std::multimap<float,TCoord2>::iterator> * m_Pointers; // was: ptrs
	vector<TCoord2> m_From;					//Given a boundary-label, tells where, on initial boundary, it came from
	FIELD<std::multimap<float,int> > * m_OrigsIndexed;		//Origin set
	int m_Iterations;

	// Methods
	bool diffuse();
	void solve(int fi_1j,int fij_1,float vi_1j,float vij_1,float& sol);
	void add_to_narrowband(int i,int j,int active_i,int active_j);
	void tag_nbs(int,int,int,int,TCoord2*,int&);

};


class TFmm : public TCdt
{
public:
	TFmm(const TFloatField3 * p_Image, float p_Tolerance, int p_NeighborCount)
		: TCdt(p_Image, p_Tolerance, p_NeighborCount)
	{
	}

	virtual DT_TYPE getDtType() const { return TDt::DT_FMM; }

	virtual shared_ptr<TFloatField3> getDistance() const { return m_FmmDistance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { return m_Origins; } // although FMM does not have origins, we return the CDT origins because they are used to determine the object/non-object pixels
	virtual string getLatexName() const;
	virtual string getShortName() const;
	virtual int getAllocatedMemory() const;
};

#endif
