#include "cdt2.h"


/*

Debug version

*/

#include "forward.h"
#include "field.h"

void TCdt2::stageInit()
{
	m_FmmDistance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );

	// Fields needed for FMM algorithm
	m_FlagField.reset( TFlagField3::constructFrom2DFloatField(m_Image, m_FmmDistance.get(), 0) );
	//m_OrigsIndexed = new FIELD<std::multimap<float,int> >(m_FlagField->getMaxX(), m_FlagField->getMaxY() );
	m_Origins.reset( new TOrigSetField2( m_Image->getMaxX(), m_Image->getMaxY()) );
	m_Pointers = new FIELD<TNarrowBand::iterator>(m_FlagField->getMaxX(), m_FlagField->getMaxY() );

	m_Tolerance2 = (int)(m_Tolerance*m_Tolerance+0.5f); 

	// Debug
	m_PropagationP.reset( new TOrigSetField2( m_Image->getMaxX(), m_Image->getMaxY()) );
	m_PropagationA.reset( new TOrigSetField2( m_Image->getMaxX(), m_Image->getMaxY()) );
}

void TCdt2::stageMain()
{
	vector<TCoord2> N; N.reserve(8);
	{
		for(int i=0; i<m_FlagField->getMaxX(); i++)
		{
			for(int j=0; j<m_FlagField->getMaxY(); j++)
			{
				if(m_FlagField->narrowband(i,j))
				{
					m_FmmDistance->value(i,j) = 0;
					m_Pointers->value(i,j) = V.insert( 
						TNarrowBand::value_type(m_FmmDistance->value(i,j), TCoord2(i,j)) 
						);

					TOrigSet2 & os = m_Origins->value(i,j);
					os.insert( TOrigSet2::value_type(0, TCoord2(i,j)) );

					const TCoord2 c(i,j); 
					N.clear();
					getNeighbors(c, m_NeighborCount, N);
					for(int k=0; k<N.size(); k++)
					{
						const TCoord2 & n = N[k];;
						if( ! m_FlagField->narrowband(n.x,n.y) ) continue;
						const ARITHTYPE d = c.ARITHDISTANCE(n);
						if(d>ARITHTOLERANCE) continue;
						os.insert( TOrigSet2::value_type(d, n) );		
					}
				}
				else if(m_FlagField->unknown(i,j))
				{
					m_FmmDistance->value(i,j) = INFINITY;
				}
				else if(m_FlagField->known(i,j))
				{
					m_FmmDistance->value(i,j) = -1;
				}
			}
		}
	}

	// Do iteration
	TCoord2 a;
	TOrigSet2::const_iterator it,jt;
	TOrigSet2::iterator kt;
	TOrigSet2 NewOrigins;
	vector<TCoord2> Na; Na.reserve(8);
	vector<TCoord2> Np; Np.reserve(8);

	// Debug
	ofstream str( wxString::Format("_ftft%s.txt", m_PropagateExact ? "E" : "") );
	int iter = 0;

	// Perform FMM
	while(V.size() != 0)
	{
		// Debug
		iter++;

		// Let p = argmin_q D(q)
		const TCoord2 p = V.begin()->second;
		m_FlagField->value(p.x,p.y) = TFlagField3::KNOWN;
		// Debug
		str << wxString::Format("=== p: %i,%i, %.8f\n", p.x,p.y,V.begin()->first).c_str();
		m_PropagationP->value(p.x, p.y).insert( TOrigSet2::value_type(iter, TCoord2(0,0) ) );

		V.erase(V.begin());


		getNeighbors(p, 4, Np);
		for(int k=0; k<Np.size(); k++)
		{
			const TCoord2 & a = Np[k];
			if( m_FlagField->known(a.x,a.y)) continue; // for each a \in N^{U,T}(p)

			// Construct conservative set C 
			TOrigSet2 & C = m_Origins->value(a.x, a.y);
			{

				//C.clear();
				getNeighbors(a, m_NeighborCount, Na);
				Na.push_back(a);
				for(int j=0; j<Na.size(); j++)
				{
					const TCoord2 & b = Na[j];
					if( m_FlagField->unknown(b.x,b.y)  ) continue; // for each b \in N^{T,K}(a)
					//if( ! m_FlagField->known(b.x,b.y)  ) continue; // for each b \in N^{K}(a)


					// Insert S(b) into C
					{
						const TOrigSet2 & Sb = m_Origins->value(b.x,b.y);
						for(it = Sb.begin(); it != Sb.end(); it++)
						{
							// Find out if 'it' occurs in C (smarter than 1)
							const ARITHTYPE d = a.ARITHDISTANCE(it->second);
							bool found = false;
							for(kt = C.lower_bound(d); kt != C.end(); kt++)
							{
								if(kt->first > d) break;
								if(kt->second == it->second) { found = true; break; }
							}
							if(!found) C.insert( TOrigSet2::value_type(d, it->second) );
						}
					}
				}
			}
 
			// Prune C: remove all origins at larger distance than d_min + threshold
			const ARITHTYPE d_min = C.begin()->first;
#ifdef FLOAT_ARITHMETIC
			kt = C.upper_bound(d_min + m_Tolerance);
#else
			const float d_min_root = sqrtf(d_min);
			kt = C.upper_bound(d_min + 2*m_Tolerance*d_min_root + m_Tolerance2);
#endif
			C.erase(kt,C.end());
			//m_Origins->value(a.x,a.y) = C;


			// Debug 
			bool different = false;			
	
			// Compute D^fmm 
			float newd = INFINITY; 
			//float newd = m_FmmDistance->value(a.x,a.y);
			if(! m_PropagateExact)
			{
				const float vi_1j = m_FmmDistance->value(a.i-1,a.j);
				const float vijx1 = m_FmmDistance->value(a.i,a.j+1);
				const float vix1j = m_FmmDistance->value(a.i+1,a.j);
				const float vij_1 = m_FmmDistance->value(a.i,a.j-1);
				const int fi_1j = m_FlagField->value(a.i-1,a.j);
				const int fijx1 = m_FlagField->value(a.i,a.j+1);
				const int fix1j = m_FlagField->value(a.i+1,a.j);
				const int fij_1 = m_FlagField->value(a.i,a.j-1);

				solve(fi_1j,fij_1,vi_1j,vij_1,newd);
				solve(fix1j,fij_1,vix1j,vij_1,newd);
				solve(fi_1j,fijx1,vi_1j,vijx1,newd); 
				solve(fix1j,fijx1,vix1j,vijx1,newd); 

				// Debug
				different = m_FmmDistance->value(a.x,a.y) != newd;
				m_FmmDistance->value(a.x,a.y) = newd;
			}
			else
			{
				newd = a.distance( m_Origins->value(a.x,a.y).begin()->second );
				different = m_FmmDistance->value(a.x,a.y) != newd;
				m_FmmDistance->value(a.x,a.y) = newd;
			}
			
			// Debug
			str << wxString::Format("a: %i,%i, %.8f\n", a.x,a.y, newd).c_str();
			m_PropagationA->value(a.x, a.y).insert( TOrigSet2::value_type(iter, TCoord2(0,0) ) );



			// Add 'a' to narrowband
			if( m_FlagField->unknown(a.x,a.y) ) 
			{
				m_FlagField->value(a.x,a.y) = TFlagField3::NARROW_BAND;
				m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(newd, a) );
			}
			else if( m_FlagField->narrowband(a.x,a.y) )
			{
				if(different) 
				{	
					V.erase( m_Pointers->value(a.x,a.y) );
					m_Pointers->value(a.x,a.y) = V.insert( TNarrowBand::value_type(newd, a) );
				}
			}
		}
	} // end while

}

void TCdt2::stageEnd()
{
	// Create CDT distances and origin fields
	m_CdtDistance.reset( new TFloatField3( m_Image->getMaxX(), m_Image->getMaxY(), m_Image->getMaxZ()) );
	for(int i=0;i<m_Origins->dimX();i++)
	{
		for(int j=0;j<m_Origins->dimY();j++)
		{
			m_CdtDistance->value(i,j) = (m_Origins->value(i,j).size())? m_Origins->value(i,j).begin()->second.distance(TCoord2(i,j)) : -1; 
		}
	}

	delete m_Pointers;
}




void TCdt2::solve(int fi_1j,int fij_1,float vi_1j,float vij_1,float& sol)
{
	float ss,d,r;

	if (fi_1j == TFlagField3::KNOWN )
	  if (fij_1 == TFlagField3::KNOWN )	//sol determined by two points: solve order-2 equation
	  {
	     d = 2 - (vi_1j-vij_1)*(vi_1j-vij_1);
	     if (d>=0)
	     {	
	       r   = sqrt(d);
	       ss  = ((vi_1j+vij_1) - r)/2; 
	       if (ss >= vi_1j && ss >= vij_1) sol = min(sol,ss); 
	       else
	       {
	          ss += r;
	          if (ss >= vi_1j && ss >= vij_1) sol = min(sol,ss); 
	       }
	     }
	     else 
		 { 
			 throw string( wxString::Format("solve() failure, vi_1j: %f, vij_1: %f", vi_1j, vij_1) );
			 return; 
		 }  					//should never happen, but still...
          }
	  else sol = min(sol,1 + vi_1j);  			 	//sol determined by one point: solve order-1 equation
        else        
          if (fij_1 == TFlagField3::KNOWN ) 
             sol = min(sol,1 + vij_1);  		 		//sol determined by one point: solve order-1 equation
}



string TCdt2::getLatexName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "\\frac{1}{2}\\sqrt{2}"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "\\sqrt{2}"; }


	string r = wxString::Format("\\fcdt{}%s|oud|%i $\\epsilon%s$", m_PropagateExact?"E":"", m_NeighborCount, sTolerance.c_str());
	return r;
}



string TCdt2::getShortName() const
{
	string sTolerance = "?";
	if(m_Tolerance <= 0.01f) { sTolerance = "0"; }
	else if(fabs(m_Tolerance-1.0f) <= 0.01f) { sTolerance = "1"; }
	else if(fabs(m_Tolerance-sqrt(2.0f)/2.0f) <= 0.01f) { sTolerance = "0.71"; }
	else if(fabs(m_Tolerance-sqrt(2.0f) <= 0.01f)) { sTolerance = "1.41"; }

	string r = wxString::Format("FCDT2%s|de|%i e%s", m_PropagateExact?"E":"", m_NeighborCount, sTolerance.c_str());
	return r;
}


void TCdt2::deleteFields()
{
	//m_FlagField.reset();
	//m_FmmDistance.reset();
	//m_CdtDistance.reset();
	//m_Origins.reset();
}















