
#ifndef CDT2_H
#define CDT2_H

#include "dt.h"

class TCdt2 : public TDt
{
public:
	TCdt2(const TFloatField3 * p_Image, float p_Tolerance, int p_NeighborCount)
		: TDt()
		, m_Image(p_Image)
		, m_Tolerance(p_Tolerance)
		, m_NeighborCount(p_NeighborCount) 
		, m_PropagateExact(false)
	{
	}

	virtual DT_TYPE getDtType() const { return DT_FCDT; }
	virtual int getNeighborCount() const { return m_NeighborCount; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();

	virtual shared_ptr<TFloatField3> getDistance() const { return m_CdtDistance; };
	virtual shared_ptr<TOrigSetField2> getOrigins() const { return m_Origins; }
	virtual string getLatexName() const;
	virtual string getShortName() const;
	virtual void deleteFields();

	bool m_PropagateExact;

	// Debug
	shared_ptr<TOrigSetField2> m_PropagationP;
	shared_ptr<TOrigSetField2> m_PropagationA;

protected:
	// Data
	float m_Tolerance;
	int m_Tolerance2;
	int m_NeighborCount;
	const TFloatField3 * m_Image;
	shared_ptr<TFlagField3> m_FlagField;
	shared_ptr<TFloatField3> m_FmmDistance;
	shared_ptr<TFloatField3> m_CdtDistance;
	shared_ptr<TOrigSetField2> m_Origins;
	FIELD<std::multimap<float,TCoord2>::iterator> * m_Pointers; // was: ptrs

	typedef std::multimap<float,TCoord2> TNarrowBand;
	TNarrowBand V;

//	int m_ExtremumCount;		// was: nextr, Number of extremum points detected in diffuse()
//	FIELD<std::multimap<float,TCoord2>::iterator> * m_Pointers; // was: ptrs
//	vector<TCoord2> m_From;					//Given a boundary-label, tells where, on initial boundary, it came from
//	FIELD<std::multimap<float,int> > * m_OrigsIndexed;		//Origin set
//	int m_Iterations;

	// Methods
//	bool diffuse();
	void solve(int fi_1j,int fij_1,float vi_1j,float vij_1,float& sol);
//	void add_to_narrowband(int i,int j,int active_i,int active_j);
//	void tag_nbs(int,int,int,int,TCoord2*,int&);

};

#endif
