
#ifndef CDT3_H
#define CDT3_H

#include "dt.h"
#include "field3.h"
// typedef FIELD<std::multimap<float,TCoord2> > TOrigSetField2;




class TCdt3 : public TDt
{
public:
	TCdt3(const class TFloatField3 * p_Image, float p_Tolerance, int p_NeighborCount)
		: m_Image(p_Image)
		, m_Tolerance(p_Tolerance)
		, m_NeighborCount(p_NeighborCount) 
		, m_PropagateExact(true)
	{
	}

	virtual DT_TYPE getDtType() const { return DT_FCDT; }
	virtual int getNeighborCount() const { return m_NeighborCount; }
	virtual float getTolerance() const { return m_Tolerance; }

	virtual void stageInit();
	virtual void stageMain();
	virtual void stageEnd();

	virtual shared_ptr<class TFloatField3> getDistance() const { return m_CdtDistance; };
	virtual shared_ptr<class TOrigSetField2> getOrigins() const { return m_Origins; }
	virtual string getLatexName() const;
	virtual string getShortName() const;

	bool m_PropagateExact;

protected:
	// Data
	float m_Tolerance;
	int m_Tolerance2;
	int m_NeighborCount;
	const TFloatField3 * m_Image;
	shared_ptr<class TFlagField3> m_FlagField;
	shared_ptr<TFloatField3> m_FmmDistance;
	shared_ptr<TFloatField3> m_CdtDistance;
	shared_ptr<TOrigSetField2> m_Origins;
	FIELD<std::multimap<float,TCoord2>::iterator> * m_Pointers; // was: ptrs
	vector<TCoord2> m_From;					//Given a boundary-label, tells where, on initial boundary, it came from

	typedef std::multimap<float,TCoord2> TNarrowBand;
	TNarrowBand V;

	// Methods
	void solve(int fi_1j,int fij_1,float vi_1j,float vij_1,float& sol);

};

#endif
