#ifndef COLORMAP_H
#define COLORMAP_H

#include "stdafx.h"
#include <memory>
using std::shared_ptr;
#include <string>
using std::string;

#include "abstractmeasure.h"

#include "wx/panel.h"

class TColorMap
{
public:
	TColorMap(float p_Lower = 0, float p_Upper = 0);
	virtual ~TColorMap() {};

	virtual void getColor(float p_Value, class TColor3 * c) const = 0;
	float m_Lower;
	float m_Upper;
protected:
	float interpolate(const float &v0, const float &v1, const float &t ) const;
	void hlsToRgb( float H,  float L,  float S, TColor3 * col ) const;
	float hlsValue(float var1, float var2, float hue ) const;
};


class TNormalizedColorMap : public virtual TColorMap
{
public:
	TNormalizedColorMap(float p_Lower, float p_Upper)
		: TColorMap(p_Lower, p_Upper)
		, m_Saturation(1.0f)
	{};

	virtual void getColor(float p_Value, class TColor3 * c) const;
	float m_Saturation;
protected:
	TNormalizedColorMap() {};

};



class TMonochromeColorMap : public virtual TColorMap
{
public:
	TMonochromeColorMap(float p_Lower, float p_Upper)
		: TColorMap(p_Lower, p_Upper)
	{
	}
	
	virtual void getColor(float p_Value, class TColor3 * c) const;

protected:
	TMonochromeColorMap() {};
};

class TInverseMonochromeColorMap : public virtual TColorMap
{
public:
	virtual void getColor(float p_Value, class TColor3 * c) const;
};

class THeatMap : public virtual TColorMap
{
public:
	virtual void getColor(float p_Value, class TColor3 * c) const;
};

class TBlueYellowMap : public virtual TColorMap
{
public:
	virtual void getColor(float p_Value, class TColor3 * c) const;
};

class TDecompositionColorMap : public virtual TColorMap
{
public:
	virtual void getColor(float p_Value, class TColor3 * c) const;
};

class TDecomposition2ColorMap : public virtual TColorMap
{
public:
	virtual void getColor(float p_Value, class TColor3 * c) const;
};



class TColorizeColorMap : public virtual TColorMap
{
public:
	TColor3 m_Color;
	TColorizeColorMap();
	virtual void getColor(float p_Value, class TColor3 * c) const;
};


class TColorMapUsingMeasure  : public virtual TColorMap
{
public:
//	enum COLORMAPTYPE { COLORMAPTYPE_NONE, COLORMAPTYPE_CONTINUOUS, COLORMAPTYPE_NORMALIZED, COLORMAPTYPE_MONOCHROME, COLORMAPTYPE_HEATMAP };

	TColorMapUsingMeasure(shared_ptr<class TMeasure> * const);
	virtual ~TColorMapUsingMeasure() {};

	// Accessors
//	virtual COLORMAPTYPE getColorMapType() const = 0;
	virtual string getName() const = 0;

	// Methods
	virtual void getColor(const class TCoord3 & p_Coord, class TColor3 * c) const = 0;
	virtual void getColor(unsigned int idx, class TColor3 * c) const = 0;
	virtual void init();
	virtual void DrawGui(class wxWindow * p_Window);

	shared_ptr<class TMeasure> * const m_Measure;
protected:
};

class TColorMapUsingMeasurePanel : public wxPanel
{
public:
	TColorMapUsingMeasurePanel(TColorMapUsingMeasure * p_ColorMap, wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL);
		// Using shared_ptr<TContinuousMap> would require header <boost/enable_shared_from_this.hpp> 

protected:
	enum { ID_MANUAL, ID_LOWERVALUE, ID_UPPERVALUE, ID_UPDATE };

	class TColorMapUsingMeasure * m_ColorMap;
	class wxSpinCtrlForFloats * m_SpinCtrlLower;
	class wxSpinCtrlForFloats * m_SpinCtrlUpper;

	class wxButton * m_UpdateButton;

	void OnChangeLower(class wxCommandEvent & event);
	void OnChangeUpper(class wxCommandEvent & event);
	void OnUpdateButton(class wxCommandEvent & event);

};




class TNormalizedColorMapUsingMeasure : public TColorMapUsingMeasure, public TNormalizedColorMap
{
public:
	TNormalizedColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TNormalizedColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "rainbow map"; }
	virtual string getName() const { return TNormalizedColorMapUsingMeasure::getStaticName(); }

	// Methods
	virtual void getColor(const class TCoord3 & p_Coord, class TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;
protected:
};



class TMonochromeColorMapUsingMeasure : public TColorMapUsingMeasure, public TMonochromeColorMap
{
public:
	TMonochromeColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TMonochromeColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "monochrome colormap"; }
	virtual string getName() const { return TMonochromeColorMapUsingMeasure::getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};

class TInverseMonochromeColorMapUsingMeasure : public TColorMapUsingMeasure, public TInverseMonochromeColorMap
{
public:
	TInverseMonochromeColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TInverseMonochromeColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "inverse monochrome colormap"; }
	virtual string getName() const { return TInverseMonochromeColorMapUsingMeasure::getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};



class THeatMapUsingMeasure : public TColorMapUsingMeasure, public THeatMap
{
public:
	THeatMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~THeatMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "heat map"; }
	virtual string getName() const { return getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};

class TBlueYellowMapUsingMeasure: public TColorMapUsingMeasure, public TBlueYellowMap
{
public:
	TBlueYellowMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TBlueYellowMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "blue/yellow map"; }
	virtual string getName() const { return getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};

class TDecompositionColorMapUsingMeasure: public TColorMapUsingMeasure, public TDecompositionColorMap
{
public:
	TDecompositionColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TDecompositionColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "decomposition map"; }
	virtual string getName() const { return getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};


class TDecomposition2ColorMapUsingMeasure: public TColorMapUsingMeasure, public TDecomposition2ColorMap
{
public:
	TDecomposition2ColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TDecomposition2ColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "decomposition2 map"; }
	virtual string getName() const { return getStaticName(); }

	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;

protected:
};



class TColorizeColorMapUsingMeasure: public TColorMapUsingMeasure, public TColorizeColorMap
{
public:
	TColorizeColorMapUsingMeasure(shared_ptr<TMeasure> * const);
	virtual ~TColorizeColorMapUsingMeasure() {};

	// Accessors
	static string getStaticName() { return "colorize map"; }
	virtual string getName() const { return getStaticName(); }



	// Methods
	void getColor(const TCoord3 & p_Coord, TColor3 * c) const;
	virtual void getColor(unsigned int idx, class TColor3 * c) const;
	virtual void DrawGui(class wxWindow * p_Window);

protected:
};

class TColorizeColorMapPanel : public wxPanel
{
public:
	TColorizeColorMapPanel(TColorizeColorMapUsingMeasure * p_ColorMap, wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxTAB_TRAVERSAL);
		// Using shared_ptr<TContinuousMap> would require header <boost/enable_shared_from_this.hpp> 

protected:
	enum { ID_MANUAL, ID_RED, ID_GREEN, ID_BLUE, ID_UPDATE };

	class TColorizeColorMapUsingMeasure * m_ColorMap;
	class wxSpinCtrlForFloats * m_SpinCtrlRed;
	class wxSpinCtrlForFloats * m_SpinCtrlGreen;
	class wxSpinCtrlForFloats * m_SpinCtrlBlue;

	class wxButton * m_UpdateButton;

	void OnChangeRed(class wxCommandEvent & event);
	void OnChangeGreen(class wxCommandEvent & event);
	void OnChangeBlue(class wxCommandEvent & event);
	void OnUpdateButton(class wxCommandEvent & event);
};




#endif
