#include "stdafx.h"

#include "component.h"

#include "globals.h"
#include "shortestpath.h"

TComponentSet::TComponentSet(const class TShortestPathSet * p_Sps, float p_DilationDistance)
{
	if(!p_Sps->m_PathSet) throw string("!p_Sps->m_PathSet");
	if(p_DilationDistance == 0.0f) p_DilationDistance = g_Parameters.m_DilationDistance;
	TIndexedOrigins_Vector DilatedShortestPaths;
	g_Mediator.getSkeletonizer()->Omega->m_DeltaOmega->dilate(p_DilationDistance, p_Sps->m_PathSet.get(), &DilatedShortestPaths);
	g_Mediator.getSkeletonizer()->Omega->m_DeltaOmega->computeComponentSetUsingCells(&DilatedShortestPaths, this, true);

	// First element in m_Cells was due to shortest-path set itself, but is now removed
	/*
	unsigned int x;
	vector< shared_ptr<TIndexedOrigins_Cells> > NewCells;
	for(x=1; x<m_Cells.size(); x++)
	{
		NewCells.push_back( m_Cells[x] );
	}
	m_Cells = NewCells;
	*/
}

float TComponentSetFieldMeasure_MaximumArea::toFloat(const TCoord3 & p) const
{
	unsigned int x;
	unsigned int totalcount = 0;
	unsigned int maxcount = 0;
	TComponentSet * cs = m_Field->vvaluep(p);
	for(x=0; x<cs->m_Cells.size(); x++)
	{
		totalcount += cs->m_Cells[x]->vertexcount();
		if( cs->m_Cells[x]->vertexcount() > maxcount ) maxcount = cs->m_Cells[x]->vertexcount();
	}
	return totalcount-maxcount;
}

float TComponentSetFieldMeasure_MaximumArea::vvaluex(const unsigned int p_Idx) const
{
	unsigned int x;
	unsigned int totalcount = 0;
	unsigned int maxcount = 0;
	TComponentSet * cs = m_Field->vvaluex(p_Idx);
	for(x=0; x<cs->m_Cells.size(); x++)
	{
		totalcount += cs->m_Cells[x]->vertexcount();
		if( cs->m_Cells[x]->vertexcount() > maxcount ) maxcount = cs->m_Cells[x]->vertexcount();
	}
	return totalcount-maxcount;
}

bool TComponentSet::isOnLoop() const
{
	return m_UniqueCells.size() != m_Border2Cell.size();
}

void TComponentSet::simplify(TCoord3 p) // const TShortestPathSet * sps, TTypedFieldInterface<unsigned int>* TempField)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	TDeltaOmega * DO = skel->Omega->m_DeltaOmega.get();

	TComponentSet * cs = this;
	// Filter components
	vector<float> Extrusion;
	Extrusion.resize( cs->m_Border2Cell.size(), 0.0f );
	for(unsigned int y=0; y<cs->m_Border2Cell.size(); y++)
	{
		// First compute maximum distance to border
		float maxdistance = 0.0f;
		const TIndexedOrigins_Vector & border = *cs->m_Borders.at(y).get();
		for(unsigned int z=0; z<border.size(); z++)
		{
			const TCoord3 q = skel->m_BoundaryIndexField->vidx2coord( border.at(z) );
			const float dist = p.distance2(q);
			if(dist > maxdistance) maxdistance = dist;
		}
		maxdistance = sqrtf(maxdistance);

		// Compute a measure needed for good junction detection
		TIndexedOrigins_Cells * cell = cs->m_Border2Cell.at(y).get();
		shared_ptr<TIndexedOrigins::TIterator> it( cell->newIterator() );
		it->init();
		while(it->valid())
		{
			const TCoord3 q = skel->m_BoundaryIndexField->vidx2coord( it->value() );
			const float dist = p.distance(q);
			if(dist > 1.1f * maxdistance)
			{
				Extrusion.at(y) += 1;
			}
			it->next();
		}
	}		

	vector<shared_ptr<TIndexedOrigins_Vector> > NewBorders;
	vector<shared_ptr<TIndexedOrigins_Cells> > NewBorder2Cell;
	vector<shared_ptr<TIndexedOrigins_Cells> > NewCells;
	NewCells.push_back( cs->m_Cells.at(0) );


	cs->m_UniqueCells.clear();
	for(unsigned int y=0; y<cs->m_Border2Cell.size(); y++)
	{
		const float size = (float)cs->m_Border2Cell.at(y)->vertexcount() / (float)skel->Omega->m_BoundaryIndexField->getMaxIndex();
		if(
			size > g_Parameters.m_RobustComponentTau
			&& Extrusion[y] > 5
			)
		{
			NewBorders.push_back( cs->m_Borders.at(y) );
			
			NewBorder2Cell.push_back( cs->m_Border2Cell.at(y) );
			NewCells.push_back( cs->m_Border2Cell.at(y) );
			cs->m_UniqueCells.insert( cs->m_Border2Cell.at(y) );
		}
		else
		{
			shared_ptr<TIndexedOrigins::TIterator> it( cs->m_Border2Cell[y]->newIterator() );
			it->init();
			while(it->valid())
			{
				NewCells[0]->add( DO->m_Vertex2Cells[it->value()].back()  );
				it->next();
			}
		}
	}

	cs->m_Borders = NewBorders;
	cs->m_Border2Cell = NewBorder2Cell;
	cs->m_Cells = NewCells;

}

void TComponentSet::computeBorderLengths(TTypedFieldInterface<unsigned int>* TempField) 
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();
	for(unsigned int x=0; x<this->m_Borders.size(); x++)
	{
		unsigned int y;
		for(y=0; y<m_Borders[x]->size(); y++)
		{
			TempField->wvaluex((*m_Borders[x])[y]) = 1;
		}
		TempField->getLayer()->m_Filter->m_LowerValue = 0.5f; 
		TempField->getLayer()->m_Filter->m_UpperValue = 1.5f; 
		
		TDeltaOmega::TDistancePropagationParameters par;
		if(m_BorderEft[x]->size() != 0) 
		{
			par.m_Start = m_BorderEft[x]->at(0);
			par.m_DomainFilter = TempField->getLayer()->m_Filter.get();
			
			skel->Omega->m_DeltaOmega->distancePropagation( par );


			m_BorderLengths.push_back( par.m_OutputEndDistance * 2.0f );
			const TCoord3 begin = skel->m_BoundaryIndexField->vidx2coord(par.m_Start);
			const TCoord3 end = skel->m_BoundaryIndexField->vidx2coord(par.m_OutputEndIdx);
			m_BorderDiameters.push_back( begin.distance(end) );
		}
		for(y=0; y<m_Borders[x]->size(); y++)
		{
			TempField->wvaluex((*m_Borders[x])[y]) = 0;
		}
	}
}

float TComponentSet::getMinBorderLength() const
{
	float min = (std::numeric_limits<float>::max)();
	for(unsigned int x=0; x<this->m_BorderLengths.size(); x++)
	{
//		if(this->m_Borders[x]->size() < min) min = this->m_Borders[x]->size();
		if(this->m_BorderLengths[x] < min) min = this->m_BorderLengths[x];
	}
	return min;
}	

float TComponentSet::getMaxBorderLength() const
{
	float max = -(std::numeric_limits<float>::max)();
	for(unsigned int x=0; x<this->m_BorderLengths.size(); x++)
	{
		//if(this->m_Borders[x]->size() > max) max = this->m_Borders[x]->size();
		if(this->m_BorderLengths[x] > max) max = this->m_BorderLengths[x];
	}
	return max;
}	

void TComponentSet::projectEft(const TShortestPathSet * sps, TTypedFieldInterface<unsigned int>* TempField)
{
	TSkeletonizer * skel = g_Mediator.getSkeletonizer().get();

	// Project eft to boundaries
	for(unsigned int y=0; y<this->m_Borders.size(); y++)
	{
		TIndexedOrigins_Vector * vec = this->m_Borders[y].get();
		unsigned int z;
		for(z=0; z<vec->size(); z++) TempField->wvaluex( (*vec)[z] ) = 1;

		set<unsigned int> eft;
	
		//for(unsigned int a=0; a<sps->m_Eft->size(); a++)
		for(unsigned int a=0; a<sps->m_Seft->size(); a++)
		{
			float Distance;
			//const unsigned int nearestidx = skel->Omega->m_DeltaOmega->findNearestNonZero( (*sps->m_Eft)[a], TempField, Distance );
			const unsigned int nearestidx = skel->Omega->m_DeltaOmega->findNearestNonZero( (*sps->m_Seft)[a], TempField, Distance );
			eft.insert(nearestidx);
		}

		for(z=0; z<vec->size(); z++) TempField->wvaluex( (*vec)[z] ) = 0;

		{
			std::set<unsigned int>::iterator it;
			shared_ptr<TIndexedOrigins_Vector> neweft( new TIndexedOrigins_Vector() );
			this->m_BorderEft.push_back( neweft );
			for(it = eft.begin(); it != eft.end(); it++)
			{
				neweft->push_back(*it);
			}
		}
	}

}

TComponentSet::TCellSizes TComponentSet::getCellSizes()
{
	TCellSizes sizes;
	for(unsigned int x=1; x<m_Cells.size(); x++)
	{
		if(!m_Cells[x]) continue;
		const float size = m_Cells[x]->vertexcount();
		sizes.insert( TCellSizes::value_type( size, m_Cells[x]) );
	}
	return sizes;
}

