#ifndef COMPONENT_H
#define COMPONENT_H

#include "stdafx.h"
#include <vector>
using std::vector;
#include <memory>
using std::shared_ptr;

#include "indexedorigins_cells.h"
#include "skeletonizer.h"


class TComponentSet 
{
public:
	unsigned int count() const { return m_Cells.size(); }
	TComponentSet(const class TShortestPathSet * p_Sps, float p_DilationDistance = 0.0f);
	TComponentSet(const TCoord3 p_Coord)
	{
	}
	typedef multimap<float, shared_ptr<TIndexedOrigins_Cells> > TCellSizes;
	TCellSizes getCellSizes();
	bool isOnLoop() const;

	TCoord3 m_Coord;
	vector<shared_ptr<TIndexedOrigins_Cells> > m_Cells;
	vector<shared_ptr<TIndexedOrigins_Vector> > m_Borders;
	vector<shared_ptr<TIndexedOrigins_Vector> > m_BorderEft;
	vector<shared_ptr<TIndexedOrigins_Cells> > m_Border2Cell;
	set<shared_ptr<TIndexedOrigins_Cells> > m_UniqueCells;

	vector<float > m_BorderLengths;
	vector<float > m_BorderDiameters;
	
	void simplify(TCoord3 p);
	void projectEft(const class TShortestPathSet * sps, TTypedFieldInterface<unsigned int>* TempField);
	float getMinBorderLength() const;
	float getMaxBorderLength() const;
	void computeBorderLengths(TTypedFieldInterface<unsigned int>* TempField);
protected:
	
};



class TComponentSetFieldMeasure_Count : public TTypedMeasure<TComponentSet*>
{
public:
	TComponentSetFieldMeasure_Count(TTypedFieldInterface<TComponentSet*> * p_Field) 
		: TTypedMeasure<TComponentSet*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const { return m_Field->vvaluep(p) ? m_Field->vvaluep(p)->count() : 0; }
	virtual float vvaluex(const unsigned int x) const { return m_Field->vvaluex(x) ? m_Field->vvaluex(x)->count() : 0; }
	virtual string getName() const { return "component count"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COMPONENTSET_COUNT; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COMPONENTSET; }
	virtual TMeasure * create(TField * p_Field) const { return new TComponentSetFieldMeasure_Count(static_cast<TTypedFieldInterface<TComponentSet*>*>(p_Field)); }
};

class TComponentSetFieldMeasure_MaximumArea : public TTypedMeasure<TComponentSet*>
{
public:
	TComponentSetFieldMeasure_MaximumArea(TTypedFieldInterface<TComponentSet*> * p_Field) 
		: TTypedMeasure<TComponentSet*>(p_Field) {};

	virtual float toFloat(const TCoord3 & p) const; 
	virtual float vvaluex(const unsigned int x) const;
	virtual string getName() const { return "maximum area"; };
	virtual MEASURETYPE getMeasureType() const { return MEASURETYPE_COMPONENTSET_MAXAREA; }
	virtual TType::TYPE getSourceType() const { return TType::TYPE_COMPONENTSET; }
	virtual TMeasure * create(TField * p_Field) const { return new TComponentSetFieldMeasure_MaximumArea(static_cast<TTypedFieldInterface<TComponentSet*>*>(p_Field)); }
};

class TComponentSetField : public TPointerSparseTypedField<TComponentSet*>
{
public:
	TComponentSetField(shared_ptr<TIndexMapper> p_IndexField)
		: TPointerSparseTypedField<TComponentSet*>(p_IndexField)
	{
	}
	virtual ~TComponentSetField() 
	{ 
		clear(); 
	}
	virtual const string getTypeName() { return "component set"; }
	virtual TType::TYPE getType() const { return TType::TYPE_COMPONENTSET; }
	virtual void accept(TFieldVisitor * v) { v->visitComponentSetField(this); }
	virtual shared_ptr<TMeasure> getDefaultMeasure() { return shared_ptr<TMeasure>(new TComponentSetFieldMeasure_Count(this)); }
	virtual void writeValueToStream(unsigned int x, std::ofstream * s) const 
	{ 
		throw string("Not implemented");
//		vvaluex(x)->writeToStream(s);
	}
	virtual void readValueFromStream(unsigned int x, std::ifstream * s) 
	{ 
		throw string("Not implemented");
//		wvaluex(x) = TShortestPathSet::readFromStream(s);
	}
	static TComponentSetField * readFromStream(std::ifstream * s, shared_ptr<TIndexMapper> p_IndexField);
};



#endif
