#include "stdafx.h"

#include "controls.h"

wxSpinCtrlForFloats::wxSpinCtrlForFloats(wxWindow* parent, wxWindowID id, int p_Min, int p_Max, float p_Rate, float p_Default, const wxPoint& pos, const wxSize& size)
	: wxPanel(parent, -1, pos, size), m_Min(p_Min), m_Max(p_Max), m_Rate(p_Rate) , m_ID(id)
{
	if(m_Rate < 0.0001f) m_Rate = 0.0001f; // This is necessary because of truncation in ' sprintf("%2.5f") '
//	if(p_Default > (float)m_Max*m_Rate) p_Default = (float)m_Max*m_Rate;
//	if(p_Default < (float)m_Min*m_Rate) p_Default = (float)m_Min*m_Rate;

	int decimals = (int) floor( log10(m_Rate) );
	if(decimals > 0) decimals = 0;
	else decimals = abs(decimals);
	if(p_Default > 100000) p_Default = 100000;
	m_Format = wxString("%.") + wxString::Format("%.2i", decimals) + "f";
	wxString b = wxString::Format(m_Format, p_Default);
	//char b[32];
	//sprintf(b, m_Format.c_str(), p_Default);

	wxBoxSizer * Sizer = new wxBoxSizer( wxHORIZONTAL );
	Sizer->Add( 
		m_TextCtrl = new wxTextCtrl(this, 0, b, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER ), 
		1, 
		wxEXPAND, 
		0 );
	Sizer->Add( 
		m_SpinButton = new wxSpinButton(this, 1, wxDefaultPosition, wxDefaultSize, wxSP_VERTICAL ), 
		0, 
		wxEXPAND | wxALL, 
		0 );
	m_SpinButton->SetRange(m_Min, m_Max);
//	int value = (int) ((p_Default / m_Rate) + 0.5f);
//	m_SpinButton->SetValue( value ); // round to nearest 'tick'
	SetValue(p_Default);

	Sizer->SetMinSize(size);
	this->SetSizer(Sizer);
	Sizer->SetSizeHints(this);
}

BEGIN_EVENT_TABLE(wxSpinCtrlForFloats, wxPanel)
	EVT_TEXT_ENTER(0, wxSpinCtrlForFloats::OnEnter)
	EVT_SPIN(1, wxSpinCtrlForFloats::OnSpin)
END_EVENT_TABLE()

void wxSpinCtrlForFloats::OnEnter(wxCommandEvent & event)
{
	const wxString s = event.GetString();
	float f;
	if( sscanf(s.c_str(), "%f", &f) )
	{
		//const int newvalue = (int)((f+m_Rate/2) / m_Rate);
		//m_TextCtrl->SetText(
		SetValue( f );
		m_TextCtrl->SetSelection(-1,-1);

		// Create new event with the user specified event id m_ID
		wxCommandEvent NewEvent(wxEVT_COMMAND_SPINCTRL_UPDATED,m_ID);
	    NewEvent.SetEventObject(this);
		GetParent()->ProcessWindowEvent(NewEvent);
	}
}

void wxSpinCtrlForFloats::OnSpin(wxSpinEvent & event)
{
	int i = event.GetInt();
	char b[32];
	sprintf(b, m_Format.c_str(), i * m_Rate);
	m_TextCtrl->SetValue(b);

	// Create new event with the user specified event id m_ID
	wxCommandEvent NewEvent(wxEVT_COMMAND_SPINCTRL_UPDATED,m_ID);
    NewEvent.SetEventObject(this);
	GetParent()->ProcessWindowEvent(NewEvent);
}

float wxSpinCtrlForFloats::GetFloat()
{
	float f = 0;
	wxString v = m_TextCtrl->GetValue(); 
	if(v.c_str() != (char*)0)
		sscanf(v.c_str(), "%f", &f);
	return f;
}

void wxSpinCtrlForFloats::SetValue(float v)
{
	int spinvalue = (int) ((v / m_Rate) + 0.5f);
	float value = spinvalue * m_Rate;
//	if(value == 0.0f) value = 0.01f;

	m_TextCtrl->SetValue(wxString::Format("%2.2f", value));
	m_SpinButton->SetValue(spinvalue);
}







wxSpinCtrlForInts::wxSpinCtrlForInts(wxWindow* parent, wxWindowID id, int p_Min, int p_Max, int p_Default, const wxPoint& pos, const wxSize& size)
	: wxPanel(parent, -1, pos, size), m_Min(p_Min), m_Max(p_Max), m_ID(id)
{
	char b[32];
	sprintf(b, "%i", p_Default);
	if(p_Default > m_Max) p_Default = m_Max;
	if(p_Default < m_Min) p_Default = m_Min;

	wxBoxSizer * Sizer = new wxBoxSizer( wxHORIZONTAL );
	Sizer->Add( 
		m_TextCtrl = new wxTextCtrl(this, 0, b, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER ), 
		1, 
		wxEXPAND, 
		0 );
	Sizer->Add( 
		m_SpinButton = new wxSpinButton(this, 1, wxDefaultPosition, wxDefaultSize, wxSP_VERTICAL ), 
		0, 
		wxEXPAND | wxALL, 
		0 );
	m_SpinButton->SetRange(m_Min, m_Max);
	m_SpinButton->SetValue( p_Default ); // round to nearest 'tick'

	Sizer->SetMinSize(size);
	this->SetSizer(Sizer);
	Sizer->SetSizeHints(this);
}

BEGIN_EVENT_TABLE(wxSpinCtrlForInts, wxPanel)
	EVT_TEXT_ENTER(0, wxSpinCtrlForInts::OnEnter)
	EVT_SPIN(1, wxSpinCtrlForInts::OnSpin)
END_EVENT_TABLE()

void wxSpinCtrlForInts::OnEnter(wxCommandEvent & event)
{
	const wxString s = event.GetString();
	int i;
	if( sscanf(s.c_str(), "%i", &i) )
	{
		// Create new event with the user specified event id m_ID
		wxCommandEvent NewEvent(wxEVT_COMMAND_SPINCTRL_UPDATED,m_ID);
	    NewEvent.SetEventObject(this);
		GetParent()->ProcessWindowEvent(NewEvent);
	}
}

void wxSpinCtrlForInts::OnSpin(wxSpinEvent & event)
{
	int i = event.GetInt();
	char b[32];
	sprintf(b, "%i", i);
	m_TextCtrl->SetValue(b);

	// Create new event with the user specified event id m_ID
	wxCommandEvent NewEvent(wxEVT_COMMAND_SPINCTRL_UPDATED,m_ID);
    NewEvent.SetEventObject(this);
	GetParent()->ProcessWindowEvent(NewEvent);
}

int wxSpinCtrlForInts::GetInteger()
{
	int i = 0;
	wxString v = m_TextCtrl->GetValue(); 
	if(v.c_str() != (char*)0)
		sscanf(v.c_str(), "%i", &i);
	return i;
}

void wxSpinCtrlForInts::SetValue(int v)
{
	m_TextCtrl->SetValue(wxString::Format("%i",v));
	m_SpinButton->SetValue(v);
}






wxSliderWithTextCtrlForInts::wxSliderWithTextCtrlForInts(wxWindow* parent, wxWindowID p_ID, int p_Min, int p_Max, int p_Default, const wxPoint& pos, const wxSize& size)
	: wxPanel(parent, -1, pos, size), m_Min(p_Min), m_Max(p_Max), m_ID(p_ID)
{
	char b[32];
	sprintf(b, "%i", p_Default);

	wxBoxSizer * Sizer = new wxBoxSizer( wxHORIZONTAL );
	Sizer->Add( 
		m_TextCtrl = new wxTextCtrl(this, 0, b, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER ), 
		0,
		wxEXPAND, 
		0 );
	Sizer->Add( 
		m_Slider = new wxSlider(this, 1, p_Default, m_Min, m_Max, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_AUTOTICKS ), 
		1, 
		wxEXPAND | wxALL, 
		0 );
	m_Slider->SetTickFreq( m_Max / 10 );

	Sizer->SetMinSize(size);
	this->SetSizer(Sizer);
	Sizer->SetSizeHints(this);

	this->Connect( 1, wxEVT_COMMAND_SLIDER_UPDATED, (wxObjectEventFunction) &wxSliderWithTextCtrlForInts::OnSpin );
}

void wxSliderWithTextCtrlForInts::OnEnter(wxCommandEvent & event)
{
	const wxString s = event.GetString();
	int i;
	if( sscanf(s.c_str(), "%i", &i) )
	{
		m_Slider->SetValue(i);
	}
}

void wxSliderWithTextCtrlForInts::OnSpin(wxSpinEvent & event)
{
	int i = event.GetInt();
	char b[32];
	sprintf(b, "%i", i);
	m_TextCtrl->SetValue(b);

	// Create new event with the user specified event id m_ID
	wxCommandEvent NewEvent(wxEVT_COMMAND_SLIDER_UPDATED,m_ID);
    NewEvent.SetEventObject(this);
	NewEvent.SetInt(i);
	GetParent()->ProcessWindowEvent(NewEvent);
}

