#ifndef CONTROLS_H
#define CONTROLS_H

#include "stdafx.h"
#include "wx/wxprec.h"
#include "wx/panel.h"
#include "wx/textctrl.h"
#include "wx/spinbutt.h"
#include "wx/spinctrl.h"


class wxSpinCtrlForFloats : public wxPanel
{
public:
	wxSpinCtrlForFloats(wxWindow* parent, wxWindowID id, int p_Min, int p_Max, float p_Rate, float p_Default, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);

	float GetFloat();
	void SetValue(float v);
protected:
	void OnSpin(wxSpinEvent & event);
	void OnEnter(wxCommandEvent & event);
	wxTextCtrl * m_TextCtrl;
	wxSpinButton * m_SpinButton;
	
	float m_Rate;
	int m_Min;
	int m_Max;
	int m_ID;
	wxString m_Format;

	DECLARE_EVENT_TABLE()
};


class wxSpinCtrlForInts : public wxPanel
{
public:
	wxSpinCtrlForInts(wxWindow* parent, wxWindowID id, int p_Min, int p_Max, int p_Default, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);

	int GetInteger();
	void SetValue(int v);
protected:
	void OnSpin(wxSpinEvent & event);
	void OnEnter(wxCommandEvent & event);
	wxTextCtrl * m_TextCtrl;
	wxSpinButton * m_SpinButton;
	int m_Min;
	int m_Max;
	int m_ID;
	
	DECLARE_EVENT_TABLE()
};


class wxSliderWithTextCtrlForInts : public wxPanel
{
public:
	wxSliderWithTextCtrlForInts(wxWindow* parent, wxWindowID p_ID, int p_Min, int p_Max, int p_Default, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);

protected:
	wxTextCtrl * m_TextCtrl;
	wxSlider * m_Slider;
	int m_ID;
	int m_Min;
	int m_Max;

	void OnEnter(wxCommandEvent & event);
	void OnSpin(wxSpinEvent & event);
};




#endif

