#pragma once

#include "stdafx.h"

#include "geometry.h"

class TCoord3
{
public:
	typedef int Type;
	
	struct compare
	{
		bool operator()(const TCoord3 & s1, const TCoord3 & s2) const
		{
			if(s1.x < s2.x) return true;
			if(s1.x > s2.x) return false;

			if(s1.y < s2.y) return true;
			if(s1.y > s2.y) return false;

			return s1.z < s2.z;
		}
	};

	union
	{
		Type x;
		Type i;
	};
	union 
	{
		Type y;
		Type j;
	};
	union 
	{
		Type z;
		Type k;
	};

	TCoord3() : x(0),y(0),z(0) {};
	inline TCoord3(const Type p_x, const Type p_y, const Type p_z=0) : x(p_x),y(p_y),z(p_z) {};
	TCoord3(const class TCoord2 & c);

	int operator==(const TCoord3& c) const { return x==c.x && y==c.y && z==c.z; }

	int operator!=(const TCoord3& c) const { return x!=c.x || y!=c.y || z!=c.z; } 

	// Partial ordering for set<TCoord>
	bool operator<(const TCoord3& c) const 
	{ 
		if(x!=c.x) return x<c.x;
		if(y!=c.y) return y<c.y;
		if(z!=c.z) return z<c.z;
		return false;
	}
	
	inline float distance(const TCoord3 & c) const
	{
		const Type dx = (x-c.x);
		const Type dy = (y-c.y);
		const Type dz = (z-c.z);
		return sqrtf( (float)(dx*dx + dy*dy + dz*dz) );
	}

	inline int distance2(const TCoord3 & c) const 
	{
		const Type dx = x-c.x;
		const Type dy = y-c.y;
		const Type dz = z-c.z;
		return dx*dx + dy*dy + dz*dz;
	}

	inline TPoint3 toPoint() const
	{
		return TPoint3((float)x,(float)y,(float)z);
	}
	inline TVector3 toVector() const
	{
		return TVector3((float)x,(float)y,(float)z);
	}
};


class TCoord2
{
public:
	typedef short Type;
	
	struct compare
	{
		bool operator()(const TCoord2 & s1, const TCoord2 & s2) const
		{
			return s1.x<s2.x ? true : 
						(s1.x==s2.x ? s1.y < s2.y : false);
		}
	};

	union
	{
		Type x;
		Type i;
	};
	union 
	{
		Type y;
		Type j;
	};

	TCoord2() {};
	TCoord2(Type p_x, Type p_y) : x(p_x),y(p_y) {};
	TCoord2(const class TCoord3 & p) : x(p.x),y(p.y) {};

	int operator==(const TCoord2& c) const { return x==c.x && y==c.y; } 

	// Partial ordering for set<TCoord>
	bool operator<(const TCoord2& c) const 
	{ 
		if(x!=c.x) return x<c.x;
		if(y!=c.y) return y<c.y;
		return false;
	}
	
	inline float distance(const TCoord2 & c) const 
	{
		return sqrtf( (float)((x-c.x)*(x-c.x) + (y-c.y)*(y-c.y)) );
	}

	inline int distance2(const TCoord2 & c) const 
	{
		const int dx = (int)x-(int)c.x;
		const int dy = (int)y-(int)c.y;
		return dx*dx + dy*dy;
	}
};
