
#include "cpalet.h"

 
inline float* colormap_clamp(float value,float* c)
{
   const float dx=0.8f;

   value = (value<0)? 0 : (value>1)? 1 : value;
   value = (6-2*dx)*value+dx;
   c[0] = (3-fabs(value-4)-fabs(value-5))/2; if (c[0]<0) c[0] = 0;
   c[1] = (4-fabs(value-2)-fabs(value-4))/2; if (c[1]<0) c[1] = 0;
   c[2] = (3-fabs(value-1)-fabs(value-2))/2; if (c[2]<0) c[2] = 0;
   return c;
}



ColorLookupTable::~ColorLookupTable()
{  }

float* ContinuousLookupTable::map(float value,const float* range_,float* c_)
{
   static float C[3],R[2] = {0,1};
   float* c = (c_)? c_ : C; const float* range = (range_)? range_ : R;

   const float dx=0.8f; float rr = range[1]-range[0]; if (rr>1.0e-6) rr = 1.0/rr; 

   value = (value-range[0])*rr;
   value = (6-2*dx)*value+dx;
   c[0] = (3-fabs(value-4)-fabs(value-5))/2; if (c[0]<0) c[0] = 0; 
   c[1] = (4-fabs(value-2)-fabs(value-4))/2; if (c[1]<0) c[1] = 0; 
   c[2] = (3-fabs(value-1)-fabs(value-2))/2; if (c[2]<0) c[2] = 0;
   return c;
}



DiscreteLookupTable::DiscreteLookupTable(const char* f, int nl)
{
   FILE* fp = fopen(f,"r");				//  LOOKUP_TABLE <#entries, say n>
   if (!fp) return;					//  r1 g1 b1 a1
							//  . . . . . .
   char buf[20];					//  rn gn bn an
   fscanf(fp,"%s",buf);
   if (strcmp(buf,"LOOKUP_TABLE")) return;

   int nc,i; 	
   fscanf(fp,"%d",&nc);
   lut.resize((nl>0)? nl+2 : nc);

   float r,g,b,a;

   if (nl>0)						//make LUT for visualizing hierarchical levels
   {
      fscanf(fp,"%f%f%f%f",&r,&g,&b,&a);
      lut[nl+1].r=r; lut[nl+1].g=g; lut[nl+1].b=b;   	//fill-in selection color
      fscanf(fp,"%f%f%f%f",&r,&g,&b,&a);
      lut[nl].r=r; lut[nl].g=g; lut[nl].b=b;		//fill-in not-selected-area color

      for(i=0;i<nl;i++)
      {
         fscanf(fp,"%f%f%f%f",&r,&g,&b,&a);
         lut[i].r = r; lut[i].g = g; lut[i].b = b;	//copy in LUT only first 'nlevels' and last 2 colors
      }
   }
   else							//make LUT for visualizing domain decompo
      for(i=0;i<nc;i++)
      {
	 fscanf(fp,"%f%f%f%f",&r,&g,&b,&a);
	 lut[i].r = r; lut[i].g = g; lut[i].b = b;
      }	
}



float* DiscreteLookupTable::map(float value,const float* range_,float* c_)
{
   static float R[2] = {0,1};
   const float* range = (range_)? range_ : R;
 
   int N = lut.size();

   float rr = (range[1]-range[0]); if (rr>1.0e-6) rr = 1.0/rr;
   value = (N-1)*(value-range[0])*rr;
   int idx = int(value); if (idx<0) idx=0; if (idx>=N) idx=N-1;
   
   float* c;
   if (c_) { c_[0] = lut[idx].r; c_[1] = lut[idx].g; c_[2] = lut[idx].b; c = c_; }
   else c = &(lut[idx].r);

   return c;
}


	
		

