
#ifndef CPALET_H
#define CPALET_H

//#include "stdafx.h"

class 	ColorLookupTable
{
public:
	static void	hsv2rgb(const float* hsv,float* rgb);
	static void	rgb2hsv(const float* rgb,float* hsv);
	
	virtual	       ~ColorLookupTable();
	virtual float*	map(float v,const float* range,float* col) =0;
	
protected:

	static float 	cmax(float a,float b) { return (a>b)? a:b; }
	static float 	cmin(float a,float b) { return (a<b)? a:b; }
};
	
	
class	ContinuousLookupTable : public ColorLookupTable
{
public:
	float*		map(float v,const float* range,float* col);
};
	
class	DiscreteLookupTable : public ColorLookupTable
{
public:
	DiscreteLookupTable(const char*,int nlevels);
	float*		map(float v,const float* range,float* col);
	int		numColors();	
	
protected:
	
	struct COL { float r,g,b; };		
	vector<COL>	lut;
};		
	
	
inline int DiscreteLookupTable::numColors()
{  return lut.size();  }	


//-----------------------------------------------------------------
//
//  hsv2rgb:	Simple routine which converts from a HSV triple to
//		a RGB triple. Both have to be in the 0..1,0..1,0..1 
//		range
//


inline void ColorLookupTable::hsv2rgb(const float* hsv,float* rgb)
{
  int   hueCase = (int)(hsv[0] * 6);
  float frac 	= 6*hsv[0] - hueCase;
  float lx 	= hsv[2]*(1.0 - hsv[1]);
  float ly 	= hsv[2]*(1.0 - hsv[1]*frac);
  float lz 	= hsv[2]*(1.0 - hsv[1]*(1.0 - frac));

  switch (hueCase) 
  {
      case 0:
      case 6: rgb[0] = hsv[2]; rgb[1] = lz; rgb[2] = lx; break;		/* 0<hue<1/6   */
      case 1: rgb[0] = ly; rgb[1] = hsv[2]; rgb[2] = lx; break;		/* 1/6<hue<2/6 */
      case 2: rgb[0] = lx; rgb[1] = hsv[2]; rgb[2] = lz; break;		/* 2/6<hue<3/6 */
      case 3: rgb[0] = lx; rgb[1] = ly; rgb[2] = hsv[2]; break;		/* 3/6<hue/4/6 */
      case 4: rgb[0] = lz; rgb[1] = lx; rgb[2] = hsv[2]; break;		/* 4/6<hue<5/6 */
      case 5: rgb[0] = hsv[2]; rgb[1] = lx; rgb[2] = ly; break;		/* 5/6<hue<1   */
  }
}


inline void ColorLookupTable::rgb2hsv(const float* rgb, float* hsv)
{
   float M = cmax(rgb[0],cmax(rgb[1],rgb[2]));
   float m = cmin(rgb[0],cmin(rgb[1],rgb[2]));
   float d = M-m;

   hsv[2] = M;				//value == max(r,g,b)
   hsv[1] = (M>0.00001)? d/M : 0;	//saturation
   
   if (hsv[1]==0) hsv[0] = 0;		//achromatic case, hue is 0 by convention
   else					//chromatic case
   {
      if (rgb[0]==M)  		hsv[0] =     (rgb[1]-rgb[2])/d;
      else if (rgb[1]==M)	hsv[0] = 2 + (rgb[2]-rgb[0])/d;
      else 			hsv[0] = 4 + (rgb[0]-rgb[1])/d;
      hsv[0] /= 6;
      if (hsv[0]<0) hsv[0] += 1;
   }	
}

		

#endif

