#include "stdafx.h"

#include "danielsson3d.h"

/*
  Note:
  There is an error in Cuisenaire's thesis, in section 5.3 in the SSED algorithm, the lines
  test(p,(-1,0)) 
  and
  test(p,(0,-1)) 
  need to be swapped.

 */

#include "Geometry.h"
#include "field.h"
#include "indexedoriginsfield.h"
using namespace std;


void TDanielsson3dTolerance::test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz)
{
	const TCoord3 p(px,py,pz);
	const TCoord3 a(px+nx, py+ny, pz+nz);
	if ( 
		// Voxel must be inside but not on boundary
		m_IndexField->vinside(p) && m_Boundary->vcoord2idx(p) == TIndexMapper::OUTSIDE

		&& px+nx>=0 && py+ny>=0 && pz+nz>=0 
		&& px+nx<X && py+ny<Y && pz+nz<Z 
		)
	{
		TIndexedOrigins_Vector * Sa;
		
		// If a not on boundary
		if( m_Boundary->vcoord2idx(a) == TIndexMapper::OUTSIDE ) Sa = &(m_Origins)[ m_IndexField->valuep(a) ];
		
		// If a on boundary
		else 
		{
			static TIndexedOrigins_Vector temp;
			temp.clear();
			const int invlookup = m_Boundary->vcoord2idx(a);
			assert(invlookup != TIndexMapper::OUTSIDE);
			temp.push_back(invlookup);
			Sa = &temp;
		}
		TIndexedOrigins_Vector * Sp = &(m_Origins)[ m_IndexField->valuep(p) ];

		const unsigned int distp = Sp->size() > 0 ? m_Boundary->vidx2coord(*Sp->begin()).distance2(p) : (std::numeric_limits<unsigned int>::max)();

		// Insert S(a) into S(p)

		// Note that all voxel in Sa have the same distance to a, but need not have the same distance to p
		//const unsigned int dista = Sa->size() > 0 ? (*m_Boundary)[*Sa->begin()].distance2(p) : (numeric_limits<unsigned int>::max)();
		TIndexedOrigins_Vector::const_iterator it, jt;
		//unsigned int dista = distp;
		float dista = (float)distp;
		for(it = Sa->begin(); it != Sa->end(); it++) 
		{
			const float d = m_Boundary->vidx2coord(*it).distance(p);
			if( d < dista ) dista = d;
		}
		
		static TIndexedOrigins_Vector Stemp;
		Stemp.clear();
		Stemp.merge( Sp );
		Stemp.merge( Sa );
		Sp->clear();
		for(it = Stemp.begin(); it != Stemp.end(); it++)
		{
			//const unsigned int d = m_Boundary->idx2coord(*it).distance2(p);
			//if(d <= dista + m_Tolerance) 
			const float d = m_Boundary->vidx2coord(*it).distance(p);
			if(d <= dista + m_Tolerance) 
			{
				// See if *it not already in Sp
				for(jt = Sp->begin(); jt != Sp->end(); jt++) 
					if(*it == *jt) break;
				if( jt == Sp->end() )
				{
					// If not, then add *it
					Sp->push_back( *it );
					if(Sp->size() == m_MaxOriginCount) break; // parameter 
				}
			}
		}
	}

}

TDanielsson3dTolerance::TDanielsson3dTolerance(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, float p_Tolerance, unsigned int p_MaxOriginCount)
	: m_IndexField(p_IndexField)
	, m_Boundary(p_Boundary)
	, m_MaxOriginCount(p_MaxOriginCount)
	, m_Tolerance(p_Tolerance)
{
}

void TDanielsson3dTolerance::perform() 
{
	X = m_IndexField->getMaxX();
	Y = m_IndexField->getMaxY();
	Z = m_IndexField->getMaxZ();

	{
		//m_Origins.reset( new vector<TIndexedOrigins_Vector>() );
		TIndexedOrigins_Vector v;
		v.reserve(m_MaxOriginCount);
		m_Origins.resize( m_IndexField->getMaxIndex(), v );
	}

	int i,j,k;

	// forward Z
	for(k=0; k<Z; k++)
	{
		// forward Y
		for(j=0; j<Y; j++)
		{
			// F1
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
				test2(i,j,k,-1,0,0);
				test2(i,j,k,0,0,-1);
			}

			// F2
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,1,0,0);
			}
		}

		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// F3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,1,0);
			}
		}
	}

	// backward Z
	for(k=Z-1; k>=0; k--)
	{
		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// R1
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,0,1,0);
				test2(i,j,k,1,0,0);
				test2(i,j,k,0,0,1);
			}

			// R2
			for(i=0; i<X-1; i++)
			{
				test2(i,j,k,-1,0,0);
			}
		}

		// forward Y
		for(j=0; j<Y; j++)
		{
			// R3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
			}
		}
	}

				
	/*
	else if(m_NeighborCount == 8)
	{
		// forward scan
		for(j=0; j<N; j++)
		{
			for(i=0; i<M; i++)
			{
				test2(i,j,-1,-1);
				test2(i,j, 0,-1);
				test2(i,j, 1,-1);
				test2(i,j,-1,0);
			}
			for(i=M-1; i>=0; i--)
			{
				test2(i,j, 1,0);
			}
		}

		// backward scan
		for(j=N-1; j>=0; j--)
		{
			for(i=0; i<M; i++)
			{
				test2(i,j,-1, 1);
				test2(i,j, 0, 1);
				test2(i,j, 1, 1);
				test2(i,j,-1, 0);
			}

			for(i=M-1; i>=0; i--)
			{
				test2(i,j, 1, 0);
			}
		}
	}
	*/

}

// ---------------------------------------------------------------------------



void TDanielsson3d::test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz)
{
	const TCoord3 p(px,py,pz);
	const TCoord3 a(px+nx, py+ny, pz+nz);
	if ( 
		// Voxel must be inside but not on boundary
		m_IndexField->vinside(p) && m_Boundary->vcoord2idx(p) == TIndexMapper::OUTSIDE
		&& m_IndexField->vinside(a)

		//&& px+nx>=0 && py+ny>=0 && pz+nz>=0 
		//&& px+nx<X && py+ny<Y && pz+nz<Z 
		)
	{
		TIndexedOrigins_Vector * Sa;
		
		// If a not on boundary
		if( m_Boundary->vcoord2idx(a) == TIndexMapper::OUTSIDE ) 
		{
			Sa = &(m_Origins)[ m_IndexField->valuep(a) ];
		}
	
		// If a on boundary
		else 
		{
			static TIndexedOrigins_Vector temp;
			temp.clear();
			const int invlookup = m_Boundary->vcoord2idx(a);
			assert(invlookup != TIndexMapper::OUTSIDE);
			temp.push_back(invlookup);
			Sa = &temp;
		}
		TIndexedOrigins_Vector * Sp = &(m_Origins)[ m_IndexField->valuep(p) ];

		const unsigned int distp = Sp->size() > 0 ? m_Boundary->vidx2coord(*Sp->begin()).distance2(p) : (std::numeric_limits<unsigned int>::max)();

		// Insert S(a) into S(p)

		// Note that all voxel in Sa have the same distance to a, but need not have the same distance to p
		//const unsigned int dista = Sa->size() > 0 ? (*m_Boundary)[*Sa->begin()].distance2(p) : (numeric_limits<unsigned int>::max)();
		TIndexedOrigins_Vector::const_iterator it, jt;
		unsigned int dista = distp;
		for(it = Sa->begin(); it != Sa->end(); it++) 
		{
			const unsigned int d = m_Boundary->vidx2coord(*it).distance2(p);
			if( d < dista ) dista = d;
		}
		
		static TIndexedOrigins_Vector Stemp;
		Stemp.clear();
		Stemp.merge( Sp );
		Stemp.merge( Sa );
		Sp->clear();
		for(it = Stemp.begin(); it != Stemp.end(); it++)
		{
			const unsigned int d = m_Boundary->vidx2coord(*it).distance2(p);
			if(d <= dista) 
			{
				// See if *it not already in Sp
				for(jt = Sp->begin(); jt != Sp->end(); jt++) 
					if(*it == *jt) break;
				if( jt == Sp->end() )
				{
					// If not, then add *it
					Sp->push_back( *it );
					if(Sp->size() == m_MaxOriginCount) break; // parameter 
				}
			}
		}
	}

}

TDanielsson3d::TDanielsson3d(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, unsigned int p_MaxOriginCount)
	: m_IndexField(p_IndexField)
	, m_Boundary(p_Boundary)
	, m_MaxOriginCount(p_MaxOriginCount)
{
}

void TDanielsson3d::perform() 
{
	X = m_IndexField->getMaxX();
	Y = m_IndexField->getMaxY();
	Z = m_IndexField->getMaxZ();

	{
		//m_Origins.reset( new vector<TIndexedOrigins_Vector>() );
		TIndexedOrigins_Vector v;
		v.reserve(m_MaxOriginCount);
		m_Origins.resize( m_IndexField->getMaxIndex(), v );
	}

	int i,j,k;

	// forward Z
	for(k=0; k<Z; k++)
	{
		// forward Y
		for(j=0; j<Y; j++)
		{
			// F1
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
				test2(i,j,k,-1,0,0);
				test2(i,j,k,0,0,-1);
			}

			// F2
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,1,0,0);
			}
		}

		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// F3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,1,0);
			}
		}
	}

	// backward Z
	for(k=Z-1; k>=0; k--)
	{
		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// R1
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,0,1,0);
				test2(i,j,k,1,0,0);
				test2(i,j,k,0,0,1);
			}

			// R2
			for(i=0; i<X-1; i++)
			{
				test2(i,j,k,-1,0,0);
			}
		}

		// forward Y
		for(j=0; j<Y; j++)
		{
			// R3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
			}
		}
	}

	// Remove border of width 2 
	{
		for(i=0; i<X; i++)
		for(j=0; j<Y; j++)
		for(k=0; k<Z; k++)
		{
			const TCoord3 p(i,j,k);
			if (m_IndexField->vinside(p))
			{
				if
					(
					(i <= 1 || j <= 1 || k <= 1 )
					||
					(i >= X-2 || j >= Y-2 || k >= Z-2 )
					)
				{
					(m_Origins)[m_IndexField->valuep(p)].clear();
				}
			}
		}
	}

}







// ---------------------------------------------------------------------------



void TDanielsson3d2::test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz)
{
	const TCoord3 p(px,py,pz);
	const TCoord3 a(px+nx, py+ny, pz+nz);
	if ( 
		// Voxel must be inside but not on boundary
		m_IndexField->vinside(p) && m_Boundary->vcoord2idx(p) == TIndexMapper::OUTSIDE
		&& m_IndexField->vinside(a)

//		&& px+nx>=0 && py+ny>=0 && pz+nz>=0 
//		&& px+nx<X && py+ny<Y && pz+nz<Z 
		)
	{
		TIndexedOrigins_Vector * Sa;
		
		// If a not on boundary
		if( m_Boundary->vcoord2idx(a) == TIndexMapper::OUTSIDE || (m_Mask && m_Mask->vvaluep(a) == 0) ) 
		{
			unsigned int idx = m_IndexField->vvaluep(a);
			Sa = &(m_Origins)[idx];
		}
		
		// If a on boundary
		else 
		{
			static TIndexedOrigins_Vector temp;
			temp.clear();
			const int invlookup = m_Boundary->vcoord2idx(a);
			assert(invlookup != TIndexMapper::OUTSIDE);
			temp.push_back(invlookup);
			Sa = &temp;
		}
		TIndexedOrigins_Vector * Sp = &(m_Origins)[ m_IndexField->vvaluep(p) ];

		const unsigned int distp = Sp->size() > 0 ? m_Boundary->vidx2coord(*Sp->begin()).distance2(p) : (std::numeric_limits<unsigned int>::max)();


		// Insert S(a) into S(p)

		// Note that all voxel in Sa have the same distance to a, but need not have the same distance to p
		//const unsigned int dista = Sa->size() > 0 ? (*m_Boundary)[*Sa->begin()].distance2(p) : (numeric_limits<unsigned int>::max)();
		TIndexedOrigins_Vector::const_iterator it, jt;
		//unsigned int dista = distp;
		float dista = (float)distp;
		for(it = Sa->begin(); it != Sa->end(); it++) 
		{
			const float d = m_Boundary->vidx2coord(*it).distance(p);
			if( d < dista ) dista = d;
		}
		
		static TIndexedOrigins_Vector Stemp;
		Stemp.clear();
		Stemp.merge( Sp );
		Stemp.merge( Sa );
		Sp->clear();
		for(it = Stemp.begin(); it != Stemp.end(); it++)
		{
			//const unsigned int d = m_Boundary->idx2coord(*it).distance2(p);
			//if(d <= dista + m_Tolerance) 
			const float d = m_Boundary->vidx2coord(*it).distance(p);
			if(d <= dista + m_Tolerance) 
			{
				// See if *it not already in Sp
				for(jt = Sp->begin(); jt != Sp->end(); jt++) 
					if(*it == *jt) break;
				if( jt == Sp->end() )
				{
					// If not, then add *it
					Sp->push_back( *it );
					if(Sp->size() == m_MaxOriginCount) break; // parameter 
				}
			}
		}

	}

}

TDanielsson3d2::TDanielsson3d2(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, float p_Tolerance, unsigned int p_MaxOriginCount)
	: m_IndexField(p_IndexField)
	, m_Boundary(p_Boundary)
	, m_MaxOriginCount(p_MaxOriginCount)
	, m_Tolerance(p_Tolerance)
	, m_Mask(0)
{
}

void TDanielsson3d2::perform() 
{
	X = m_IndexField->getMaxX();
	Y = m_IndexField->getMaxY();
	Z = m_IndexField->getMaxZ();

	{
		//m_Origins.reset( new vector<TIndexedOrigins_Vector>() );
		TIndexedOrigins_Vector v;
		v.reserve(m_MaxOriginCount);
		m_Origins.resize( m_IndexField->getMaxIndex(), v );
	}

	int i,j,k;

	// forward Z
	for(k=0; k<Z; k++)
	{
		// forward Y
		for(j=0; j<Y; j++)
		{
			// F1
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
				test2(i,j,k,-1,0,0);
				test2(i,j,k,0,0,-1);
			}

			// F2
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,1,0,0);
			}
		}

		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// F3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,1,0);
			}
		}
	}

	// backward Z
	for(k=Z-1; k>=0; k--)
	{
		// backward Y
		for(j=Y-1; j>=0; j--)
		{
			// R1
			for(i=X-1; i>=0; i--)
			{
				test2(i,j,k,0,1,0);
				test2(i,j,k,1,0,0);
				test2(i,j,k,0,0,1);
			}

			// R2
			for(i=0; i<X-1; i++)
			{
				test2(i,j,k,-1,0,0);
			}
		}

		// forward Y
		for(j=0; j<Y; j++)
		{
			// R3
			for(i=0; i<X; i++)
			{
				test2(i,j,k,0,-1,0);
			}
		}
	}

/*
	// Remove border of width 2 
	{
		for(i=0; i<X; i++)
		for(j=0; j<Y; j++)
		for(k=0; k<Z; k++)
		{
			const TCoord3 p(i,j,k);
			if (m_IndexField->vinside(p))
			{
				if
					(
					(i <= 1 || j <= 1 || k <= 1 )
					||
					(i >= X-2 || j >= Y-2 || k >= Z-2 )
					)
				{
					(m_Origins)[m_IndexField->valuep(p)].clear();
				}
			}
		}
	}
*/
}

