#ifndef DANIELSSON3D_H
#define DANIELSSON3D_H

#include "stdafx.h"
#include "abstractfield.h"
#include "indexedorigins.h"

class TDanielsson3dTolerance
{
public:
	TDanielsson3dTolerance(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, float p_Tolerance = 0, unsigned int p_MaxOriginCount = 16);

	void perform();

//	shared_ptr<vector<TIndexedOrigins_Vector> > m_Origins;
	vector<TIndexedOrigins_Vector> m_Origins;
//	shared_ptr<class TIndexedOriginsField> m_Origins;
protected:
	float m_Tolerance;
	const unsigned int m_MaxOriginCount;
	const class TIndexField3 * m_IndexField;
	const class TIndexMapper * m_Boundary;

	void test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz);

	unsigned int X,Y,Z; 
};



class TDanielsson3d
{
public:
	TDanielsson3d(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, unsigned int p_MaxOriginCount = 16);

	void perform();
	vector<TIndexedOrigins_Vector> m_Origins;
protected:
	const unsigned int m_MaxOriginCount;
	const class TIndexField3 * m_IndexField;
	const class TIndexMapper * m_Boundary;

	void test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz);

	unsigned int X,Y,Z; 
};


class TDanielsson3d2
{
public:
	//TDanielsson3d2(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, unsigned int p_MaxOriginCount = (numeric_limits<unsigned int>::max)());
	TDanielsson3d2(const class TIndexField3 * p_IndexField, const class TIndexMapper * p_Boundary, float m_Tolerance = 0, unsigned int p_MaxOriginCount = 16 );
	void useMask(TTypedFieldInterface<unsigned char> * p_Mask) { m_Mask = p_Mask; }

	void perform();
	vector<TIndexedOrigins_Vector> m_Origins;

protected:
	const unsigned int m_MaxOriginCount;
	const class TIndexField3 * m_IndexField;
	const class TIndexMapper * m_Boundary;

	void test2(const int px, const int py, const int pz, const int nx, const int ny, const int nz);
	TTypedFieldInterface<unsigned char> * m_Mask;
	unsigned int X,Y,Z; 
	float m_Tolerance;
};

#endif
