#ifndef DELTAOMEGA_H
#define DELTAOMEGA_H


#include "stdafx.h"
#include "abstractfilter.h"
#include <queue>
using std::queue;
using std::pair;

#include "parameters.h"
#include "shortestpath.h"



class TDeltaOmega 
{
public:
	TDeltaOmega(class TOmega * p_Omega);
	virtual ~TDeltaOmega();

	typedef TIndexedOrigins::TIndex TIndex;
	enum { MAXNSIZE = 20 };
	const unsigned int CELLCOUNT;

	typedef map<pair<unsigned int,unsigned int>, shared_ptr<TShortestPath> > TGeodesicCache;
	typedef queue<pair<unsigned int,unsigned int> > TCacheQueue;

	float WEIGHTS[3];

	struct TEdge
	{
		TIndex m_ToVertex;
		char m_Weight; // 0 = 4-neighbor, 1 = 6-neighbor, 2 = 26-neighbor
	};

	struct TAdjacencyStruct
	{
		TEdge m_Edges[MAXNSIZE];
		unsigned int m_EdgeCount;
	};

	struct TAuxiliaryStruct
	{
		TAuxiliaryStruct();
		float m_Distance; // used for DijkstraShortestPath
		TIndex m_Previous; // used for DijkstraShortestPath
		bool m_IsKnown;
	};


	struct TFloodfillStruct
	{	
		TFloodfillStruct();
		unsigned int m_Component;
		bool m_NeighborsGeodesic;
	};

	struct TAllPathsStruct
	{	
		float m_Dist;
		bool m_IsKnown;
	};

	vector<TAuxiliaryStruct>				m_AuxiliaryList;
	TAuxiliaryStruct						m_InitialAuxiliaryList;

	shared_ptr< vector<TAuxiliaryStruct> > getLockedAuxiliaryList();
	void releaseLockedAuxiliaryList(shared_ptr< vector<TAuxiliaryStruct> > AuxiliaryList);


	std::set<shared_ptr<vector<TAuxiliaryStruct> > >			m_AuxiliaryListForDijkstra;
	vector<TFloodfillStruct>				m_ComponentList;
	TFloodfillStruct						m_InitialComponentList;

	std::set<shared_ptr<vector<TFloodfillStruct> > >			m_ComponentLists;
	shared_ptr< vector<TFloodfillStruct> > getLockedComponentList();
	void releaseLockedComponentList(shared_ptr< vector<TFloodfillStruct> > AuxiliaryList);


	
	class TCell // For boundary spatial-subdivison purposes.
	{
	public:
		const static unsigned int INVALIDCOMPONENT;

		TCell(TCell * const p_Parent, unsigned int p_Index)
			: m_Parent(p_Parent)
			, m_Index(p_Index)
			, m_FillComponent(TCell::INVALIDCOMPONENT)
		{
			m_Level = m_Parent ? m_Parent->m_Level + 1 : 0;
			m_Vertices.reserve(1);
		}

		enum TColor { COLOR_WHITE, COLOR_GRAY, COLOR_NEIGHBOR };
		TColor m_Color;

		TCell * const m_Parent;
		vector<TCell*> m_Neighbors; // neighbors of same level
		vector<TCell*> m_Children;
		TIndexedOrigins_Vector m_Vertices;
		unsigned int m_FillComponent;
		unsigned int m_Level;
		unsigned int m_Index;
		
		unsigned int getFillComponent() const
		{
			if(m_FillComponent != INVALIDCOMPONENT) return m_FillComponent;
			if(m_Parent) return m_Parent->getFillComponent();
			else return INVALIDCOMPONENT;
		}
	};


	// Data
//	shared_ptr<class TBoundary>				m_Boundary;
	vector<TAdjacencyStruct>				m_AdjacencyList;
	TGeodesicCache							m_Geodesics;
	TCacheQueue								m_CacheQueue;
	int										m_CacheSize;
	unsigned int							m_ComputedGeodesics; 

	vector< vector<TCell*> >				m_Cells;
	vector< vector<TCell*> >				m_Vertex2Cells;

	// Methods 
	void createSpatialSubdivision();
	void clearGeodesicCache();
	

	shared_ptr<TShortestPath> getShortestPath(unsigned int i, unsigned int j);
	float findShortestPath(unsigned int p_Start, unsigned int p_End, TAbstractFilter * p_DomainFilter);
	
	wxMutex m_MutexDijkstra;
	template<class T> float dijkstraSinglePath(TIndex p_Start, TIndex p_End, T * io, unsigned int * p_Middle = 0);
//	
	template<class T> float dijkstraAllPaths(TIndex p_Start, TIndex p_End, T * p_Io);
	float dijkstraSinglePathWithObstructions(TIndex p_Start, TIndex p_End, const TIndexedOrigins_Vector * p_Obstructions, TIndexedOrigins_Vector * p_Io, bool & p_Found);

	unsigned int floodfill(TIndex p_Index, unsigned int p_FillComponent);
	void floodfillUsingCells(TCell * p_Cell, unsigned int p_FillComponent);

	unsigned int computeCollapseUsingCells(const TIndexedOrigins_Vector * p_Geodesic, class TIndexedOrigins_Cells * p_Result);
	void computeComponentSetUsingCells(const TIndexedOrigins_Vector * p_Geodesic, class TComponentSet * p_Result, bool p_FillShortestPathSet = true);
	void computeComponentSetUsingCells2(const TIndexedOrigins_Vector * p_Geodesic, class TComponentSet * p_Result);

	void determineBoundary(const TIndexedOrigins_Vector * p_Collapse, TIndexedOrigins_Vector * p_Boundary);


	void dilate(float p_Amount, const TIndexedOrigins_Vector * p_Input, TIndexedOrigins_Vector * p_Output, bool p_Reset = true);

	void erode(const TIndexedOrigins_Vector * p_Input, TIndexedOrigins_Vector * p_Output);
	bool isLoop(const TIndexedOrigins_Vector * p_Io, int & p_Components, vector<shared_ptr<TIndexedOrigins_Vector> > * p_Boundaries = 0);
	bool isLoop2(const TIndexedOrigins_Vector * p_Eft, const TIndexedOrigins_Vector * p_Path, int & p_Components);

	void mergeCollapseWithOthers(const TIndexedOrigins_Set * p_Collapse, vector<TIndexedOrigins_Set*> & p_Others);
	void mergeCollapseWithOthers(const TIndexedOrigins_Set * p_MergeWhat, TTypedFieldInterface<unsigned int> * p_Field, set<unsigned int> & p_MergeWithComponents);
	void determineNeighborhoods(const TTypedFieldInterface<unsigned int> * p_Field, vector<set<unsigned int> > & p_Neighbors);

	float computeDistancesOnIndexes(unsigned int idx, const TIndexedOrigins_Vector * p_Domain, vector<float>* p_Output);

	void computeDistancesToNonZeros(const TTypedFieldInterface<unsigned int>* p_Input, TTypedFieldInterface<float>* p_Output, TTypedFieldInterface<unsigned int>* p_ClosestNonZero = 0);
	void computeDistancesOnFilterUsingSeed(unsigned int idx, const TFilter * p_Filter, TTypedFieldInterface<float>* p_Output);
	void computeDistanceFieldWithSeeds(const TTypedFieldInterface<float>* p_Input, TTypedFieldInterface<float>* p_Output, bool p_UseInputValue = true, const TTypedFieldInterface<float>* p_CostFunction = 0);
	void computeDistanceFieldWithSeedsAndDomain(TTypedFieldInterface<float>* p_Output, TTypedFieldInterface<unsigned int>* p_Domain, unsigned int p_DomainIdx);
	void computeDistanceFieldWithSeedsAndDomainFilter(const set<unsigned int> * p_Seeds, const TAbstractFilter * p_DomainFilter, TTypedFieldInterface<float>* p_Output, const TTypedFieldInterface<float>* p_CostFunction = 0, TTypedFieldInterface<unsigned int>* p_OutputSeeds = 0);
	void computeDistanceFieldWithSeedDistancesAndDomainFilter(const TTypedFieldInterface<float> *p_Input, const TAbstractFilter * p_DomainFilter, TTypedFieldInterface<float>* p_Output);
	 
	void makeMinColoring(TTypedFieldInterface<unsigned int> * p_Field);


	class TDistancePropagationParameters
	{
	public:
		TDistancePropagationParameters()
			: m_Start( (std::numeric_limits<unsigned int>::max)() )
			, m_End( (std::numeric_limits<unsigned int>::max)() )
			, m_StartSet(0)
			, m_StartVector(0)
			, m_EndSet(0)
			, m_DomainFilter(0)
			, m_OutputDistance(0)
			, m_OutputClosestStartPoint(0)
			, m_OutputEndDistance( (std::numeric_limits<float>::max)() )
			, m_CostFunction(0)
			, m_OutputPath(0)
			, m_TargetFilter(0)
			, m_OutputTargets(0)
			, m_StopDistance( (std::numeric_limits<float>::max)() )
		{
		};
		unsigned int m_Start; // Start from this point
		unsigned int m_End; // End at this point
		float m_StopDistance; // Stop after this distance reached
		set<unsigned int> * m_StartSet;
		set<unsigned int> * m_EndSet;
		vector<unsigned int> * m_StartVector;
		TAbstractFilter * m_DomainFilter;
		TAbstractFilter * m_TargetFilter;
		TTypedFieldInterface<float>* m_CostFunction;

		// Outputs
		set<unsigned int> * m_OutputTargets;
		TTypedFieldInterface<float>* m_OutputDistance;
		TTypedFieldInterface<unsigned int>* m_OutputClosestStartPoint;
		TIndexedOrigins_Vector * m_OutputPath;
		float m_OutputEndDistance;
		unsigned int m_OutputEndIdx;

	};
	void distancePropagation(TDistancePropagationParameters & p_Par);


	unsigned int findNearestNonZero(unsigned int p_Start, TTypedFieldInterface<unsigned int>* p_Field, float & p_Distance);
	unsigned int findNearestNonZero(vector<unsigned int> * p_Start, TTypedFieldInterface<unsigned int>* p_Field, float & p_Distance);
	unsigned int findNearestNonZero(set<unsigned int> * p_Start, TTypedFieldInterface<unsigned int>* p_Field, float & p_Distance);
	void findAllNonZerosWithinDistance(const unsigned int p_Start, const TTypedFieldInterface<unsigned int>* p_Field, const float p_Distance, vector<unsigned int> * p_Result, vector<float> * p_Distances = 0, TFilter * p_Filter = 0);
	void findAllNonZerosWithinDistance(set<unsigned int> * p_Start, const TTypedFieldInterface<unsigned int>* p_Field, const float p_Distance, vector<unsigned int> * p_Result, vector<float> * p_Distances = 0, TFilter * p_Filter = 0);
	unsigned int findNearestWithTargetFilterAndDomainFilter(unsigned int p_Start, float & p_Distance, TTypedFieldInterface<float> * p_Cost, const TAbstractFilter * p_TargetFilter, const TAbstractFilter * p_DomainFilter, TIndexedOrigins_Vector * p_Output);
	void getEquidistantNeighbors(const unsigned int p_Idx, const TCoord3 p, const float p_Tolerance, vector<unsigned int> * p_Neighbors);

	void fillZerosByPropagation(TTypedFieldInterface<TVector3>* p_Field);
	void fillZerosByPropagation(TTypedFieldInterface<unsigned int>* p_Field);
	void fillZerosByPropagation(TTypedFieldInterface<float>* p_Field);
	void fillZerosByPropagation(TTypedFieldInterface<TIndexedOrigins*>* p_Field);
	void fillZerosByPropagationUsingNormals(TTypedFieldInterface<unsigned int>* p_Field, const TTypedFieldInterface<TVector3>* p_BoundaryNormals, TTypedFieldInterface<TIndexedOrigins*>* p_DebugOrigins, float p_MaximumDot);
	void fillZerosByPropagationAndDomain(TTypedFieldInterface<unsigned int>* p_Field, TTypedFieldInterface<unsigned int>* p_Domain, unsigned int p_DomainIdx);
	void computeDtAndFt(const TTypedFieldInterface<unsigned int>* p_Seeds, unsigned int p_SeedId, TTypedFieldInterface<float> * p_Dt = 0, TTypedFieldInterface<TIndexedOrigins*>* p_Ft = 0);

	unsigned int findConnectedComponents(const TFilter * p_Filter, TTypedFieldInterface<unsigned int>* p_Output, bool p_InverseFilter, vector<set<unsigned int> > * p_Sizes = 0);
	void findConnectedComponents(const TIndexedOrigins_Vector * p_Input, vector<set<unsigned int> > * p_Sizes, bool p_Reset = true);



protected:

	// Priority queue defines
	typedef std::pair<float, TIndex> TPair;
	struct TPairLess
	{
		bool operator () ( const TPair& a, const TPair& b ) { return a.first > b.first; } 
	};
	typedef std::priority_queue< TPair, std::vector< TPair >, TPairLess > TQueue; 
	//typedef std::hash_map<float, TPair, hash<float>, eqstr> months;

	typedef std::multimap<float, TIndex> TQueue2; 

	// Data	
	class TOmega * m_Omega;
	
	vector<TIndex>					Visited;
	unsigned int					vc;


	// Methods
	void createSpatialSubdivision(const TIndexedOrigins_Vector * p_Io, unsigned int p_Level, TCell * p_Parent);
};


class TOmega
{
public:
	TOmega() {};
	virtual ~TOmega() 
	{
	};
	void initIndexFields(const class TUnsignedCharField3 * p_Image);
	void initDeltaOmega();
	void initFT();
	virtual void writeToStream(std::ofstream * s) const;
	static TOmega * readFromStream(std::ifstream * s);

	shared_ptr<class TDanielsson3d> m_ForegroundFt;
	shared_ptr<class TDanielsson3d> m_BackgroundFt;
	shared_ptr<class TDanielsson3d> m_FT;

	shared_ptr<class TDeltaOmega> m_DeltaOmega;
	shared_ptr<class TIndexField3> m_BackgroundIndexField;
	shared_ptr<class TIndexField3> m_ForegroundIndexField;
	
	shared_ptr<class TSubIndexMapper> m_BoundaryIndexField;
	shared_ptr<class TSubIndexMapper> m_BackgroundBoundaryIndexField;

protected:

};




#endif
